/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.model.api.extension;


/**
 * Extension adapter class for the IElementCommand. The subclasses must override the 
 * execute/undo/redo methods to implement their own command. All the command is undoable
 * and redoable by default.
 */

abstract public class ElementCommand implements IElementCommand
{

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.extension.IElementCommand#execute()
	 */
	
	abstract public void execute( );

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.extension.IElementCommand#undo()
	 */
	
	abstract public void undo( );

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.extension.IElementCommand#redo()
	 */
	
	abstract public void redo( );
	
	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.extension.IElementCommand#canUndo()
	 */
	
	public boolean canUndo( )
	{
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.extension.IElementCommand#canRedo()
	 */
	public boolean canRedo( )
	{
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.extension.IElementCommand#getLabel()
	 */
	public String getLabel( )
	{
		return null;
	}

}
