/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.cloudfoundry.client.lib.StartingInfo;
import org.eclipse.cft.server.core.AbstractAppStateTracker;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.ApplicationOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

public class RestartOperation
extends ApplicationOperation {
    public RestartOperation(CloudFoundryServerBehaviour behaviour, IModule[] modules, boolean clearConsole) {
        super(behaviour, modules, clearConsole);
    }

    @Override
    public String getOperationName() {
        return Messages.RestartOperation_STARTING_APP;
    }

    @Override
    protected void performDeployment(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        Server server = (Server)this.getBehaviour().getServer();
        String deploymentName = appModule.getDeploymentInfo().getDeploymentName();
        if (deploymentName == null) {
            server.setModuleState(this.getModules(), 0);
            throw CloudErrorUtil.toCoreException("Unable to start application. Missing application deployment name in application deployment information.");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        appModule = this.getBehaviour().updateModuleWithAllCloudInfo(appModule.getDeployedApplicationName(), (IProgressMonitor)subMonitor.newChild(20));
        ApplicationAction deploymentMode = this.getDeploymentConfiguration().getApplicationStartMode();
        if (deploymentMode != ApplicationAction.STOP) {
            this.startAndTrackApplication(appModule, subMonitor);
        } else {
            server.setModuleState(this.getModules(), 4);
            subMonitor.worked(80);
        }
    }

    protected void startAndTrackApplication(CloudFoundryApplicationModule appModule, SubMonitor monitor) throws CoreException {
        String deploymentName = appModule.getDeployedApplicationName();
        String startLabel = String.valueOf(Messages.RestartOperation_STARTING_APP) + " - " + deploymentName;
        Server server = (Server)this.getBehaviour().getServer();
        this.getBehaviour().printlnToConsole(appModule, startLabel);
        CloudFoundryPlugin.getCallback().startApplicationConsole(this.getBehaviour().getCloudFoundryServer(), appModule, 0, (IProgressMonitor)monitor.newChild(20));
        CloudFoundryPlugin.trace("Application " + deploymentName + " starting");
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)startLabel));
        }
        int updatedState = appModule.getState();
        try {
            try {
                server.setModuleState(this.getModules(), 1);
                this.getBehaviour().operations().updateModule(this.getFirstModule()).run((IProgressMonitor)monitor);
                StartingInfo info = this.getBehaviour().getRequestFactory().restartApplication(deploymentName, startLabel).run((IProgressMonitor)monitor.newChild(20));
                appModule.setStartingInfo(info);
                updatedState = this.trackApplicationRunningState(appModule, startLabel, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException oce) {
                updatedState = 0;
                throw oce;
            }
            catch (CoreException ce) {
                updatedState = 0;
                throw ce;
            }
        }
        finally {
            server.setModuleState(this.getModules(), updatedState);
            this.getBehaviour().updateModuleWithAllCloudInfo(deploymentName, (IProgressMonitor)monitor);
        }
    }

    protected int trackApplicationRunningState(CloudFoundryApplicationModule cloudModule, String startLabel, IProgressMonitor progress) throws CoreException {
        Server cfr_ignored_0 = (Server)this.getBehaviour().getServer();
        String deploymentName = cloudModule.getDeployedApplicationName();
        int updatedState = this.getBehaviour().getApplicationInstanceRunningTracker(cloudModule).track(progress);
        CloudFoundryPlugin.trace("Default tracker: application " + deploymentName + " tracking completed");
        AbstractAppStateTracker curTracker = CloudFoundryPlugin.getAppStateTracker(this.getBehaviour().getServer().getServerType().getId(), cloudModule);
        if (progress.isCanceled()) {
            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)startLabel));
        }
        if (curTracker != null) {
            curTracker.setServer(this.getBehaviour().getServer());
            curTracker.startTracking(cloudModule, progress);
            boolean isAppStarting = true;
            while (isAppStarting && !progress.isCanceled()) {
                updatedState = curTracker.getApplicationState(cloudModule);
                if (updatedState == 1) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                isAppStarting = false;
            }
            curTracker.stopTracking(cloudModule, progress);
        }
        if (updatedState == 2) {
            CloudFoundryPlugin.getCallback().applicationStarted(this.getBehaviour().getCloudFoundryServer(), cloudModule);
        }
        return updatedState;
    }

    @Override
    protected DeploymentConfiguration getDefaultDeploymentConfiguration() {
        return new DeploymentConfiguration(ApplicationAction.RESTART);
    }
}

