/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.db.TestJobBP;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;

public class NewTestJobHandler
extends AbstractNewHandler {
    public Object executeImpl(ExecutionEvent event) {
        this.newTestJob(event);
        return null;
    }

    private void newTestJob(ExecutionEvent event) {
        InputDialog dialog = this.newTestJobPopUp();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        if (dialog.getReturnCode() == 0) {
            this.addCreatedNode((INodePO)NodeMaker.createTestJobPO((String)dialog.getName()), event);
        }
    }

    private InputDialog newTestJobPopUp() {
        final IProjectPO project = GeneralStorage.getInstance().getProject();
        int testJobCount = TestJobBP.getListOfTestJobs((IProjectPO)project).size();
        String str = "";
        if (testJobCount > 0) {
            str = String.valueOf(str) + testJobCount;
        }
        str = "New Test Job" + str;
        InputDialog dialog = new InputDialog(this.getActiveShell(), Messages.NewTestJobTJTitle, str, Messages.NewTestJobTJMessage, Messages.NewTestJobTJLabel, Messages.NewTestJobTJError, Messages.NewTestJobDoubleTJName, "newTestJobDialog.gif", Messages.NewTestJobTJShell, false){

            @Override
            protected boolean isInputAllowed() {
                String newName = this.getInputFieldText();
                return !ProjectPM.doesTestJobExists((Long)project.getId(), (String)newName);
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestJobNewContextId");
        dialog.open();
        return dialog;
    }
}

