/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class LayoutUtil {
    public static final int ZERO = 0;
    public static final int SMALL = 10;
    public static final int BIG = 15;
    public static final int WIDTH = 30;
    public static final int SMALL_MARGIN_WIDTH = 10;
    public static final int BIG_MARGIN_WIDTH = 15;
    public static final int SMALL_MARGIN_HEIGHT = 10;
    public static final int BIG_MARGIN_HEIGHT = 15;
    public static final int SMALL_HORIZONTAL_SPACING = 10;
    public static final int BIG_HORIZONTAL_SPACING = 15;
    public static final int SMALL_VERTICAL_SPACING = 10;
    public static final int BIG_VERTICAL_SPACING = 15;
    public static final int HORIZONTAL_ALIGNMENT = 4;
    public static final int LABEL_HORIZONTAL_ALIGNMENT = 0x1000008;
    public static final int MULTI_COLUMN_LABEL_HORIZONTAL_ALIGNMENT = 1;
    public static final int TEXT_HORIZONTAL_ALIGNMENT = 1;
    public static final int MULTI_LINE_TEXT_HORIZONTAL_ALIGNMENT = 4;
    public static final int VERTICAL_ALIGNMENT = 0x1000000;
    public static final int SINGLE_TEXT_STYLE = 2052;
    public static final int MULTI_TEXT_STYLE = 2818;
    public static final int MULTI_TEXT = 66;
    public static final int MARGIN_WIDTH = 2;
    public static final int MARGIN_HEIGHT = 2;
    public static final Color LIGHT_GRAY_COLOR = new Color((Device)Display.getDefault(), new RGB(238, 238, 238));
    public static final Color GRAY_COLOR = new Color((Device)Display.getDefault(), new RGB(100, 100, 100));
    public static final Color INACTIVE_COLOR = Display.getDefault().getSystemColor(6);
    public static final Color DEFAULT_OS_COLOR = null;
    public static final String FONT_NAME = "Tahoma";
    public static final int FONT_HEIGHT = 9;
    public static final Font BOLD_TAHOMA = new Font(null, "Tahoma", 9, 1);
    public static final Font BOLD_ITALIC_TAHOMA = new Font(null, "Tahoma", 9, 3);
    public static final Font ITALIC_TAHOMA = new Font(null, "Tahoma", 9, 2);
    public static final Font NORMAL_TAHOMA = new Font(null, "Tahoma", 9, 0);

    private LayoutUtil() {
    }

    public static void setMaxChar(Text textField) {
        LayoutUtil.setMaxChar(textField, 255);
    }

    public static void setMaxChar(Text textField, final int maxLength) {
        if (textField == null) {
            return;
        }
        textField.setTextLimit(maxLength);
        textField.addModifyListener(new ModifyListener(textField){
            private String m_oldValue;
            {
                this.m_oldValue = text.getText();
            }

            public void modifyText(ModifyEvent e) {
                Text theWidget = (Text)e.widget;
                if (theWidget.getCharCount() >= maxLength) {
                    theWidget.setText(this.m_oldValue);
                    ErrorHandlingUtil.createMessageDialog(MessageIDs.W_MAX_CHAR, new Object[]{maxLength}, null);
                }
                this.m_oldValue = theWidget.getText();
            }
        });
    }

    public static void addToolTipAndMaxWidth(GridData gridData, Control control) {
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics(control), (int)30);
        if (control instanceof Text) {
            final Text textField = (Text)control;
            LayoutUtil.setVisibilityToolTip((Control)textField, textField.getText());
            textField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    LayoutUtil.setVisibilityToolTip((Control)textField, textField.getText());
                }
            });
        } else if (control instanceof Combo) {
            final Combo combo = (Combo)control;
            LayoutUtil.setVisibilityToolTip((Control)combo, combo.getText());
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    LayoutUtil.setVisibilityToolTip((Control)combo, combo.getText());
                }
            });
        }
    }

    private static void setVisibilityToolTip(Control control, String text) {
        int width = Dialog.convertWidthInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics(control), (int)text.length());
        if (width > control.getBounds().width) {
            control.setToolTipText(text);
        } else {
            control.setToolTipText(null);
        }
    }

    public static Control createGridSmallSkip(Composite parent, int numColumns) {
        Label result = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.heightHint = 10;
        result.setLayoutData((Object)gd);
        return result;
    }

    public static Control createGridBigSkip(Composite parent, int numColumns) {
        Label result = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.heightHint = 15;
        result.setLayoutData((Object)gd);
        return result;
    }

    public static GridData createDefaultLabelGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 0x1000008;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        return result;
    }

    public static GridData createMultiColumnLabelGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 1;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        result.horizontalIndent = 15;
        return result;
    }

    public static GridData createTopLabelGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 0x1000008;
        result.verticalAlignment = 1;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        return result;
    }

    public static GridData createDefaultTextGridData() {
        return LayoutUtil.createDefaultTextGridData(1);
    }

    public static GridData createDefaultTextGridData(int numColumns) {
        GridData result = LayoutUtil.createTextGridData();
        result.horizontalSpan = numColumns;
        return result;
    }

    public static GridData createDefaultTextGridData(Control control, int numChars) {
        GridData result = new GridData();
        result.horizontalAlignment = 1;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        result.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics(control), (int)numChars);
        return result;
    }

    public static GridData createMultiLineTextGridData(Control control, int numLines) {
        GridData result = new GridData();
        result.horizontalAlignment = 4;
        result.verticalAlignment = 0x1000000;
        result.horizontalSpan = 1;
        result.verticalSpan = 1;
        result.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics(control), (int)numLines);
        return result;
    }

    private static GridData createTextGridData() {
        GridData result = new GridData();
        result.horizontalAlignment = 4;
        result.verticalAlignment = 0x1000000;
        result.verticalSpan = 1;
        return result;
    }

    public static FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    public static void createSeparator(Composite area) {
        Label label = new Label(area, 258);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
    }
}

