/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.common.monitoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.toolkit.common.monitoring.MonitoringAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitoringRegistry {
    private static IExtensionRegistry reg = Platform.getExtensionRegistry();
    private static IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.jubula.toolkit.common.monitoring");

    private MonitoringRegistry() {
    }

    public static List<String> getAllRegisteredMonitoringIds() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            list.add(element.getAttribute("id"));
            ++i;
        }
        return list;
    }

    public static String getExtUrlForMonitoringId(String monId) {
        String url = null;
        if (monId != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement element = extensions[i];
                if (monId.equals(element.getAttribute("id"))) {
                    url = element.getAttribute("linkText");
                    break;
                }
                ++i;
            }
        }
        return url;
    }

    public static List<String> getAllRegisteredMonitoringNames() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            list.add(element.getAttribute("name"));
            ++i;
        }
        return list;
    }

    public static IConfigurationElement getElement(String id) {
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            if (id.equals(element.getAttribute("id"))) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static List<MonitoringAttribute> getAttributes(IConfigurationElement element) {
        IConfigurationElement[] elementChildren = element.getChildren();
        ArrayList<MonitoringAttribute> list = new ArrayList<MonitoringAttribute>();
        int j = 0;
        while (j < elementChildren.length) {
            IConfigurationElement[] validator = elementChildren[j].getChildren("validator");
            IValidator vali = null;
            if (validator.length > 0) {
                try {
                    vali = (IValidator)validator[0].createExecutableExtension("validator");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            String[] extensionFilters = null;
            String filterAttribute = elementChildren[j].getAttribute("filter");
            if (filterAttribute != null) {
                extensionFilters = filterAttribute.split(";");
            }
            list.add(new MonitoringAttribute(elementChildren[j].getAttribute("type"), elementChildren[j].getAttribute("description"), elementChildren[j].getAttribute("id"), elementChildren[j].getAttribute("defaultvalue"), Boolean.valueOf(elementChildren[j].getAttribute("render")), element.getAttribute("name"), elementChildren[j].getAttribute("infoBoobleText"), vali, extensionFilters));
            ++j;
        }
        return list;
    }
}

