/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.core;

import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.WARProductModelFactory;
import org.eclipse.libra.warproducts.core.WARProductUtil;
import org.eclipse.libra.warproducts.core.validation.Validation;
import org.eclipse.libra.warproducts.core.validation.ValidationError;
import org.eclipse.libra.warproducts.core.validation.Validator;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;

public class WARProductInitializer {
    private IWARProduct product;

    public WARProductInitializer(IWARProduct product) {
        this.product = product;
    }

    public void initialize() {
        Validator validator = new Validator(this.product);
        Validation validation = validator.validate();
        if (!validation.isValid()) {
            this.makeProductValid(validation.getErrors());
        }
    }

    private void makeProductValid(ValidationError[] errors) {
        int i = 0;
        while (i < errors.length) {
            IProductPlugin bundle;
            ValidationError error = errors[i];
            if (error.getType() == 2) {
                bundle = (IProductPlugin)error.getCausingObject();
                this.removeBannedBundle(bundle);
            } else if (error.getType() == 3) {
                bundle = (IProductPlugin)error.getCausingObject();
                this.addRequiredBundle(bundle);
            } else if (error.getType() == 0) {
                WARProductUtil.addServletBridgeFromTarget(this.product);
            }
            ++i;
        }
    }

    private void removeBannedBundle(IProductPlugin bundle) {
        this.product.removePlugins(new IProductPlugin[]{bundle});
    }

    private void addRequiredBundle(IProductPlugin requiredBundle) {
        ModelEntry entry = PluginRegistry.findEntry((String)requiredBundle.getId());
        if (entry != null) {
            WARProductModelFactory factory = new WARProductModelFactory(this.product.getModel());
            IProductPlugin bundle = factory.createPlugin();
            bundle.setId(requiredBundle.getId());
            bundle.setVersion(requiredBundle.getVersion());
            this.product.addPlugins(new IProductPlugin[]{bundle});
        }
    }
}

