/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.operations.diagnostics.LSPDiagnosticsToMarkers;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class LanguageClientImpl
implements LanguageClient {
    private LSPDiagnosticsToMarkers diagnosticHandler;
    private LanguageServer server;
    private LanguageServerWrapper wrapper;

    public final void connect(LanguageServer server, LanguageServerWrapper wrapper) {
        this.server = server;
        this.wrapper = wrapper;
        this.diagnosticHandler = new LSPDiagnosticsToMarkers(wrapper.serverDefinition.id);
    }

    protected final LanguageServer getLanguageServer() {
        return this.server;
    }

    public void telemetryEvent(Object object) {
    }

    public final CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return ServerMessageHandler.showMessageRequest(requestParams);
    }

    public final void showMessage(MessageParams messageParams) {
        ServerMessageHandler.showMessage(this.wrapper.serverDefinition.label, messageParams);
    }

    public final void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        this.diagnosticHandler.accept(diagnostics);
    }

    public final void logMessage(MessageParams message) {
        CompletableFuture.runAsync(() -> ServerMessageHandler.logMessage(this.wrapper, message));
    }

    public final CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(final ApplyWorkspaceEditParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Job job = new Job(Messages.serverEdit){

                public IStatus run(IProgressMonitor monitor) {
                    LSPEclipseUtils.applyWorkspaceEdit(params.getEdit());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            try {
                job.join();
                return new ApplyWorkspaceEditResponse(true);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return new ApplyWorkspaceEditResponse(Boolean.FALSE.booleanValue());
            }
        });
    }

    public CompletableFuture<Void> registerCapability(RegistrationParams params) {
        return CompletableFuture.runAsync(() -> this.wrapper.registerCapability(params));
    }

    public CompletableFuture<Void> unregisterCapability(UnregistrationParams params) {
        return CompletableFuture.runAsync(() -> this.wrapper.unregisterCapability(params));
    }

    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        ArrayList<WorkspaceFolder> res = new ArrayList<WorkspaceFolder>(this.wrapper.allWatchedProjects.size());
        for (IProject project : this.wrapper.allWatchedProjects) {
            res.add(LSPEclipseUtils.toWorkspaceFolder(project));
        }
        return CompletableFuture.completedFuture(res);
    }
}

