/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.RepositoryNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class RepositoryViewLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IColorProvider,
IFontProvider {
    private Font italicFont;

    public RepositoryViewLabelProvider(Font treeFont) {
        int size = 0;
        FontData[] data = treeFont.getFontData();
        if (data == null) {
            size = 12;
        } else {
            int i = 0;
            while (i < data.length) {
                size = Math.max(size, data[i].getHeight());
                ++i;
            }
        }
        this.italicFont = M2EUIUtils.deriveFont(treeFont, 2, size);
    }

    public void dispose() {
        this.italicFont.dispose();
        super.dispose();
    }

    public String getText(Object obj) {
        if (obj instanceof IMavenRepositoryNode) {
            return ((IMavenRepositoryNode)obj).getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof IMavenRepositoryNode) {
            return ((IMavenRepositoryNode)obj).getImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof RepositoryNode) {
            if (((RepositoryNode)element).isEnabledIndex()) {
                return Display.getDefault().getSystemColor(2);
            }
            return Display.getDefault().getSystemColor(16);
        }
        return Display.getDefault().getSystemColor(2);
    }

    public Font getFont(Object element) {
        if (element instanceof IMavenRepositoryNode) {
            boolean updating = ((IMavenRepositoryNode)element).isUpdating();
            return updating ? this.italicFont : null;
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        return new StyledString(this.getText(element));
    }
}

