/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.testers;

import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;

public class HiddenLabelTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if ("isLabelHidden".equals(property)) {
            if (receiver instanceof IStructuredSelection) {
                result = this.testStructuredSelection((IStructuredSelection)receiver);
            } else if (receiver instanceof IDiagramElementEditPart) {
                result = this.testDiagramElementEditPart((IDiagramElementEditPart)receiver);
            }
        }
        return result;
    }

    private boolean testDiagramElementEditPart(IDiagramElementEditPart selectedElement) {
        DDiagramElement diagramElement = selectedElement.resolveDiagramElement();
        if (diagramElement != null) {
            return new DDiagramElementQuery(diagramElement).isLabelHidden();
        }
        return false;
    }

    private boolean testStructuredSelection(IStructuredSelection selectedElements) {
        boolean atLeastOneIsOK = false;
        Iterator iterator = selectedElements.iterator();
        while (!atLeastOneIsOK && iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof IDiagramElementEditPart)) continue;
            atLeastOneIsOK = this.testDiagramElementEditPart((IDiagramElementEditPart)next);
        }
        return atLeastOneIsOK;
    }
}

