/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class CVSRemoteFilePropertySource
implements IPropertySource {
    ICVSRemoteFile file;
    ILogEntry entry;
    boolean initialized;
    protected static IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[5];

    public CVSRemoteFilePropertySource(ICVSRemoteFile file) {
        String category = CVSUIMessages.cvs;
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)"cvs.name", CVSUIMessages.CVSRemoteFilePropertySource_name);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        CVSRemoteFilePropertySource.propertyDescriptors[0] = descriptor;
        descriptor = new PropertyDescriptor((Object)"cvs.revision", CVSUIMessages.CVSRemoteFilePropertySource_revision);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        CVSRemoteFilePropertySource.propertyDescriptors[1] = descriptor;
        descriptor = new PropertyDescriptor((Object)"cvs.date", CVSUIMessages.CVSRemoteFilePropertySource_date);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        CVSRemoteFilePropertySource.propertyDescriptors[2] = descriptor;
        descriptor = new PropertyDescriptor((Object)"cvs.author", CVSUIMessages.CVSRemoteFilePropertySource_author);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        CVSRemoteFilePropertySource.propertyDescriptors[3] = descriptor;
        descriptor = new PropertyDescriptor((Object)"cvs.comment", CVSUIMessages.CVSRemoteFilePropertySource_comment);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(category);
        CVSRemoteFilePropertySource.propertyDescriptors[4] = descriptor;
        this.file = file;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if (id.equals("cvs.name")) {
            return this.file.getName();
        }
        if (this.entry != null) {
            if (id.equals("cvs.revision")) {
                return this.entry.getRevision();
            }
            if (id.equals("cvs.date")) {
                return this.entry.getDate();
            }
            if (id.equals("cvs.author")) {
                return this.entry.getAuthor();
            }
            if (id.equals("cvs.comment")) {
                return this.entry.getComment();
            }
        }
        return "";
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    public void setPropertyValue(Object name, Object value) {
    }

    private void initialize() {
        try {
            CVSUIPlugin.runWithProgress(null, true, monitor -> {
                try {
                    ILogEntry[] entries = this.file.getLogEntries(monitor);
                    String revision = this.file.getRevision();
                    int i = 0;
                    while (i < entries.length) {
                        if (entries[i].getRevision().equals(revision)) {
                            this.entry = entries[i];
                            return;
                        }
                        ++i;
                    }
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(null, null, null, e);
        }
    }
}

