/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.scatter;

import java.text.Format;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.scatter.SegmentStoreScatterGraphTooltipProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;

public class AbstractSegmentStoreScatterChartViewer
extends TmfFilteredXYChartViewer {
    private static final Format FORMAT = new SubSecondTimeWithUnitFormat();
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private String fAnalysisId;

    public AbstractSegmentStoreScatterChartViewer(Composite parent, TmfXYChartSettings settings) {
        this(parent, settings, "");
    }

    public AbstractSegmentStoreScatterChartViewer(Composite parent, TmfXYChartSettings settings, String analysisId) {
        super(parent, settings, "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider");
        this.fAnalysisId = analysisId;
        this.setTooltipProvider((TmfBaseProvider)new SegmentStoreScatterGraphTooltipProvider((ITmfChartTimeProvider)this));
        this.getSwtChart().getLegend().setVisible(false);
        this.getSwtChart().getAxisSet().getYAxis(0).getTick().setFormat(FORMAT);
    }

    protected String getAnalysisId() {
        return this.fAnalysisId;
    }

    protected @Nullable ITmfXYDataProvider initializeDataProvider(ITmfTrace trace) {
        String analysisId = this.getAnalysisId();
        if (analysisId.isEmpty()) {
            return null;
        }
        return (ITmfXYDataProvider)DataProviderManager.getInstance().getDataProvider(trace, "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider:" + analysisId, ITmfTreeXYDataProvider.class);
    }

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        if (this.getTrace() != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
        }
    }

    @TmfSignalHandler
    public void traceOpened(@Nullable TmfTraceOpenedSignal signal) {
        super.traceOpened(signal);
        if (this.getTrace() != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
        }
    }

    public IYAppearance getSeriesAppearance(@NonNull String seriesName) {
        return this.getPresentationProvider().getAppearance(seriesName, "scatter", 1);
    }

    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        if (signal != null && TmfTraceManager.getInstance().getActiveTrace() == null) {
            this.clearContent();
        }
        this.refresh();
    }
}

