/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.eval.AbstractEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.eval.EvaluatorCore;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class MemorylessEvaluatorNode
extends AbstractEvaluatorNode {
    public MemorylessEvaluatorNode(ReteContainer reteContainer, EvaluatorCore core) {
        super(reteContainer, core);
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        ArrayList<Tuple> parentTuples = new ArrayList<Tuple>();
        this.propagatePullInto(parentTuples, flush);
        for (Tuple incomingTuple : parentTuples) {
            Tuple evaluated = this.core.performEvaluation(incomingTuple);
            if (evaluated == null) continue;
            collector.add(evaluated);
        }
    }

    @Override
    public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
        HashMap<Tuple, Timestamp> parentTuples = new HashMap<Tuple, Timestamp>();
        this.propagatePullIntoWithTimestamp(parentTuples, flush);
        for (Map.Entry entry : parentTuples.entrySet()) {
            Tuple evaluated = this.core.performEvaluation((Tuple)entry.getKey());
            if (evaluated == null) continue;
            collector.put(evaluated, (Timestamp)entry.getValue());
        }
    }

    @Override
    public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
        Tuple evaluated = this.core.performEvaluation(updateElement);
        if (evaluated != null) {
            this.propagateUpdate(direction, evaluated, timestamp);
        }
    }
}

