/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.JvmModelGenerator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;

public class JvmModelCompleter {
    private static final String JAVAX_ANNOTATION_GENERATED = "javax.annotation.Generated";
    protected static final String GENERATED_COMMENT_VAR_SOURCE_FILE = "${sourcefile}";
    @Inject
    private TypeReferences references;
    @Inject
    private TypesFactory typesFactory;
    @Inject
    private JvmTypeExtensions typeExtensions;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private JvmAnnotationReferenceBuilder.Factory annotationRefBuilderFactory;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private AnnotationLookup annotationLookup;
    @Inject
    private JvmModelGenerator generator;
    private DateFormat dateFormat;

    public void complete(Iterable<? extends JvmIdentifiableElement> elements) {
        for (JvmIdentifiableElement jvmIdentifiableElement : elements) {
            this.complete(jvmIdentifiableElement);
        }
    }

    public void complete(JvmIdentifiableElement element) {
        if (element instanceof JvmGenericType) {
            this.completeJvmGenericType((JvmGenericType)element);
        }
        if (element instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)element;
            this.complete((Iterable<? extends JvmIdentifiableElement>)declaredType.getMembers());
        }
        if (element instanceof JvmConstructor) {
            this.completeJvmConstructor((JvmConstructor)element);
        }
        if (element instanceof JvmEnumerationType) {
            this.completeJvmEnumerationType((JvmEnumerationType)element);
        }
        if (element instanceof JvmEnumerationLiteral) {
            this.completeJvmEnumerationLiteral((JvmEnumerationLiteral)element);
        }
        if (element instanceof JvmAnnotationType) {
            this.completeJvmAnnotationType((JvmAnnotationType)element);
        }
    }

    protected void completeJvmEnumerationType(JvmEnumerationType element) {
        JvmTypeReference objectType;
        if (element.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Enum.class, (Notifier)element, new JvmTypeReference[]{this.references.createTypeRef((JvmType)element, new JvmTypeReference[0])})) != null) {
            element.getSuperTypes().add((Object)objectType);
        }
        this.addAnnotations((JvmDeclaredType)element);
        EObject primarySourceElement = this.associations.getPrimarySourceElement((EObject)element);
        JvmOperation values = this.typesFactory.createJvmOperation();
        values.setVisibility(JvmVisibility.PUBLIC);
        values.setStatic(true);
        values.setSimpleName("values");
        values.setReturnType((JvmTypeReference)this.references.createArrayType((JvmTypeReference)this.references.createTypeRef((JvmType)element, new JvmTypeReference[0])));
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)values, true);
        if (primarySourceElement != null) {
            this.associator.associate(primarySourceElement, (EObject)values);
        }
        element.getMembers().add((Object)values);
        JvmOperation valueOf = this.typesFactory.createJvmOperation();
        valueOf.setVisibility(JvmVisibility.PUBLIC);
        valueOf.setStatic(true);
        valueOf.setSimpleName("valueOf");
        valueOf.setReturnType((JvmTypeReference)this.references.createTypeRef((JvmType)element, new JvmTypeReference[0]));
        JvmFormalParameter param = this.typesFactory.createJvmFormalParameter();
        param.setName("name");
        param.setParameterType(this.references.getTypeForName(String.class, (Notifier)element, new JvmTypeReference[0]));
        valueOf.getParameters().add((Object)param);
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)valueOf, true);
        if (primarySourceElement != null) {
            this.associator.associate(primarySourceElement, (EObject)valueOf);
        }
        element.getMembers().add((Object)valueOf);
    }

    protected void completeJvmEnumerationLiteral(JvmEnumerationLiteral element) {
        if (element.getType() == null) {
            element.setType((JvmTypeReference)this.references.createTypeRef((JvmType)element.getDeclaringType(), new JvmTypeReference[0]));
        }
        element.setStatic(true);
    }

    protected void completeJvmAnnotationType(JvmAnnotationType element) {
        JvmTypeReference objectType;
        this.addAnnotations((JvmDeclaredType)element);
        if (element.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Annotation.class, (Notifier)element, new JvmTypeReference[0])) != null) {
            element.getSuperTypes().add((Object)objectType);
        }
    }

    public void completeJvmConstructor(JvmConstructor constructor) {
        String simpleName;
        JvmDeclaredType declaringType = constructor.getDeclaringType();
        if (declaringType != null && (simpleName = declaringType.getSimpleName()) != null) {
            constructor.setSimpleName(simpleName);
            return;
        }
        constructor.setSimpleName("unset");
    }

    protected void completeJvmGenericType(JvmGenericType element) {
        this.ensureSuperTypeObject((JvmDeclaredType)element);
        this.addAnnotations((JvmDeclaredType)element);
        if (!element.isInterface() && Iterables.isEmpty((Iterable)element.getDeclaredConstructors())) {
            JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
            constructor.setSimpleName(element.getSimpleName());
            constructor.setVisibility(JvmVisibility.PUBLIC);
            this.typeExtensions.setSynthetic((JvmIdentifiableElement)constructor, true);
            EObject primarySourceElement = this.associations.getPrimarySourceElement((EObject)element);
            if (primarySourceElement != null) {
                this.associator.associate(primarySourceElement, (EObject)constructor);
            }
            element.getMembers().add((Object)constructor);
        }
    }

    protected void ensureSuperTypeObject(JvmDeclaredType element) {
        JvmTypeReference objectType;
        if (element.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Object.class, (Notifier)element, new JvmTypeReference[0])) != null) {
            element.getSuperTypes().add((Object)objectType);
        }
    }

    protected void addAnnotations(JvmDeclaredType jvmType) {
        if (jvmType.getDeclaringType() == null) {
            boolean generateGenerated;
            GeneratorConfig generatorConfig = this.generatorConfigProvider.get((EObject)jvmType);
            boolean generateSuppressWarnings = !(jvmType instanceof JvmAnnotationType) && generatorConfig.isGenerateSyntheticSuppressWarnings() && this.annotationLookup.findAnnotation((JvmAnnotationTarget)jvmType, SuppressWarnings.class) == null && this.references.findDeclaredType(SuppressWarnings.class, (Notifier)jvmType) instanceof JvmAnnotationType;
            JvmType generatedJvmType = this.references.findDeclaredType(JAVAX_ANNOTATION_GENERATED, (Notifier)jvmType);
            boolean bl = generateGenerated = generatorConfig.isGenerateGeneratedAnnotation() && generatedJvmType instanceof JvmAnnotationType;
            if (generateSuppressWarnings || generateGenerated) {
                JvmAnnotationReferenceBuilder annotationRefBuilder = this.annotationRefBuilderFactory.create(jvmType.eResource().getResourceSet());
                if (generateSuppressWarnings) {
                    JvmAnnotationReference annotationRef = annotationRefBuilder.annotationRef(SuppressWarnings.class, "all");
                    this.typeExtensions.setSynthetic(annotationRef, true);
                    jvmType.getAnnotations().add((Object)annotationRef);
                }
                if (generateGenerated) {
                    JvmAnnotationType generatedAnnotationType = (JvmAnnotationType)generatedJvmType;
                    JvmAnnotationReference annotationRef = annotationRefBuilder.annotationRef(JAVAX_ANNOTATION_GENERATED, new String[0]);
                    JvmStringAnnotationValue annotationValue = this.typesFactory.createJvmStringAnnotationValue();
                    annotationValue.getValues().add((Object)this.generator.getClass().getName());
                    annotationRef.getExplicitValues().add((Object)annotationValue);
                    if (generatorConfig.isIncludeDateInGeneratedAnnotation()) {
                        if (this.dateFormat == null) {
                            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
                        }
                        String date = this.dateFormat.format(new Date());
                        annotationValue = this.typesFactory.createJvmStringAnnotationValue();
                        annotationValue.setOperation(this.getOperation(generatedAnnotationType, "date"));
                        annotationValue.getValues().add((Object)date);
                        annotationRef.getExplicitValues().add((Object)annotationValue);
                    }
                    if (!Strings.isNullOrEmpty((String)generatorConfig.getGeneratedAnnotationComment())) {
                        String transformedComment = this.replaceVariables(generatorConfig.getGeneratedAnnotationComment(), jvmType);
                        annotationValue = this.typesFactory.createJvmStringAnnotationValue();
                        annotationValue.setOperation(this.getOperation(generatedAnnotationType, "comments"));
                        annotationValue.getValues().add((Object)transformedComment);
                        annotationRef.getExplicitValues().add((Object)annotationValue);
                    }
                    this.typeExtensions.setSynthetic(annotationRef, true);
                    this.annotationLookup.removeAnnotation((JvmAnnotationTarget)jvmType, JAVAX_ANNOTATION_GENERATED);
                    jvmType.getAnnotations().add((Object)annotationRef);
                }
            }
        }
    }

    private JvmOperation getOperation(JvmAnnotationType annotationType, String operationName) {
        for (JvmOperation operation : annotationType.getDeclaredOperations()) {
            if (!operationName.equals(operation.getSimpleName())) continue;
            return operation;
        }
        return null;
    }

    protected String replaceVariables(String commentForGenerated, JvmDeclaredType jvmType) {
        URI uri;
        Resource resource;
        String result = commentForGenerated;
        if (result.contains(GENERATED_COMMENT_VAR_SOURCE_FILE) && (resource = jvmType.eResource()) != null && (uri = resource.getURI()) != null) {
            String sourceFile = uri.lastSegment();
            if (sourceFile == null) {
                sourceFile = uri.toString();
            }
            result = result.replace(GENERATED_COMMENT_VAR_SOURCE_FILE, sourceFile);
        }
        return result;
    }
}

