/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvArgumentsProvider;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParserSettings;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;

class CsvFileArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvFileSource> {
    private final BiFunction<Class<?>, String, InputStream> inputStreamProvider;
    private CsvFileSource annotation;
    private String[] resources;
    private Charset charset;
    private CsvParserSettings settings;
    private int numLinesToSkip;

    CsvFileArgumentsProvider() {
        this(Class::getResourceAsStream);
    }

    CsvFileArgumentsProvider(BiFunction<Class<?>, String, InputStream> inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    @Override
    public void accept(CsvFileSource annotation) {
        this.annotation = annotation;
        this.resources = annotation.resources();
        try {
            this.charset = Charset.forName(annotation.encoding());
        }
        catch (Exception ex) {
            throw new PreconditionViolationException("The charset supplied in " + this.annotation + " is invalid", (Throwable)ex);
        }
        this.numLinesToSkip = annotation.numLinesToSkip();
        this.settings = new CsvParserSettings();
        ((CsvFormat)this.settings.getFormat()).setDelimiter(annotation.delimiter());
        ((CsvFormat)this.settings.getFormat()).setLineSeparator(annotation.lineSeparator());
        ((CsvFormat)this.settings.getFormat()).setQuote('\"');
        ((CsvFormat)this.settings.getFormat()).setQuoteEscape('\"');
        this.settings.setEmptyValue("");
        this.settings.setAutoConfigurationEnabled(false);
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return Arrays.stream(this.resources).map(resource -> this.openInputStream(context, (String)resource)).map(this::createCsvParser).flatMap(this::toStream);
    }

    private InputStream openInputStream(ExtensionContext context, String resource) {
        Preconditions.notBlank((String)resource, (String)("Classpath resource [" + resource + "] must not be null or blank"));
        Class testClass = context.getRequiredTestClass();
        return (InputStream)Preconditions.notNull((Object)this.inputStreamProvider.apply(testClass, resource), () -> "Classpath resource [" + resource + "] does not exist");
    }

    private CsvParser createCsvParser(InputStream inputStream) {
        CsvParser csvParser = new CsvParser(this.settings);
        try {
            csvParser.beginParsing(inputStream, this.charset);
        }
        catch (Throwable throwable) {
            CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
        }
        return csvParser;
    }

    private Stream<Arguments> toStream(CsvParser csvParser) {
        CsvParserIterator iterator = new CsvParserIterator(csvParser, this.annotation);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).skip(this.numLinesToSkip).onClose(() -> {
            try {
                csvParser.stopParsing();
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
            }
        });
    }

    private static class CsvParserIterator
    implements Iterator<Arguments> {
        private final CsvParser csvParser;
        private final CsvFileSource annotation;
        private Object[] nextCsvRecord;

        CsvParserIterator(CsvParser csvParser, CsvFileSource annotation) {
            this.csvParser = csvParser;
            this.annotation = annotation;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextCsvRecord != null;
        }

        @Override
        public Arguments next() {
            Arguments result = Arguments.arguments(this.nextCsvRecord);
            this.advance();
            return result;
        }

        private void advance() {
            try {
                this.nextCsvRecord = this.csvParser.parseNext();
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
            }
        }
    }
}

