/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;

public final class MapEntryUtils {
    private static final Comparator<Map.Entry<Comparable, ?>> BY_KEY_COMPARATOR = (o1, o2) -> {
        Comparable k1 = (Comparable)o1.getKey();
        Comparable k2 = (Comparable)o2.getKey();
        return k1.compareTo(k2);
    };

    private MapEntryUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <K extends Comparable<K>, V> Comparator<Map.Entry<K, V>> byKeyEntryComparator() {
        return BY_KEY_COMPARATOR;
    }

    public static class EnumMapBuilder<K extends Enum<K>, V>
    extends GenericMapPopulator<K, V, Map<K, V>> {
        public EnumMapBuilder(Class<K> keyType) {
            super(new EnumMap(Objects.requireNonNull(keyType, "No enum class specified")));
        }

        public EnumMapBuilder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        public EnumMapBuilder<K, V> remove(K k) {
            super.remove(k);
            return this;
        }

        public EnumMapBuilder<K, V> putAll(Map<? extends K, ? extends V> other) {
            super.putAll(other);
            return this;
        }

        public EnumMapBuilder<K, V> clear() {
            super.clear();
            return this;
        }

        public Map<K, V> build() {
            return this.get();
        }

        public Map<K, V> immutable() {
            return Collections.unmodifiableMap(this.build());
        }

        public static <K extends Enum<K>, V> EnumMapBuilder<K, V> builder(Class<K> keyType) {
            return new EnumMapBuilder<K, V>(keyType);
        }
    }

    public static class GenericMapPopulator<K, V, M extends Map<K, V>>
    implements Supplier<M> {
        private final M map;

        public GenericMapPopulator(M map) {
            this.map = (Map)Objects.requireNonNull(map, "No map provided");
        }

        public GenericMapPopulator<K, V, M> put(K k, V v) {
            this.map.put(k, v);
            return this;
        }

        public GenericMapPopulator<K, V, M> remove(K k) {
            this.map.remove(k);
            return this;
        }

        public GenericMapPopulator<K, V, M> putAll(Map<? extends K, ? extends V> other) {
            this.map.putAll(other);
            return this;
        }

        public GenericMapPopulator<K, V, M> clear() {
            this.map.clear();
            return this;
        }

        @Override
        public M get() {
            return this.map;
        }
    }

    public static class MapBuilder<K, V>
    extends GenericMapPopulator<K, V, Map<K, V>> {
        public MapBuilder() {
            super(new LinkedHashMap());
        }

        public MapBuilder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        public MapBuilder<K, V> remove(K k) {
            super.remove(k);
            return this;
        }

        public MapBuilder<K, V> putAll(Map<? extends K, ? extends V> other) {
            super.putAll(other);
            return this;
        }

        public MapBuilder<K, V> clear() {
            super.clear();
            return this;
        }

        public Map<K, V> build() {
            return this.get();
        }

        public Map<K, V> immutable() {
            return Collections.unmodifiableMap(this.build());
        }

        public static <K, V> MapBuilder<K, V> builder() {
            return new MapBuilder<K, V>();
        }
    }

    public static class NavigableMapBuilder<K, V>
    extends GenericMapPopulator<K, V, NavigableMap<K, V>> {
        public NavigableMapBuilder(Comparator<? super K> comparator) {
            super(new TreeMap(Objects.requireNonNull(comparator, "No comparator provided")));
        }

        public NavigableMapBuilder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        public NavigableMapBuilder<K, V> remove(K k) {
            super.remove(k);
            return this;
        }

        public NavigableMapBuilder<K, V> putAll(Map<? extends K, ? extends V> other) {
            super.putAll(other);
            return this;
        }

        public NavigableMapBuilder<K, V> clear() {
            super.clear();
            return this;
        }

        public NavigableMap<K, V> build() {
            return (NavigableMap)this.get();
        }

        public NavigableMap<K, V> immutable() {
            return Collections.unmodifiableNavigableMap(this.build());
        }

        public static <K extends Comparable<? super K>, V> NavigableMapBuilder<K, V> builder() {
            return NavigableMapBuilder.builder(Comparator.naturalOrder());
        }

        public static <K, V> NavigableMapBuilder<K, V> builder(Comparator<? super K> comparator) {
            return new NavigableMapBuilder<K, V>(comparator);
        }
    }
}

