/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.BPELPlugin;
import org.eclipse.bpel.model.Branches;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.Compensate;
import org.eclipse.bpel.model.CompensateScope;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.CompletionCondition;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Copy;
import org.eclipse.bpel.model.Correlation;
import org.eclipse.bpel.model.CorrelationPattern;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.Correlations;
import org.eclipse.bpel.model.Documentation;
import org.eclipse.bpel.model.Else;
import org.eclipse.bpel.model.ElseIf;
import org.eclipse.bpel.model.Empty;
import org.eclipse.bpel.model.EndpointReferenceRole;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.Exit;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.model.Extension;
import org.eclipse.bpel.model.Extensions;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.FromPart;
import org.eclipse.bpel.model.FromParts;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Links;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.OpaqueActivity;
import org.eclipse.bpel.model.PartnerActivity;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Query;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.RepeatUntil;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Rethrow;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.ServiceRef;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.model.ToPart;
import org.eclipse.bpel.model.ToParts;
import org.eclipse.bpel.model.Validate;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.Wait;
import org.eclipse.bpel.model.While;
import org.eclipse.bpel.model.extensions.BPELActivityDeserializer;
import org.eclipse.bpel.model.extensions.BPELExtensionDeserializer;
import org.eclipse.bpel.model.extensions.BPELExtensionRegistry;
import org.eclipse.bpel.model.extensions.BPELUnknownExtensionDeserializer;
import org.eclipse.bpel.model.extensions.ServiceReferenceDeserializer;
import org.eclipse.bpel.model.impl.DocumentationImpl;
import org.eclipse.bpel.model.impl.FromImpl;
import org.eclipse.bpel.model.impl.FromPartImpl;
import org.eclipse.bpel.model.impl.OnEventImpl;
import org.eclipse.bpel.model.impl.OnMessageImpl;
import org.eclipse.bpel.model.impl.PartnerActivityImpl;
import org.eclipse.bpel.model.impl.ToImpl;
import org.eclipse.bpel.model.impl.ToPartImpl;
import org.eclipse.bpel.model.messageproperties.util.MessagepropertiesConstants;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.proxy.CorrelationSetProxy;
import org.eclipse.bpel.model.proxy.LinkProxy;
import org.eclipse.bpel.model.proxy.MessageExchangeProxy;
import org.eclipse.bpel.model.proxy.MessageProxy;
import org.eclipse.bpel.model.proxy.PartnerLinkProxy;
import org.eclipse.bpel.model.proxy.PartnerLinkTypeProxy;
import org.eclipse.bpel.model.proxy.PropertyProxy;
import org.eclipse.bpel.model.proxy.RoleProxy;
import org.eclipse.bpel.model.proxy.VariableProxy;
import org.eclipse.bpel.model.proxy.XSDElementDeclarationProxy;
import org.eclipse.bpel.model.proxy.XSDTypeDefinitionProxy;
import org.eclipse.bpel.model.resource.BPELLinkResolver;
import org.eclipse.bpel.model.resource.BPELReader;
import org.eclipse.bpel.model.resource.BPELVariableResolver;
import org.eclipse.bpel.model.resource.LineCapturingDOMParser;
import org.eclipse.bpel.model.resource.LinkResolver;
import org.eclipse.bpel.model.resource.VariableResolver;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.ReconciliationHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ReconciliationBPELReader
extends BPELReader
implements ErrorHandler {
    private Process process = null;
    private Resource fResource = null;
    private DocumentBuilder docBuilder = null;
    private BPELExtensionRegistry extensionRegistry = BPELExtensionRegistry.getInstance();
    private DOMParser fDOMParser;
    ErrorHandler fErrorHandler = null;
    public static VariableResolver VARIABLE_RESOLVER = new BPELVariableResolver();
    public static LinkResolver LINK_RESOLVER = new BPELLinkResolver();

    public ReconciliationBPELReader(DocumentBuilder builder) throws IOException {
        if (builder == null) {
            throw new IOException(BPELPlugin.INSTANCE.getString("%BPELReader.missing_doc_builder"));
        }
        this.docBuilder = builder;
    }

    public ReconciliationBPELReader(DOMParser parser) {
        this.fDOMParser = parser;
    }

    public ReconciliationBPELReader(Process process) {
        this.process = process;
        this.fResource = process.eResource();
    }

    public ReconciliationBPELReader() {
        this.fDOMParser = new LineCapturingDOMParser();
        try {
            this.fDOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.fDOMParser.setFeature("http://apache.org/xml/features/xinclude", false);
        }
        catch (SAXNotRecognizedException e) {
            BPELPlugin.log("Not Recognized DOM Parser Feature", e);
        }
        catch (SAXNotSupportedException e) {
            BPELPlugin.log("Not Supported DOM Parser Feature", e);
        }
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    void armErrorHandler() {
        assert (this.docBuilder != null || this.fDOMParser != null);
        if (this.docBuilder != null) {
            this.docBuilder.setErrorHandler(this.fErrorHandler != null ? this.fErrorHandler : this);
        } else {
            this.fDOMParser.setErrorHandler(this.fErrorHandler != null ? this.fErrorHandler : this);
        }
    }

    Document read(InputSource inputSource) throws IOException, SAXException {
        assert (this.docBuilder != null || this.fDOMParser != null) : "No document builder/parser set";
        if (this.docBuilder != null) {
            return this.docBuilder.parse(inputSource);
        }
        this.fDOMParser.parse(inputSource);
        return this.fDOMParser.getDocument();
    }

    @Override
    public Resource getResource() {
        return this.fResource;
    }

    @Override
    protected void pass1(Document document) {
        Process p = this.xml2Resource(document);
        if (p != null) {
            this.fResource.getContents().add((Object)p);
        }
    }

    @Override
    protected List<Element> getChildElements(Element parentElement) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                list.add((Element)children.item(i));
            }
            ++i;
        }
        return list;
    }

    @Override
    protected Map<String, String> getAllNamespacesForElement(Element element) {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        Node tempNode = element;
        while (tempNode != null && tempNode.getNodeType() == 1) {
            NamedNodeMap attrs = tempNode.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                String key;
                Attr attr = (Attr)attrs.item(i);
                if ("http://www.w3.org/2000/xmlns/".equalsIgnoreCase(attr.getNamespaceURI()) && !nsMap.containsKey(key = BPELUtils.getNSPrefixMapKey(attr.getLocalName()))) {
                    nsMap.put(key, attr.getValue());
                }
                ++i;
            }
            tempNode = tempNode.getParentNode();
        }
        return nsMap;
    }

    @Override
    protected void saveNamespacePrefix(EObject eObject, Element element) {
    }

    protected Activity getChildActivity(Object parent, Element element) {
        NodeList activityElements = element.getChildNodes();
        Activity childActivity = ReconciliationHelper.getActivity(parent);
        if (childActivity != null && childActivity.getElement() != null && childActivity.getElement().getParentNode() == element) {
            return childActivity;
        }
        int i = 0;
        while (i < activityElements.getLength()) {
            Element activityElement;
            Activity activity;
            if (activityElements.item(i).getNodeType() == 1 && (activity = this.xml2Activity(null, activityElement = (Element)activityElements.item(i))) != null) {
                return activity;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void setPartnerLink(Element activityElement, EObject eObject, EReference reference) {
        if (!activityElement.hasAttribute("partnerLink")) {
            eObject.eSet((EStructuralFeature)reference, null);
            return;
        }
        String partnerLinkName = activityElement.getAttribute("partnerLink");
        PartnerLink targetPartnerLink = BPELUtils.getPartnerLink(eObject, partnerLinkName);
        if (targetPartnerLink == null) {
            targetPartnerLink = new PartnerLinkProxy(this.getResource().getURI(), partnerLinkName);
        }
        eObject.eSet((EStructuralFeature)reference, (Object)targetPartnerLink);
    }

    @Override
    protected void setMessageExchange(Element activityElement, EObject eObject, EReference reference) {
        if (!activityElement.hasAttribute("messageExchange")) {
            eObject.eSet((EStructuralFeature)reference, null);
            return;
        }
        String messageExchangeName = activityElement.getAttribute("messageExchange");
        MessageExchange targetMessageExchange = BPELUtils.getMessageExchange(eObject, messageExchangeName);
        if (targetMessageExchange == null) {
            targetMessageExchange = new MessageExchangeProxy(this.getResource().getURI(), messageExchangeName);
        }
        eObject.eSet((EStructuralFeature)reference, (Object)targetMessageExchange);
    }

    @Override
    protected void setVariable(Element activityElement, EObject eObject, String variableNameAttr, EReference reference) {
        if (!activityElement.hasAttribute(variableNameAttr)) {
            eObject.eSet((EStructuralFeature)reference, null);
            return;
        }
        String variableName = activityElement.getAttribute(variableNameAttr);
        Variable targetVariable = ReconciliationBPELReader.getVariable(eObject, variableName);
        if (targetVariable == null) {
            targetVariable = new VariableProxy(this.getResource().getURI(), variableName);
        }
        eObject.eSet((EStructuralFeature)reference, (Object)targetVariable);
    }

    @Override
    protected void setProperties(Element element, EObject eObject, String propertyName) {
        String propertyAttribute = element.getAttribute(propertyName);
        if (eObject instanceof CorrelationSet) {
            ((CorrelationSet)eObject).getProperties().clear();
        } else if (eObject instanceof To) {
            ((To)eObject).setProperty(null);
        } else if (eObject instanceof From) {
            ((From)eObject).setProperty(null);
        }
        if (propertyAttribute == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(propertyAttribute);
        while (st.hasMoreTokens()) {
            QName qName = BPELUtils.createQName(element, st.nextToken());
            PropertyProxy property = new PropertyProxy(this.getResource().getURI(), qName);
            if (eObject instanceof CorrelationSet) {
                ((CorrelationSet)eObject).getProperties().add((Object)property);
                continue;
            }
            if (eObject instanceof To) {
                ((To)eObject).setProperty(property);
                continue;
            }
            if (!(eObject instanceof From)) continue;
            ((From)eObject).setProperty(property);
        }
    }

    @Override
    protected void setCompensationHandler(Element element, EObject eObject) {
        Element compensationHandlerElement = ReconciliationHelper.getBPELChildElementByLocalName(element, "compensationHandler");
        CompensationHandler compensationHandler = null;
        if (eObject instanceof Invoke) {
            compensationHandler = ((Invoke)eObject).getCompensationHandler();
        } else if (eObject instanceof Scope) {
            compensationHandler = ((Scope)eObject).getCompensationHandler();
        }
        CompensationHandler oldCompensationHandler = compensationHandler;
        if (compensationHandlerElement != null && compensationHandler == null) {
            compensationHandler = this.xml2CompensationHandler(null, compensationHandlerElement);
            this.xml2ExtensibleElement(compensationHandler, compensationHandlerElement);
        } else if (compensationHandlerElement == null) {
            compensationHandler = null;
        }
        if (oldCompensationHandler != compensationHandler) {
            if (eObject instanceof Invoke) {
                ((Invoke)eObject).setCompensationHandler(compensationHandler);
            } else if (eObject instanceof Scope) {
                ((Scope)eObject).setCompensationHandler(compensationHandler);
            }
        }
    }

    @Override
    protected void setFaultHandler(Element element, BPELExtensibleElement extensibleElement) {
        Element faultHandlerElement = ReconciliationHelper.getBPELChildElementByLocalName(element, "faultHandlers");
        FaultHandler faultHandler = null;
        if (extensibleElement instanceof Process) {
            faultHandler = ((Process)extensibleElement).getFaultHandlers();
        } else if (extensibleElement instanceof Invoke) {
            faultHandler = ((Invoke)extensibleElement).getFaultHandler();
        }
        FaultHandler oldFaultHandler = faultHandler;
        if (faultHandlerElement != null && faultHandler == null) {
            faultHandler = this.xml2FaultHandler(null, faultHandlerElement);
        } else if (faultHandlerElement == null) {
            faultHandler = null;
        }
        if (oldFaultHandler != faultHandler) {
            if (extensibleElement instanceof Process) {
                ((Process)extensibleElement).setFaultHandlers(faultHandler);
            } else if (extensibleElement instanceof Invoke) {
                ((Invoke)extensibleElement).setFaultHandler(faultHandler);
            }
        }
    }

    @Override
    protected void setEventHandler(Element element, BPELExtensibleElement extensibleElement) {
        Element eventHandlerElement = ReconciliationHelper.getBPELChildElementByLocalName(element, "eventHandlers");
        EventHandler eventHandler = null;
        if (extensibleElement instanceof Process) {
            eventHandler = ((Process)extensibleElement).getEventHandlers();
        } else if (extensibleElement instanceof Scope) {
            eventHandler = ((Scope)extensibleElement).getEventHandlers();
        }
        EventHandler oldEventHandler = eventHandler;
        if (eventHandlerElement != null && eventHandler == null) {
            eventHandler = this.xml2EventHandler(null, eventHandlerElement);
        } else if (eventHandlerElement == null) {
            eventHandler = null;
        }
        if (oldEventHandler != eventHandler) {
            if (extensibleElement instanceof Process) {
                ((Process)extensibleElement).setEventHandlers(eventHandler);
            } else if (extensibleElement instanceof Scope) {
                ((Scope)extensibleElement).setEventHandlers(eventHandler);
            }
        }
    }

    @Override
    protected void setStandardAttributes(Element activityElement, Activity activity) {
        Attr name = activityElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            activity.setName(name.getValue());
        } else {
            activity.setName(null);
        }
        Attr suppressJoinFailure = activityElement.getAttributeNode("suppressJoinFailure");
        if (suppressJoinFailure != null && suppressJoinFailure.getSpecified()) {
            activity.setSuppressJoinFailure(BPELUtils.xml2boolean(suppressJoinFailure.getValue()));
        } else {
            activity.unsetSuppressJoinFailure();
        }
    }

    @Override
    protected void setOperationParms(Element activityElement, PartnerActivity activity, EReference variableReference, EReference inputVariableReference, EReference outputVariableReference, EReference partnerReference) {
        Element correlationsElement;
        this.setPartnerLink(activityElement, (EObject)activity, partnerReference);
        PortType portType = null;
        if (activityElement.hasAttribute("portType")) {
            portType = BPELUtils.getPortType(this.getResource().getURI(), activityElement, "portType");
            activity.setPortType(portType);
        } else {
            activity.setPortType(null);
        }
        if (activityElement.hasAttribute("operation")) {
            if (portType != null) {
                activity.setOperation(BPELUtils.getOperation(this.getResource().getURI(), portType, activityElement, "operation"));
            } else {
                ((PartnerActivityImpl)activity).setOperationName(activityElement.getAttribute("operation"));
            }
        } else {
            activity.setOperation(null);
        }
        if (variableReference != null) {
            this.setVariable(activityElement, (EObject)activity, "variable", variableReference);
        }
        if (inputVariableReference != null) {
            this.setVariable(activityElement, (EObject)activity, "inputVariable", inputVariableReference);
        }
        if (outputVariableReference != null) {
            this.setVariable(activityElement, (EObject)activity, "outputVariable", outputVariableReference);
        }
        if ((correlationsElement = ReconciliationHelper.getBPELChildElementByLocalName(activityElement, "correlations")) != null && activity.getCorrelations() == null) {
            activity.setCorrelations(this.xml2Correlations(activity.getCorrelations(), correlationsElement));
        } else if (correlationsElement == null) {
            activity.setCorrelations(null);
        }
    }

    @Override
    protected void setOperationParmsOnMessage(Element activityElement, OnMessage onMessage) {
        this.setPartnerLink(activityElement, (EObject)onMessage, BPELPackage.eINSTANCE.getOnMessage_PartnerLink());
        PortType portType = null;
        if (activityElement.hasAttribute("portType")) {
            portType = BPELUtils.getPortType(this.getResource().getURI(), activityElement, "portType");
            onMessage.setPortType(portType);
        } else {
            onMessage.setPortType(null);
        }
        if (activityElement.hasAttribute("operation")) {
            if (portType != null) {
                onMessage.setOperation(BPELUtils.getOperation(this.getResource().getURI(), portType, activityElement, "operation"));
            } else {
                ((OnMessageImpl)onMessage).setOperationName(activityElement.getAttribute("operation"));
            }
        } else {
            onMessage.setOperation(null);
        }
        this.setVariable(activityElement, (EObject)onMessage, "variable", BPELPackage.eINSTANCE.getOnMessage_Variable());
        Element correlationsElement = ReconciliationHelper.getBPELChildElementByLocalName(activityElement, "correlations");
        if (correlationsElement != null && onMessage.getCorrelations() == null) {
            onMessage.setCorrelations(this.xml2Correlations(onMessage.getCorrelations(), correlationsElement));
        } else if (correlationsElement == null) {
            onMessage.setCorrelations(null);
        }
    }

    @Override
    protected void setOperationParmsOnEvent(Element activityElement, OnEvent onEvent) {
        QName qName;
        this.setPartnerLink(activityElement, (EObject)onEvent, BPELPackage.eINSTANCE.getOnEvent_PartnerLink());
        PortType portType = null;
        if (activityElement.hasAttribute("portType")) {
            portType = BPELUtils.getPortType(this.getResource().getURI(), activityElement, "portType");
            onEvent.setPortType(portType);
        } else {
            onEvent.setPortType(null);
        }
        if (activityElement.hasAttribute("operation")) {
            if (portType != null) {
                onEvent.setOperation(BPELUtils.getOperation(this.getResource().getURI(), portType, activityElement, "operation"));
            } else {
                ((OnEventImpl)onEvent).setOperationName(activityElement.getAttribute("operation"));
            }
        } else {
            onEvent.setOperation(null);
        }
        if (activityElement.hasAttribute("variable")) {
            Variable variable = BPELFactory.eINSTANCE.createVariable();
            String name = activityElement.getAttribute("variable");
            variable.setName(name);
            onEvent.setVariable(variable);
        } else {
            onEvent.setVariable(null);
        }
        if (activityElement.hasAttribute("messageType")) {
            qName = BPELUtils.createAttributeValue(activityElement, "messageType");
            MessageProxy messageType = new MessageProxy(this.getResource().getURI(), qName);
            onEvent.setMessageType((Message)messageType);
        } else {
            onEvent.setMessageType(null);
        }
        if (activityElement.hasAttribute("element")) {
            qName = BPELUtils.createAttributeValue(activityElement, "element");
            XSDElementDeclarationProxy element = new XSDElementDeclarationProxy(this.getResource().getURI(), qName);
            onEvent.setXSDElement((XSDElementDeclaration)element);
        } else {
            onEvent.setXSDElement(null);
        }
        Element correlationsElement = ReconciliationHelper.getBPELChildElementByLocalName(activityElement, "correlations");
        if (correlationsElement != null && onEvent.getCorrelations() == null) {
            onEvent.setCorrelations(this.xml2Correlations(onEvent.getCorrelations(), correlationsElement));
        } else if (correlationsElement == null) {
            onEvent.setCorrelations(null);
        }
    }

    @Override
    protected List<EObject> parseDocument(Document document) {
        Element element = document != null ? document.getDocumentElement() : null;
        ArrayList<EObject> list = new ArrayList<EObject>();
        if (element == null) {
            return list;
        }
        if (element.getLocalName().equals("bag")) {
            Node n = element.getFirstChild();
            while (n != null) {
                EObject next;
                if (n instanceof Element && (next = this.parseElement((Element)n)) != null) {
                    list.add(next);
                }
                n = n.getNextSibling();
            }
        } else {
            EObject next = this.parseElement(element);
            if (next != null) {
                list.add(next);
            }
        }
        return list;
    }

    EObject parseElement(Element element) {
        Method parseMethod = this.getParseMethod(element);
        if (parseMethod == null) {
            return null;
        }
        try {
            return (EObject)parseMethod.invoke((Object)this, element);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    Method getParseMethod(Element element) {
        if (!BPELUtils.isBPELElement(element)) {
            return null;
        }
        String methodName = element.getLocalName();
        methodName = "xml2" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        return this.lookupMethod(this.getClass(), methodName, Element.class);
    }

    Method lookupMethod(Class<?> target, String methodName, Class<?> ... args) {
        if (target == null || target == Object.class) {
            return null;
        }
        Method[] methodArray = target.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (methodName.equals(m.getName()) && m.getParameterTypes().length == args.length) {
                Class<?>[] argTypes = m.getParameterTypes();
                int i = 0;
                while (i < args.length) {
                    if (!argTypes[i].isAssignableFrom(args[i])) {
                        // empty if block
                    }
                    ++i;
                }
                return m;
            }
            ++n2;
        }
        return this.lookupMethod(target.getSuperclass(), methodName, args);
    }

    @Override
    protected Process xml2Resource(Document document) {
        Element processElement;
        Element element = processElement = document != null ? document.getDocumentElement() : null;
        if (processElement == null) {
            return null;
        }
        return this.xml2Process(processElement);
    }

    @Override
    protected Process xml2Process(Element processElement) {
        Element correlationSetsElement;
        if (!processElement.getLocalName().equals("process")) {
            return null;
        }
        if (this.process == null) {
            this.process = BPELFactory.eINSTANCE.createProcess();
            this.process.setElement(processElement);
        }
        this.saveNamespacePrefix((EObject)this.process, processElement);
        if (processElement.hasAttribute("name")) {
            this.process.setName(processElement.getAttribute("name"));
        } else {
            this.process.setName(null);
        }
        if (processElement.hasAttribute("targetNamespace")) {
            this.process.setTargetNamespace(processElement.getAttribute("targetNamespace"));
        } else {
            this.process.setTargetNamespace(null);
        }
        if (processElement.hasAttribute("suppressJoinFailure")) {
            this.process.setSuppressJoinFailure(BPELUtils.xml2boolean(processElement.getAttribute("suppressJoinFailure")));
        } else {
            this.process.unsetSuppressJoinFailure();
        }
        if (processElement.hasAttribute("exitOnStandardFault")) {
            this.process.setExitOnStandardFault(BPELUtils.xml2boolean(processElement.getAttribute("exitOnStandardFault")));
        } else {
            this.process.setExitOnStandardFault(false);
        }
        if (processElement.hasAttribute("variableAccessSerializable")) {
            this.process.setVariableAccessSerializable(BPELUtils.xml2boolean(processElement.getAttribute("variableAccessSerializable")));
        } else {
            this.process.unsetVariableAccessSerializable();
        }
        if (processElement.hasAttribute("queryLanguage")) {
            this.process.setQueryLanguage(processElement.getAttribute("queryLanguage"));
        } else {
            this.process.unsetQueryLanguage();
        }
        if (processElement.hasAttribute("expressionLanguage")) {
            this.process.setExpressionLanguage(processElement.getAttribute("expressionLanguage"));
        } else {
            this.process.unsetExpressionLanguage();
        }
        if (processElement.hasAttribute("abstractProcessProfile")) {
            this.process.setAbstractProcessProfile(processElement.getAttribute("abstractProcessProfile"));
        } else {
            this.process.unsetAbstractProcessProfile();
        }
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(processElement, "import");
        this.syncLists(processElement, childElements, this.process.getImports(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Import(null, element);
            }
        });
        Element partnerLinksElement = ReconciliationHelper.getBPELChildElementByLocalName(processElement, "partnerLinks");
        if (partnerLinksElement != null && (this.process.getPartnerLinks() == null || this.process.getPartnerLinks().getChildren().size() == 0)) {
            this.process.setPartnerLinks(this.xml2PartnerLinks(this.process.getPartnerLinks(), partnerLinksElement));
        } else if (partnerLinksElement == null) {
            this.process.setPartnerLinks(null);
        }
        Element variablesElement = ReconciliationHelper.getBPELChildElementByLocalName(processElement, "variables");
        if (variablesElement != null) {
            if (this.process.getVariables() == null || this.process.getVariables().getChildren() == null || this.process.getVariables().getChildren().size() == 0) {
                this.process.setVariables(this.xml2Variables(this.process.getVariables(), variablesElement));
            }
        } else {
            this.process.setVariables(null);
        }
        if ((correlationSetsElement = ReconciliationHelper.getBPELChildElementByLocalName(processElement, "correlationSets")) != null && (this.process.getCorrelationSets() == null || this.process.getCorrelationSets().getChildren() == null)) {
            this.process.setCorrelationSets(this.xml2CorrelationSets(this.process.getCorrelationSets(), correlationSetsElement));
        } else if (correlationSetsElement == null) {
            this.process.setCorrelationSets(null);
        }
        Element messageExchangesElements = ReconciliationHelper.getBPELChildElementByLocalName(processElement, "messageExchanges");
        if (messageExchangesElements != null && (this.process.getMessageExchanges() == null || this.process.getMessageExchanges().getChildren() == null)) {
            this.process.setMessageExchanges(this.xml2MessageExchanges(this.process.getMessageExchanges(), messageExchangesElements));
        } else if (messageExchangesElements == null) {
            this.process.setMessageExchanges(null);
        }
        Element extensionsElement = ReconciliationHelper.getBPELChildElementByLocalName(processElement, "extensions");
        if (extensionsElement != null && this.process.getExtensions() == null) {
            this.process.setExtensions(this.xml2Extensions(this.process.getExtensions(), extensionsElement));
        } else if (extensionsElement == null) {
            this.process.setExtensions(null);
        }
        this.setFaultHandler(processElement, this.process);
        this.setEventHandler(processElement, this.process);
        this.process.setActivity(this.xml2Activity(null, processElement));
        this.xml2ExtensibleElement(this.process, processElement);
        return this.process;
    }

    protected PartnerLinks xml2PartnerLinks(PartnerLinks partnerLinks, Element partnerLinksElement) {
        if (!partnerLinksElement.getLocalName().equals("partnerLinks")) {
            return null;
        }
        if (partnerLinks == null) {
            partnerLinks = BPELFactory.eINSTANCE.createPartnerLinks();
            partnerLinks.setElement(partnerLinksElement);
        }
        this.saveNamespacePrefix((EObject)partnerLinks, partnerLinksElement);
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(partnerLinksElement, "partnerLink");
        EList<PartnerLink> childrenList = partnerLinks.getChildren();
        this.syncLists(partnerLinksElement, childElements, childrenList, new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2PartnerLink(null, element);
            }
        });
        this.xml2ExtensibleElement(partnerLinks, partnerLinksElement);
        return partnerLinks;
    }

    protected Variables xml2Variables(Variables variables, Element variablesElement) {
        if (!variablesElement.getLocalName().equals("variables")) {
            return null;
        }
        if (variables == null) {
            variables = BPELFactory.eINSTANCE.createVariables();
            variables.setElement(variablesElement);
        }
        this.saveNamespacePrefix((EObject)variables, variablesElement);
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(variablesElement, "variable");
        EList<Variable> childrenList = variables.getChildren();
        this.syncLists(variablesElement, childElements, childrenList, new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Variable(null, element);
            }
        });
        this.xml2ExtensibleElement(variables, variablesElement);
        return variables;
    }

    protected CorrelationSets xml2CorrelationSets(CorrelationSets correlationSets, Element correlationSetsElement) {
        if (!correlationSetsElement.getLocalName().equals("correlationSets")) {
            return null;
        }
        if (correlationSets == null) {
            correlationSets = BPELFactory.eINSTANCE.createCorrelationSets();
            correlationSets.setElement(correlationSetsElement);
        }
        this.saveNamespacePrefix((EObject)correlationSets, correlationSetsElement);
        this.syncLists(correlationSetsElement, ReconciliationHelper.getBPELChildElementsByLocalName(correlationSetsElement, "correlationSet"), correlationSets.getChildren(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2CorrelationSet(null, element);
            }
        });
        this.xml2ExtensibleElement(correlationSets, correlationSetsElement);
        return correlationSets;
    }

    protected FromParts xml2FromParts(FromParts fromParts, Element fromPartsElement) {
        if (!fromPartsElement.getLocalName().equals("fromParts")) {
            return null;
        }
        if (fromParts == null) {
            fromParts = BPELFactory.eINSTANCE.createFromParts();
            fromParts.setElement(fromPartsElement);
        }
        this.saveNamespacePrefix((EObject)fromParts, fromPartsElement);
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(fromPartsElement, "fromPart");
        EList<FromPart> childrenList = fromParts.getChildren();
        this.syncLists(fromPartsElement, childElements, childrenList, new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2FromPart(null, element);
            }
        });
        this.xml2ExtensibleElement(fromParts, fromPartsElement);
        return fromParts;
    }

    protected ToParts xml2ToParts(ToParts toParts, Element toPartsElement) {
        if (!toPartsElement.getLocalName().equals("toParts")) {
            return null;
        }
        if (toParts == null) {
            toParts = BPELFactory.eINSTANCE.createToParts();
            toParts.setElement(toPartsElement);
        }
        this.saveNamespacePrefix((EObject)toParts, toPartsElement);
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(toPartsElement, "toPart");
        EList<ToPart> childrenList = toParts.getChildren();
        this.syncLists(toPartsElement, childElements, childrenList, new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2ToPart(null, element);
            }
        });
        this.xml2ExtensibleElement(toParts, toPartsElement);
        return toParts;
    }

    protected MessageExchanges xml2MessageExchanges(MessageExchanges messageExchanges, Element messageExchangesElement) {
        if (!messageExchangesElement.getLocalName().equals("messageExchanges")) {
            return null;
        }
        if (messageExchanges == null) {
            messageExchanges = BPELFactory.eINSTANCE.createMessageExchanges();
            messageExchanges.setElement(messageExchangesElement);
        }
        this.saveNamespacePrefix((EObject)messageExchanges, messageExchangesElement);
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(messageExchangesElement, "messageExchange");
        EList<MessageExchange> childrenList = messageExchanges.getChildren();
        this.syncLists(messageExchangesElement, childElements, childrenList, new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2MessageExchange(null, element);
            }
        });
        this.xml2ExtensibleElement(messageExchanges, messageExchangesElement);
        return messageExchanges;
    }

    protected Extensions xml2Extensions(Extensions extensions, Element extensionsElement) {
        if (!extensionsElement.getLocalName().equals("extensions")) {
            return null;
        }
        if (extensions == null) {
            extensions = BPELFactory.eINSTANCE.createExtensions();
            extensions.setElement(extensionsElement);
        }
        this.saveNamespacePrefix((EObject)extensions, extensionsElement);
        this.syncLists(extensionsElement, ReconciliationHelper.getBPELChildElementsByLocalName(extensionsElement, "extension"), extensions.getChildren(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Extension(null, element);
            }
        });
        this.xml2ExtensibleElement(extensions, extensionsElement);
        return extensions;
    }

    protected CompensationHandler xml2CompensationHandler(CompensationHandler compensationHandler, Element activityElement) {
        if (compensationHandler == null) {
            compensationHandler = BPELFactory.eINSTANCE.createCompensationHandler();
            compensationHandler.setElement(activityElement);
        }
        this.saveNamespacePrefix((EObject)compensationHandler, activityElement);
        compensationHandler.setActivity(this.getChildActivity(compensationHandler, activityElement));
        return compensationHandler;
    }

    protected CorrelationSet xml2CorrelationSet(CorrelationSet correlationSet, Element correlationSetElement) {
        if (correlationSet == null) {
            correlationSet = BPELFactory.eINSTANCE.createCorrelationSet();
            correlationSet.setElement(correlationSetElement);
        }
        this.saveNamespacePrefix((EObject)correlationSet, correlationSetElement);
        if (correlationSetElement == null) {
            return correlationSet;
        }
        Attr name = correlationSetElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            correlationSet.setName(name.getValue());
        } else {
            correlationSet.setName(null);
        }
        this.setProperties(correlationSetElement, (EObject)correlationSet, "properties");
        this.xml2ExtensibleElement(correlationSet, correlationSetElement);
        return correlationSet;
    }

    protected MessageExchange xml2MessageExchange(MessageExchange messageExchange, Element messageExchangeElement) {
        if (!messageExchangeElement.getLocalName().equals("messageExchange")) {
            return null;
        }
        if (messageExchange == null) {
            messageExchange = BPELFactory.eINSTANCE.createMessageExchange();
            messageExchange.setElement(messageExchangeElement);
        }
        this.saveNamespacePrefix((EObject)messageExchange, messageExchangeElement);
        if (messageExchangeElement == null) {
            return messageExchange;
        }
        if (!messageExchangeElement.getLocalName().equals("messageExchange")) {
            return null;
        }
        this.saveNamespacePrefix((EObject)messageExchange, messageExchangeElement);
        if (messageExchangeElement.hasAttribute("name")) {
            messageExchange.setName(messageExchangeElement.getAttribute("name"));
        } else {
            messageExchange.setName(null);
        }
        this.xml2ExtensibleElement(messageExchange, messageExchangeElement);
        return messageExchange;
    }

    protected Extension xml2Extension(Extension extension, Element extensionElement) {
        if (extension == null) {
            extension = BPELFactory.eINSTANCE.createExtension();
            extension.setElement(extensionElement);
        }
        this.saveNamespacePrefix((EObject)extension, extensionElement);
        if (extensionElement == null) {
            return extension;
        }
        if (extensionElement.hasAttribute("namespace")) {
            extension.setNamespace(extensionElement.getAttribute("namespace"));
        } else {
            extension.setNamespace(null);
        }
        if (extensionElement.hasAttribute("mustUnderstand")) {
            extension.setMustUnderstand(BPELUtils.xml2boolean(extensionElement.getAttribute("mustUnderstand")));
        } else {
            extension.unsetMustUnderstand();
        }
        this.xml2ExtensibleElement(extension, extensionElement);
        return extension;
    }

    protected PartnerLink xml2PartnerLink(PartnerLink partnerLink, Element partnerLinkElement) {
        if (!partnerLinkElement.getLocalName().equals("partnerLink")) {
            return null;
        }
        if (partnerLink == null) {
            partnerLink = BPELFactory.eINSTANCE.createPartnerLink();
            partnerLink.setElement(partnerLinkElement);
        }
        this.saveNamespacePrefix((EObject)partnerLink, partnerLinkElement);
        if (partnerLinkElement.hasAttribute("name")) {
            partnerLink.setName(partnerLinkElement.getAttribute("name"));
        } else {
            partnerLink.setName(null);
        }
        if (partnerLinkElement.hasAttribute("initializePartnerRole")) {
            partnerLink.setInitializePartnerRole(BPELUtils.xml2boolean(partnerLinkElement.getAttribute("initializePartnerRole")));
        } else {
            partnerLink.unsetInitializePartnerRole();
        }
        Attr partnerLinkTypeName = partnerLinkElement.getAttributeNode("partnerLinkType");
        if (partnerLinkTypeName != null && partnerLinkTypeName.getSpecified()) {
            QName sltQName = BPELUtils.createAttributeValue(partnerLinkElement, "partnerLinkType");
            PartnerLinkTypeProxy slt = new PartnerLinkTypeProxy(this.getResource().getURI(), sltQName);
            if (slt != null) {
                Role oldRole;
                RoleProxy role;
                PartnerLinkType oldPartnerLinkType = partnerLink.getPartnerLinkType();
                if (!sltQName.getLocalPart().equals(oldPartnerLinkType == null ? null : oldPartnerLinkType.getName())) {
                    partnerLink.setPartnerLinkType(slt);
                }
                if (partnerLinkElement.hasAttribute("myRole")) {
                    role = new RoleProxy(this.getResource(), slt, partnerLinkElement.getAttribute("myRole"));
                    oldRole = partnerLink.getMyRole();
                    if (!role.getName().equals(oldRole == null ? null : oldRole.getName())) {
                        partnerLink.setMyRole(role);
                    }
                } else {
                    partnerLink.setMyRole(null);
                }
                if (partnerLinkElement.hasAttribute("partnerRole")) {
                    role = new RoleProxy(this.getResource(), slt, partnerLinkElement.getAttribute("partnerRole"));
                    oldRole = partnerLink.getPartnerRole();
                    if (!role.getName().equals(oldRole == null ? null : oldRole.getName())) {
                        partnerLink.setPartnerRole(role);
                    }
                } else {
                    partnerLink.setPartnerRole(null);
                }
            } else {
                partnerLink.setPartnerLinkType(null);
            }
        } else {
            partnerLink.setPartnerLinkType(null);
        }
        this.xml2ExtensibleElement(partnerLink, partnerLinkElement);
        return partnerLink;
    }

    protected Variable xml2Variable(Variable variable, Element variableElement) {
        QName qName;
        if (!variableElement.getLocalName().equals("variable")) {
            return null;
        }
        if (variable == null) {
            variable = BPELFactory.eINSTANCE.createVariable();
            variable.setElement(variableElement);
        }
        this.saveNamespacePrefix((EObject)variable, variableElement);
        if (variableElement.hasAttribute("name")) {
            variable.setName(variableElement.getAttribute("name"));
        } else {
            variable.setName(null);
        }
        if (variableElement.hasAttribute("messageType")) {
            qName = BPELUtils.createAttributeValue(variableElement, "messageType");
            MessageProxy messageType = new MessageProxy(this.getResource().getURI(), qName);
            variable.setMessageType((Message)messageType);
        } else {
            variable.setMessageType(null);
        }
        if (variableElement.hasAttribute("type")) {
            qName = BPELUtils.createAttributeValue(variableElement, "type");
            XSDTypeDefinitionProxy type = new XSDTypeDefinitionProxy(this.getResource().getURI(), qName);
            variable.setType((XSDTypeDefinition)type);
        } else {
            variable.setType(null);
        }
        if (variableElement.hasAttribute("element")) {
            qName = BPELUtils.createAttributeValue(variableElement, "element");
            XSDElementDeclarationProxy element = new XSDElementDeclarationProxy(this.getResource().getURI(), qName);
            variable.setXSDElement((XSDElementDeclaration)element);
        } else {
            variable.setXSDElement(null);
        }
        Element fromElement = ReconciliationHelper.getBPELChildElementByLocalName(variableElement, "from");
        if (fromElement != null && variable.getFrom() == null) {
            variable.setFrom(this.xml2From(variable.getFrom(), fromElement));
        } else if (fromElement == null) {
            variable.setFrom(null);
        }
        this.xml2ExtensibleElement(variable, variableElement);
        return variable;
    }

    protected FaultHandler xml2FaultHandler(FaultHandler faultHandler, Element faultHandlerElement) {
        String localName = faultHandlerElement.getLocalName();
        if (!localName.equals("faultHandlers") && !localName.equals("invoke")) {
            return null;
        }
        if (faultHandler == null) {
            faultHandler = BPELFactory.eINSTANCE.createFaultHandler();
        }
        if (localName.equals("faultHandlers")) {
            faultHandler.setElement(faultHandlerElement);
        }
        this.saveNamespacePrefix((EObject)faultHandler, faultHandlerElement);
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(faultHandlerElement, "catch");
        this.syncLists(faultHandlerElement, childElements, faultHandler.getCatch(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Catch(null, element);
            }
        });
        Element catchAllElement = ReconciliationHelper.getBPELChildElementByLocalName(faultHandlerElement, "catchAll");
        if (catchAllElement != null && faultHandler.getCatchAll() == null) {
            faultHandler.setCatchAll(this.xml2CatchAll(faultHandler.getCatchAll(), catchAllElement));
        } else if (catchAllElement == null) {
            faultHandler.setCatchAll(null);
        }
        if (faultHandlerElement.getLocalName().equals("faultHandlers")) {
            this.xml2ExtensibleElement(faultHandler, faultHandlerElement);
        }
        return faultHandler;
    }

    protected CatchAll xml2CatchAll(CatchAll catchAll, Element catchAllElement) {
        if (!catchAllElement.getLocalName().equals("catchAll")) {
            return null;
        }
        if (catchAll == null) {
            catchAll = BPELFactory.eINSTANCE.createCatchAll();
            catchAll.setElement(catchAllElement);
        }
        this.saveNamespacePrefix((EObject)catchAll, catchAllElement);
        catchAll.setActivity(this.getChildActivity(catchAll, catchAllElement));
        this.xml2ExtensibleElement(catchAll, catchAllElement);
        return catchAll;
    }

    protected Catch xml2Catch(Catch _catch, Element catchElement) {
        QName qName;
        if (_catch == null) {
            _catch = BPELFactory.eINSTANCE.createCatch();
            _catch.setElement(catchElement);
        }
        this.saveNamespacePrefix((EObject)_catch, catchElement);
        if (catchElement == null) {
            return _catch;
        }
        if (catchElement.hasAttribute("faultName")) {
            qName = BPELUtils.createAttributeValue(catchElement, "faultName");
            _catch.setFaultName(qName);
        } else {
            _catch.setFaultName(null);
        }
        if (catchElement.hasAttribute("faultVariable")) {
            if (_catch.getFaultVariable() == null) {
                Variable variable = BPELFactory.eINSTANCE.createVariable();
                variable.setName(catchElement.getAttribute("faultVariable"));
                _catch.setFaultVariable(variable);
            }
        } else {
            _catch.setFaultVariable(null);
        }
        if (catchElement.hasAttribute("faultMessageType")) {
            qName = BPELUtils.createAttributeValue(catchElement, "faultMessageType");
            MessageProxy messageType = new MessageProxy(this.getResource().getURI(), qName);
            _catch.setFaultMessageType((Message)messageType);
        } else {
            _catch.setFaultMessageType(null);
        }
        if (catchElement.hasAttribute("faultElement")) {
            qName = BPELUtils.createAttributeValue(catchElement, "faultElement");
            XSDElementDeclarationProxy element = new XSDElementDeclarationProxy(this.getResource().getURI(), qName);
            _catch.setFaultElement((XSDElementDeclaration)element);
        } else {
            _catch.setFaultElement(null);
        }
        _catch.setActivity(this.getChildActivity(_catch, catchElement));
        this.xml2ExtensibleElement(_catch, catchElement);
        return _catch;
    }

    public Activity xml2Activity(Activity activity, Element activityElement) {
        boolean checkExtensibility = true;
        String localName = activityElement.getLocalName();
        if (localName.equals("process")) {
            activity = this.getChildActivity(this.process, activityElement);
            checkExtensibility = false;
        } else if (localName.equals("receive")) {
            activity = this.xml2Receive(activity, activityElement);
        } else if (localName.equals("reply")) {
            activity = this.xml2Reply(activity, activityElement);
        } else if (localName.equals("invoke")) {
            activity = this.xml2Invoke(activity, activityElement);
        } else if (localName.equals("assign")) {
            activity = this.xml2Assign(activity, activityElement);
        } else if (localName.equals("throw")) {
            activity = this.xml2Throw(activity, activityElement);
        } else if (localName.equals("exit")) {
            activity = this.xml2Exit(activity, activityElement);
        } else if (localName.equals("wait")) {
            activity = this.xml2Wait(activity, activityElement);
        } else if (localName.equals("empty")) {
            activity = this.xml2Empty(activity, activityElement);
        } else if (localName.equals("sequence")) {
            activity = this.xml2Sequence(activity, activityElement);
        } else if (localName.equals("if")) {
            activity = this.xml2If(activity, activityElement);
        } else if (localName.equals("while")) {
            activity = this.xml2While(activity, activityElement);
        } else if (localName.equals("pick")) {
            activity = this.xml2Pick(activity, activityElement);
        } else if (localName.equals("flow")) {
            activity = this.xml2Flow(activity, activityElement);
        } else if (localName.equals("scope")) {
            activity = this.xml2Scope(activity, activityElement);
        } else if (localName.equals("compensate")) {
            activity = this.xml2Compensate(activity, activityElement);
        } else if (localName.equals("compensateScope")) {
            activity = this.xml2CompensateScope(activity, activityElement);
        } else if (localName.equals("rethrow")) {
            activity = this.xml2Rethrow(activity, activityElement);
        } else {
            if (localName.equals("extensionActivity")) {
                activity = this.xml2ExtensionActivity(activity, activityElement);
                return activity;
            }
            if (localName.equals("opaqueActivity")) {
                activity = this.xml2OpaqueActivity(activity, activityElement);
            } else if (localName.equals("forEach")) {
                activity = this.xml2ForEach(activity, activityElement);
            } else if (localName.equals("repeatUntil")) {
                activity = this.xml2RepeatUntil(activity, activityElement);
            } else if (localName.equals("validate")) {
                activity = this.xml2Validate(activity, activityElement);
            } else {
                return null;
            }
        }
        this.setStandardElements(activityElement, activity);
        if (checkExtensibility) {
            this.xml2ExtensibleElement(activity, activityElement);
            this.saveNamespacePrefix((EObject)activity, activityElement);
        }
        return activity;
    }

    @Override
    protected void setStandardElements(Element activityElement, Activity activity) {
        Element targetsElement = ReconciliationHelper.getBPELChildElementByLocalName(activityElement, "targets");
        if (targetsElement != null && activity.getTargets() == null) {
            activity.setTargets(this.xml2Targets(activity.getTargets(), targetsElement));
        } else if (targetsElement == null) {
            activity.setTargets(null);
        }
        Element sourcesElement = ReconciliationHelper.getBPELChildElementByLocalName(activityElement, "sources");
        if (sourcesElement != null && activity.getSources() == null) {
            activity.setSources(this.xml2Sources(activity.getSources(), sourcesElement));
        } else if (sourcesElement == null) {
            activity.setSources(null);
        }
    }

    protected Targets xml2Targets(Targets targets, Element targetsElement) {
        if (targets == null) {
            targets = BPELFactory.eINSTANCE.createTargets();
            targets.setElement(targetsElement);
        }
        this.syncLists(targetsElement, ReconciliationHelper.getBPELChildElementsByLocalName(targetsElement, "target"), targets.getChildren(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Target(null, element);
            }
        });
        Element joinConditionElement = ReconciliationHelper.getBPELChildElementByLocalName(targetsElement, "joinCondition");
        if (joinConditionElement != null && targets.getJoinCondition() == null) {
            targets.setJoinCondition(this.xml2Condition(targets.getJoinCondition(), joinConditionElement));
        } else if (joinConditionElement == null) {
            targets.setJoinCondition(null);
        }
        this.xml2ExtensibleElement(targets, targetsElement);
        return targets;
    }

    protected Target xml2Target(Target target, Element targetElement) {
        if (target == null) {
            target = BPELFactory.eINSTANCE.createTarget();
            target.setElement(targetElement);
        }
        this.saveNamespacePrefix((EObject)target, targetElement);
        this.xml2ExtensibleElement(target, targetElement);
        if (targetElement.hasAttribute("linkName")) {
            String linkName = targetElement.getAttribute("linkName");
            this.createLink(target, linkName);
        } else {
            target.setLink(null);
        }
        return target;
    }

    protected Sources xml2Sources(Sources sources, Element sourcesElement) {
        if (sources == null) {
            sources = BPELFactory.eINSTANCE.createSources();
            sources.setElement(sourcesElement);
        }
        this.syncLists(sourcesElement, ReconciliationHelper.getBPELChildElementsByLocalName(sourcesElement, "source"), sources.getChildren(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Source(null, element);
            }
        });
        this.xml2ExtensibleElement(sources, sourcesElement);
        return sources;
    }

    protected Source xml2Source(Source source, Element sourceElement) {
        String linkName = sourceElement.getAttribute("linkName");
        if (source == null) {
            source = BPELFactory.eINSTANCE.createSource();
            source.setElement(sourceElement);
        }
        this.saveNamespacePrefix((EObject)source, sourceElement);
        Element transitionConditionElement = ReconciliationHelper.getBPELChildElementByLocalName(sourceElement, "transitionCondition");
        if (transitionConditionElement != null && source.getTransitionCondition() == null) {
            source.setTransitionCondition(this.xml2Condition(source.getTransitionCondition(), transitionConditionElement));
        } else if (transitionConditionElement == null) {
            source.setTransitionCondition(null);
        }
        this.xml2ExtensibleElement(source, sourceElement);
        if (linkName != null) {
            this.createLink(source, linkName);
        } else {
            source.setLink(null);
        }
        return source;
    }

    protected Activity xml2Scope(Activity scopeActivity, Element scopeElement) {
        Scope scope;
        if (scopeActivity instanceof Scope) {
            scope = (Scope)scopeActivity;
        } else {
            scope = BPELFactory.eINSTANCE.createScope();
            scope.setElement(scopeElement);
        }
        Attr isolated = scopeElement.getAttributeNode("isolated");
        if (isolated != null && isolated.getSpecified()) {
            scope.setIsolated(BPELUtils.xml2boolean(isolated.getValue()));
        } else {
            scope.unsetIsolated();
        }
        Attr exitOnStandardFault = scopeElement.getAttributeNode("exitOnStandardFault");
        if (exitOnStandardFault != null && exitOnStandardFault.getSpecified()) {
            scope.setExitOnStandardFault(BPELUtils.xml2boolean(exitOnStandardFault.getValue()));
        } else {
            scope.unsetExitOnStandardFault();
        }
        Element variablesElement = ReconciliationHelper.getBPELChildElementByLocalName(scopeElement, "variables");
        if (variablesElement != null && (scope.getVariables() == null || scope.getVariables().getChildren().size() == 0)) {
            scope.setVariables(this.xml2Variables(scope.getVariables(), variablesElement));
        } else if (variablesElement == null) {
            scope.setVariables(null);
        }
        Element correlationSetsElement = ReconciliationHelper.getBPELChildElementByLocalName(scopeElement, "correlationSets");
        if (correlationSetsElement != null && (scope.getCorrelationSets() == null || scope.getCorrelationSets().getChildren().size() == 0)) {
            scope.setCorrelationSets(this.xml2CorrelationSets(scope.getCorrelationSets(), correlationSetsElement));
        } else if (correlationSetsElement == null) {
            scope.setCorrelationSets(null);
        }
        Element partnerLinksElement = ReconciliationHelper.getBPELChildElementByLocalName(scopeElement, "partnerLinks");
        if (partnerLinksElement != null && (scope.getPartnerLinks() == null || scope.getPartnerLinks().getChildren().size() == 0)) {
            scope.setPartnerLinks(this.xml2PartnerLinks(scope.getPartnerLinks(), partnerLinksElement));
        } else if (partnerLinksElement == null) {
            scope.setPartnerLinks(null);
        }
        Element messageExchangesElement = ReconciliationHelper.getBPELChildElementByLocalName(scopeElement, "messageExchanges");
        if (messageExchangesElement != null && (scope.getMessageExchanges() == null || scope.getMessageExchanges().getChildren().size() == 0)) {
            scope.setMessageExchanges(this.xml2MessageExchanges(scope.getMessageExchanges(), messageExchangesElement));
        } else if (messageExchangesElement == null) {
            scope.setMessageExchanges(null);
        }
        Element faultHandlerElement = ReconciliationHelper.getBPELChildElementByLocalName(scopeElement, "faultHandlers");
        if (faultHandlerElement != null && scope.getFaultHandlers() == null) {
            scope.setFaultHandlers(this.xml2FaultHandler(scope.getFaultHandlers(), faultHandlerElement));
        } else if (faultHandlerElement == null) {
            scope.setFaultHandlers(null);
        }
        this.setCompensationHandler(scopeElement, (EObject)scope);
        Element terminationHandlerElement = ReconciliationHelper.getBPELChildElementByLocalName(scopeElement, "terminationHandler");
        if (terminationHandlerElement != null && scope.getTerminationHandler() == null) {
            scope.setTerminationHandler(this.xml2TerminationHandler(scope.getTerminationHandler(), terminationHandlerElement));
        } else if (terminationHandlerElement == null) {
            scope.setTerminationHandler(null);
        }
        this.setEventHandler(scopeElement, scope);
        this.setStandardAttributes(scopeElement, scope);
        NodeList scopeElements = scopeElement.getChildNodes();
        Element activityElement = null;
        if (scopeElements != null && scopeElements.getLength() > 0) {
            int i = 0;
            while (i < scopeElements.getLength()) {
                if (scopeElements.item(i).getNodeType() == 1 && !(activityElement = (Element)scopeElements.item(i)).getLocalName().equals("faultHandlers") && !activityElement.getLocalName().equals("compensationHandler")) {
                    Activity activity;
                    if (scope.getActivity() == null || scope.getActivity().getElement() != activityElement) {
                        activity = this.xml2Activity(null, activityElement);
                    } else {
                        activity = scope.getActivity();
                        activityElement = activity.getElement();
                    }
                    if (activity != null) {
                        scope.setActivity(activity);
                        break;
                    }
                }
                ++i;
            }
        }
        if (activityElement == null) {
            scope.setActivity(null);
        }
        return scope;
    }

    protected Activity xml2Flow(Activity flowActivity, Element flowElement) {
        Flow flow;
        if (flowActivity instanceof Flow) {
            flow = (Flow)flowActivity;
        } else {
            flow = BPELFactory.eINSTANCE.createFlow();
            flow.setElement(flowElement);
        }
        Element linksElement = ReconciliationHelper.getBPELChildElementByLocalName(flowElement, "links");
        if (linksElement != null && flow.getLinks() == null) {
            flow.setLinks(this.xml2Links(flow.getLinks(), linksElement));
        } else if (linksElement == null) {
            flow.setLinks(null);
        }
        Element completionConditionElement = ReconciliationHelper.getBPELChildElementByLocalName(flowElement, "completionCondition");
        if (completionConditionElement != null && flow.getCompletionCondition() == null) {
            flow.setCompletionCondition(this.xml2CompletionCondition(flow.getCompletionCondition(), completionConditionElement));
        } else if (completionConditionElement == null) {
            flow.setCompletionCondition(null);
        }
        this.setStandardAttributes(flowElement, flow);
        this.syncSequences(flowElement, flow.getActivities());
        return flow;
    }

    protected Links xml2Links(Links links, Element linksElement) {
        if (!linksElement.getLocalName().equals("links")) {
            return null;
        }
        if (links == null) {
            links = BPELFactory.eINSTANCE.createLinks();
            links.setElement(linksElement);
        }
        this.saveNamespacePrefix((EObject)links, linksElement);
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(linksElement, "link");
        EList<Link> childrenList = links.getChildren();
        this.syncLists(linksElement, childElements, childrenList, new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Link(null, element);
            }
        });
        this.xml2ExtensibleElement(links, linksElement);
        return links;
    }

    protected Link xml2Link(Link link, Element linkElement) {
        if (link == null) {
            link = BPELFactory.eINSTANCE.createLink();
            link.setElement(linkElement);
        }
        this.saveNamespacePrefix((EObject)link, linkElement);
        Attr name = linkElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            link.setName(name.getValue());
        } else {
            link.setName(null);
        }
        this.xml2ExtensibleElement(link, linkElement);
        return link;
    }

    protected Activity xml2Pick(Activity pickActivity, Element pickElement) {
        Pick pick;
        if (pickActivity instanceof Pick) {
            pick = (Pick)pickActivity;
        } else {
            pick = BPELFactory.eINSTANCE.createPick();
            pick.setElement(pickElement);
        }
        Attr name = pickElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            pick.setName(name.getValue());
        } else {
            pick.setName(null);
        }
        Attr createInstance = pickElement.getAttributeNode("createInstance");
        if (createInstance != null && createInstance.getSpecified()) {
            pick.setCreateInstance(BPELUtils.xml2boolean(createInstance.getValue()));
        } else {
            pick.unsetCreateInstance();
        }
        this.syncLists(pickElement, ReconciliationHelper.getBPELChildElementsByLocalName(pickElement, "onAlarm"), pick.getAlarm(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2OnAlarm(null, element);
            }
        });
        this.syncLists(pickElement, ReconciliationHelper.getBPELChildElementsByLocalName(pickElement, "onMessage"), pick.getMessages(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2OnMessage(null, element);
            }
        });
        this.setStandardAttributes(pickElement, pick);
        return pick;
    }

    protected EventHandler xml2EventHandler(EventHandler eventHandler, Element eventHandlerElement) {
        if (eventHandler == null) {
            eventHandler = BPELFactory.eINSTANCE.createEventHandler();
            eventHandler.setElement(eventHandlerElement);
        }
        this.saveNamespacePrefix((EObject)eventHandler, eventHandlerElement);
        this.syncLists(eventHandlerElement, ReconciliationHelper.getBPELChildElementsByLocalName(eventHandlerElement, "onAlarm"), eventHandler.getAlarm(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2OnAlarm(null, element);
            }
        });
        this.syncLists(eventHandlerElement, ReconciliationHelper.getBPELChildElementsByLocalName(eventHandlerElement, "onEvent"), eventHandler.getEvents(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2OnEvent(null, element);
            }
        });
        this.xml2ExtensibleElement(eventHandler, eventHandlerElement);
        return eventHandler;
    }

    protected OnMessage xml2OnMessage(OnMessage onMessage, Element onMessageElement) {
        if (onMessage == null) {
            onMessage = BPELFactory.eINSTANCE.createOnMessage();
            onMessage.setElement(onMessageElement);
        }
        this.saveNamespacePrefix((EObject)onMessage, onMessageElement);
        this.setOperationParmsOnMessage(onMessageElement, onMessage);
        onMessage.setActivity(this.getChildActivity(onMessage, onMessageElement));
        Element fromPartsElement = ReconciliationHelper.getBPELChildElementByLocalName(onMessageElement, "fromParts");
        if (fromPartsElement != null && onMessage.getFromParts() == null) {
            onMessage.setFromParts(this.xml2FromParts(onMessage.getFromParts(), fromPartsElement));
        } else if (fromPartsElement == null) {
            onMessage.setFromParts(null);
        }
        this.setMessageExchange(onMessageElement, (EObject)onMessage, BPELPackage.eINSTANCE.getOnMessage_MessageExchange());
        this.xml2ExtensibleElement(onMessage, onMessageElement);
        return onMessage;
    }

    protected OnEvent xml2OnEvent(OnEvent onEvent, Element onEventElement) {
        if (onEvent == null) {
            onEvent = BPELFactory.eINSTANCE.createOnEvent();
            onEvent.setElement(onEventElement);
        }
        this.saveNamespacePrefix((EObject)onEvent, onEventElement);
        this.setOperationParmsOnEvent(onEventElement, onEvent);
        onEvent.setActivity(this.getChildActivity(onEvent, onEventElement));
        Element fromPartsElement = ReconciliationHelper.getBPELChildElementByLocalName(onEventElement, "fromParts");
        if (fromPartsElement != null && onEvent.getFromParts() == null) {
            FromParts fromParts = this.xml2FromParts(onEvent.getFromParts(), fromPartsElement);
            onEvent.setFromParts(fromParts);
        } else if (fromPartsElement == null) {
            onEvent.setFromParts(null);
        }
        Element correlationSetsElement = ReconciliationHelper.getBPELChildElementByLocalName(onEventElement, "correlationSets");
        if (correlationSetsElement != null && onEvent.getCorrelationSets() == null) {
            onEvent.setCorrelationSets(this.xml2CorrelationSets(onEvent.getCorrelationSets(), correlationSetsElement));
        } else if (correlationSetsElement == null) {
            onEvent.setCorrelationSets(null);
        }
        this.setMessageExchange(onEventElement, (EObject)onEvent, BPELPackage.eINSTANCE.getOnEvent_MessageExchange());
        this.xml2ExtensibleElement(onEvent, onEventElement);
        return onEvent;
    }

    protected OnAlarm xml2OnAlarm(OnAlarm onAlarm, Element onAlarmElement) {
        if (onAlarm == null) {
            onAlarm = BPELFactory.eINSTANCE.createOnAlarm();
            onAlarm.setElement(onAlarmElement);
        }
        this.saveNamespacePrefix((EObject)onAlarm, onAlarmElement);
        Element forElement = ReconciliationHelper.getBPELChildElementByLocalName(onAlarmElement, "for");
        if (forElement != null && onAlarm.getFor() == null) {
            onAlarm.setFor(this.xml2Expression(onAlarm.getFor(), forElement));
        } else if (forElement == null) {
            onAlarm.setFor(null);
        }
        Element untilElement = ReconciliationHelper.getBPELChildElementByLocalName(onAlarmElement, "until");
        if (untilElement != null && onAlarm.getUntil() == null) {
            onAlarm.setUntil(this.xml2Expression(onAlarm.getUntil(), untilElement));
        } else if (untilElement == null) {
            onAlarm.setUntil(null);
        }
        Element repeatEveryElement = ReconciliationHelper.getBPELChildElementByLocalName(onAlarmElement, "repeatEvery");
        if (repeatEveryElement != null && onAlarm.getRepeatEvery() == null) {
            onAlarm.setRepeatEvery(this.xml2Expression(onAlarm.getRepeatEvery(), repeatEveryElement));
        } else if (repeatEveryElement == null) {
            onAlarm.setRepeatEvery(null);
        }
        onAlarm.setActivity(this.getChildActivity(onAlarm, onAlarmElement));
        this.xml2ExtensibleElement(onAlarm, onAlarmElement);
        return onAlarm;
    }

    protected Activity xml2While(Activity whileActivity, Element whileElement) {
        While _while;
        if (whileActivity instanceof While) {
            _while = (While)whileActivity;
        } else {
            _while = BPELFactory.eINSTANCE.createWhile();
            _while.setElement(whileElement);
        }
        Element conditionElement = ReconciliationHelper.getBPELChildElementByLocalName(whileElement, "condition");
        if (conditionElement != null && _while.getCondition() == null) {
            _while.setCondition(this.xml2Condition(_while.getCondition(), conditionElement));
        } else if (conditionElement == null) {
            _while.setCondition(null);
        }
        _while.setActivity(this.getChildActivity(_while, whileElement));
        this.setStandardAttributes(whileElement, _while);
        return _while;
    }

    protected TerminationHandler xml2TerminationHandler(TerminationHandler terminationHandler, Element terminationHandlerElement) {
        if (terminationHandler == null) {
            terminationHandler = BPELFactory.eINSTANCE.createTerminationHandler();
            terminationHandler.setElement(terminationHandlerElement);
        }
        this.saveNamespacePrefix((EObject)terminationHandler, terminationHandlerElement);
        terminationHandler.setActivity(this.getChildActivity(terminationHandler, terminationHandlerElement));
        this.xml2ExtensibleElement(terminationHandler, terminationHandlerElement);
        return terminationHandler;
    }

    protected Activity xml2If(Activity ifActivity, Element ifElement) {
        If _if;
        if (ifActivity instanceof If) {
            _if = (If)ifActivity;
        } else {
            _if = BPELFactory.eINSTANCE.createIf();
            _if.setElement(ifElement);
        }
        Activity activity = this.getChildActivity(_if, ifElement);
        _if.setActivity(activity);
        Element conditionElement = ReconciliationHelper.getBPELChildElementByLocalName(ifElement, "condition");
        if (conditionElement != null && _if.getCondition() == null) {
            _if.setCondition(this.xml2Condition(_if.getCondition(), conditionElement));
        } else if (conditionElement == null) {
            _if.setCondition(null);
        }
        List<Element> childElements = ReconciliationHelper.getBPELChildElementsByLocalName(ifElement, "elseif");
        EList<ElseIf> childrenList = _if.getElseIf();
        this.syncLists(ifElement, childElements, childrenList, new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2ElseIf(null, element);
            }
        });
        Element elseElement = ReconciliationHelper.getBPELChildElementByLocalName(ifElement, "else");
        if (elseElement != null && _if.getElse() == null) {
            _if.setElse(this.xml2Else(_if.getElse(), elseElement));
        } else if (elseElement == null) {
            _if.setElse(null);
        }
        this.setStandardAttributes(ifElement, _if);
        return _if;
    }

    protected ElseIf xml2ElseIf(ElseIf elseIf, Element elseIfElement) {
        if (elseIf == null) {
            elseIf = BPELFactory.eINSTANCE.createElseIf();
            elseIf.setElement(elseIfElement);
        }
        this.saveNamespacePrefix((EObject)elseIf, elseIfElement);
        Element conditionElement = ReconciliationHelper.getBPELChildElementByLocalName(elseIfElement, "condition");
        if (conditionElement != null && elseIf.getCondition() == null) {
            elseIf.setCondition(this.xml2Condition(elseIf.getCondition(), conditionElement));
        } else if (conditionElement == null) {
            elseIf.setCondition(null);
        }
        elseIf.setActivity(this.getChildActivity(elseIf, elseIfElement));
        return elseIf;
    }

    protected Condition xml2Condition(Condition condition, Element conditionElement) {
        if (condition == null) {
            condition = BPELFactory.eINSTANCE.createCondition();
            condition.setElement(conditionElement);
        }
        this.xml2Expression(condition, conditionElement);
        return condition;
    }

    protected Expression xml2Expression(Expression expression, Element expressionElement) {
        if (expression == null) {
            expression = BPELFactory.eINSTANCE.createExpression();
            expression.setElement(expressionElement);
        }
        this.saveNamespacePrefix((EObject)expression, expressionElement);
        if (expressionElement == null) {
            return expression;
        }
        if (expressionElement.hasAttribute("expressionLanguage")) {
            expression.setExpressionLanguage(expressionElement.getAttribute("expressionLanguage"));
        } else {
            expression.unsetExpressionLanguage();
        }
        if (expressionElement.hasAttribute("opaque")) {
            expression.setOpaque(BPELUtils.xml2boolean(expressionElement.getAttribute("opaque")));
        } else {
            expression.unsetOpaque();
        }
        String data = this.getText(expressionElement);
        if (data != null) {
            expression.setBody(data);
        } else {
            expression.setBody(null);
        }
        return expression;
    }

    protected Else xml2Else(Else _else, Element elseElement) {
        if (_else == null) {
            _else = BPELFactory.eINSTANCE.createElse();
            _else.setElement(elseElement);
        }
        this.saveNamespacePrefix((EObject)_else, elseElement);
        Activity activity = this.getChildActivity(_else, elseElement);
        _else.setActivity(activity);
        return _else;
    }

    protected Activity xml2Sequence(Activity sequenceActivity, Element sequenceElement) {
        Sequence sequence;
        if (sequenceActivity instanceof Sequence) {
            sequence = (Sequence)sequenceActivity;
        } else {
            sequence = BPELFactory.eINSTANCE.createSequence();
            sequence.setElement(sequenceElement);
        }
        this.syncSequences(sequenceElement, sequence.getActivities());
        this.setStandardAttributes(sequenceElement, sequence);
        return sequence;
    }

    protected Activity xml2Empty(Activity activity, Element emptyElement) {
        Empty empty;
        if (activity instanceof Empty) {
            empty = (Empty)activity;
        } else {
            empty = BPELFactory.eINSTANCE.createEmpty();
            empty.setElement(emptyElement);
        }
        this.setStandardAttributes(emptyElement, empty);
        return empty;
    }

    protected Activity xml2OpaqueActivity(Activity opaque, Element opaqueActivityElement) {
        OpaqueActivity opaqueActivity;
        if (opaque instanceof OpaqueActivity) {
            opaqueActivity = (OpaqueActivity)opaque;
        } else {
            opaqueActivity = BPELFactory.eINSTANCE.createOpaqueActivity();
            opaqueActivity.setElement(opaqueActivityElement);
        }
        this.setStandardAttributes(opaqueActivityElement, opaqueActivity);
        return opaqueActivity;
    }

    protected Activity xml2Validate(Activity validateActivity, Element validateElement) {
        Validate validate;
        if (validateActivity instanceof Validate) {
            validate = (Validate)validateActivity;
        } else {
            validate = BPELFactory.eINSTANCE.createValidate();
            validate.setElement(validateElement);
        }
        this.setStandardAttributes(validateElement, validate);
        validate.getVariables().clear();
        if (validateElement.hasAttribute("variables")) {
            String variables = validateElement.getAttribute("variables");
            StringTokenizer st = new StringTokenizer(variables);
            while (st.hasMoreTokens()) {
                String variableName = st.nextToken();
                Variable targetVariable = ReconciliationBPELReader.getVariable((EObject)validate, variableName);
                if (targetVariable == null) {
                    targetVariable = new VariableProxy(this.getResource().getURI(), variableName);
                }
                validate.getVariables().add((Object)targetVariable);
            }
        }
        return validate;
    }

    protected Activity xml2Rethrow(Activity rethrowActivity, Element rethrowElement) {
        Rethrow rethrow;
        if (rethrowActivity instanceof Rethrow) {
            rethrow = (Rethrow)rethrowActivity;
        } else {
            rethrow = BPELFactory.eINSTANCE.createRethrow();
            rethrow.setElement(rethrowElement);
        }
        this.setStandardAttributes(rethrowElement, rethrow);
        return rethrow;
    }

    protected Activity xml2ExtensionActivity(Activity extensionActivity, Element extensionActivityElement) {
        List<Element> nodeList = this.getChildElements(extensionActivityElement);
        if (nodeList.size() == 1) {
            Element child = nodeList.get(0);
            String localName = child.getLocalName();
            String namespace = child.getNamespaceURI();
            QName qname = new QName(namespace, localName);
            BPELActivityDeserializer deserializer = this.extensionRegistry.getActivityDeserializer(qname);
            if (deserializer != null) {
                Map<String, String> nsMap = this.getAllNamespacesForElement(child);
                extensionActivity = deserializer.unmarshall(qname, child, extensionActivity, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
                this.setStandardAttributes(child, extensionActivity);
                this.setStandardElements(child, extensionActivity);
                extensionActivity.setElement(extensionActivityElement);
                return extensionActivity;
            }
        }
        return null;
    }

    protected Activity xml2Wait(Activity waitActivity, Element waitElement) {
        Element forElement;
        Wait wait;
        if (waitActivity instanceof Wait) {
            wait = (Wait)waitActivity;
        } else {
            wait = BPELFactory.eINSTANCE.createWait();
            wait.setElement(waitElement);
        }
        Attr name = waitElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            wait.setName(name.getValue());
        }
        if ((forElement = ReconciliationHelper.getBPELChildElementByLocalName(waitElement, "for")) != null && wait.getFor() == null) {
            wait.setFor(this.xml2Expression(wait.getFor(), forElement));
        } else if (forElement == null) {
            wait.setFor(null);
        }
        Element untilElement = ReconciliationHelper.getBPELChildElementByLocalName(waitElement, "until");
        if (untilElement != null && wait.getUntil() == null) {
            wait.setUntil(this.xml2Expression(wait.getUntil(), untilElement));
        } else if (untilElement == null) {
            wait.setUntil(null);
        }
        this.setStandardAttributes(waitElement, wait);
        return wait;
    }

    protected Activity xml2Exit(Activity activity, Element exitElement) {
        Exit exit;
        if (activity instanceof Exit) {
            exit = (Exit)activity;
        } else {
            exit = BPELFactory.eINSTANCE.createExit();
            exit.setElement(exitElement);
        }
        this.setStandardAttributes(exitElement, exit);
        return exit;
    }

    protected Activity xml2Throw(Activity throwActivity, Element throwElement) {
        Throw _throw;
        if (throwActivity instanceof Throw) {
            _throw = (Throw)throwActivity;
        } else {
            _throw = BPELFactory.eINSTANCE.createThrow();
            _throw.setElement(throwElement);
        }
        if (throwElement.hasAttribute("faultName")) {
            QName qName = BPELUtils.createAttributeValue(throwElement, "faultName");
            _throw.setFaultName(qName);
        } else {
            _throw.setFaultName(null);
        }
        this.setVariable(throwElement, (EObject)_throw, "faultVariable", BPELPackage.eINSTANCE.getThrow_FaultVariable());
        this.setStandardAttributes(throwElement, _throw);
        return _throw;
    }

    protected Activity xml2Assign(Activity assignActivity, Element assignElement) {
        Assign assign;
        if (assignActivity instanceof Assign) {
            assign = (Assign)assignActivity;
        } else {
            assign = BPELFactory.eINSTANCE.createAssign();
            assign.setElement(assignElement);
        }
        if (assignElement.hasAttribute("validate")) {
            assign.setValidate(BPELUtils.xml2boolean(assignElement.getAttribute("validate")));
        } else {
            assign.setValidate(false);
        }
        this.syncLists(assignElement, ReconciliationHelper.getBPELChildElementsByLocalName(assignElement, "copy"), assign.getCopy(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Copy(null, element);
            }
        });
        this.setStandardAttributes(assignElement, assign);
        return assign;
    }

    protected Copy xml2Copy(Copy copy, Element copyElement) {
        if (copy == null) {
            copy = BPELFactory.eINSTANCE.createCopy();
            copy.setElement(copyElement);
        }
        this.saveNamespacePrefix((EObject)copy, copyElement);
        Element fromElement = ReconciliationHelper.getBPELChildElementByLocalName(copyElement, "from");
        if (fromElement != null && copy.getFrom() == null) {
            copy.setFrom(this.xml2From(copy.getFrom(), fromElement));
        } else if (fromElement == null) {
            copy.setFrom(null);
        }
        Element toElement = ReconciliationHelper.getBPELChildElementByLocalName(copyElement, "to");
        if (toElement != null && copy.getTo() == null) {
            copy.setTo(this.xml2To(copy.getTo(), toElement));
        } else if (toElement == null) {
            copy.setTo(null);
        }
        if (copyElement.hasAttribute("keepSrcElementName")) {
            copy.setKeepSrcElementName(BPELUtils.xml2boolean(copyElement.getAttribute("keepSrcElementName")));
        } else {
            copy.unsetKeepSrcElementName();
        }
        if (copyElement.hasAttribute("ignoreMissingFromData")) {
            copy.setIgnoreMissingFromData(BPELUtils.xml2boolean(copyElement.getAttribute("ignoreMissingFromData")));
        } else {
            copy.unsetIgnoreMissingFromData();
        }
        this.xml2ExtensibleElement(copy, copyElement);
        return copy;
    }

    protected ToPart xml2ToPart(ToPart toPart, Element toPartElement) {
        if (toPart == null) {
            toPart = BPELFactory.eINSTANCE.createToPart();
            toPart.setElement(toPartElement);
        }
        this.saveNamespacePrefix((EObject)toPart, toPartElement);
        Attr part = toPartElement.getAttributeNode("part");
        if (part != null && part.getSpecified()) {
            String partAttr = toPartElement.getAttribute("part");
            ((ToPartImpl)toPart).setPartName(partAttr);
        } else {
            ((ToPartImpl)toPart).setPartName(null);
        }
        this.setVariable(toPartElement, (EObject)toPart, "fromVariable", BPELPackage.eINSTANCE.getToPart_FromVariable());
        return toPart;
    }

    protected FromPart xml2FromPart(FromPart fromPart, Element fromPartElement) {
        if (fromPart == null) {
            fromPart = BPELFactory.eINSTANCE.createFromPart();
            fromPart.setElement(fromPartElement);
        }
        this.saveNamespacePrefix((EObject)fromPart, fromPartElement);
        Attr part = fromPartElement.getAttributeNode("part");
        if (part != null && part.getSpecified()) {
            String partAttr = fromPartElement.getAttribute("part");
            ((FromPartImpl)fromPart).setPartName(partAttr);
        } else {
            ((FromPartImpl)fromPart).setPartName(null);
        }
        this.setVariable(fromPartElement, (EObject)fromPart, "toVariable", BPELPackage.eINSTANCE.getFromPart_ToVariable());
        return fromPart;
    }

    @Override
    protected To xml2To(To to, Element toElement) {
        if (to == null) {
            to = BPELFactory.eINSTANCE.createTo();
            to.setElement(toElement);
        }
        this.saveNamespacePrefix(to, toElement);
        Attr variable = toElement.getAttributeNode("variable");
        if (variable != null && variable.getSpecified()) {
            this.setVariable(toElement, to, "variable", BPELPackage.eINSTANCE.getAbstractAssignBound_Variable());
        } else {
            to.setVariable(null);
        }
        Attr part = toElement.getAttributeNode("part");
        if (part != null && part.getSpecified()) {
            String partAttr = toElement.getAttribute("part");
            ((ToImpl)to).setPartName(partAttr);
        } else {
            ((ToImpl)to).setPartName(null);
        }
        Attr partnerLink = toElement.getAttributeNode("partnerLink");
        if (partnerLink != null && partnerLink.getSpecified()) {
            this.setPartnerLink(toElement, to, BPELPackage.eINSTANCE.getAbstractAssignBound_PartnerLink());
        } else {
            to.setPartnerLink(null);
        }
        Attr property = toElement.getAttributeNode("property");
        if (property != null && property.getSpecified()) {
            this.setProperties(toElement, to, "property");
        } else {
            to.setProperty(null);
        }
        Element queryElement = ReconciliationHelper.getBPELChildElementByLocalName(toElement, "query");
        if (queryElement != null && to.getQuery() == null) {
            to.setQuery(this.xml2Query(to.getQuery(), queryElement));
        } else if (queryElement == null && partnerLink == null && variable == null) {
            Expression expression = to.getExpression();
            if (expression == null) {
                expression = BPELFactory.eINSTANCE.createExpression();
                to.setExpression(expression);
            }
            this.xml2Expression(expression, toElement);
        }
        return to;
    }

    @Override
    protected From xml2From(From from, Element fromElement) {
        Element queryElement;
        if (from == null) {
            from = BPELFactory.eINSTANCE.createFrom();
            from.setElement(fromElement);
        }
        this.saveNamespacePrefix(from, fromElement);
        Attr variable = fromElement.getAttributeNode("variable");
        if (variable != null && variable.getSpecified()) {
            this.setVariable(fromElement, from, "variable", BPELPackage.eINSTANCE.getAbstractAssignBound_Variable());
        } else {
            from.setVariable(null);
        }
        Attr part = fromElement.getAttributeNode("part");
        if (part != null && part.getSpecified()) {
            String partAttr = fromElement.getAttribute("part");
            ((FromImpl)from).setPartName(partAttr);
        } else {
            ((FromImpl)from).setPartName(null);
        }
        Attr partnerLink = fromElement.getAttributeNode("partnerLink");
        if (partnerLink != null && partnerLink.getSpecified()) {
            this.setPartnerLink(fromElement, from, BPELPackage.eINSTANCE.getAbstractAssignBound_PartnerLink());
        } else {
            from.setPartnerLink(null);
        }
        Attr property = fromElement.getAttributeNode("property");
        if (property != null && property.getSpecified()) {
            this.setProperties(fromElement, from, "property");
        }
        if ((queryElement = ReconciliationHelper.getBPELChildElementByLocalName(fromElement, "query")) != null && from.getQuery() == null) {
            from.setQuery(this.xml2Query(from.getQuery(), queryElement));
        } else if (queryElement == null) {
            from.setQuery(null);
        }
        Attr endpointReference = fromElement.getAttributeNode("endpointReference");
        if (endpointReference != null && endpointReference.getSpecified()) {
            from.setEndpointReference(EndpointReferenceRole.get(endpointReference.getValue()));
        } else {
            from.unsetEndpointReference();
        }
        Element serviceRefElement = ReconciliationHelper.getBPELChildElementByLocalName(fromElement, "service-ref");
        if (serviceRefElement != null && from.getServiceRef() == null) {
            from.setServiceRef(this.xml2ServiceRef(from.getServiceRef(), serviceRefElement));
        } else if (serviceRefElement == null) {
            from.setServiceRef(null);
        }
        Attr opaque = fromElement.getAttributeNode("opaque");
        if (opaque != null && opaque.getSpecified()) {
            from.setOpaque(BPELUtils.xml2boolean(opaque.getValue()));
        } else {
            from.unsetOpaque();
        }
        Element literalElement = ReconciliationHelper.getBPELChildElementByLocalName(fromElement, "literal");
        if (literalElement != null) {
            StringBuilder elementData = new StringBuilder(256);
            NodeList nl = literalElement.getChildNodes();
            int i = 0;
            block4: while (i < nl.getLength()) {
                Node n = nl.item(i);
                switch (n.getNodeType()) {
                    case 1: {
                        elementData.setLength(0);
                        elementData.append(BPELUtils.elementToString((Element)n));
                        break block4;
                    }
                    case 3: 
                    case 4: {
                        String data = this.getText(n);
                        if (data != null) {
                            elementData.append(data);
                        }
                    }
                    default: {
                        ++i;
                    }
                }
            }
            from.setUnsafeLiteral(Boolean.FALSE);
            String elementDataFinal = elementData.toString();
            if (!ReconciliationBPELReader.isEmptyOrWhitespace(elementDataFinal)) {
                from.setUnsafeLiteral(Boolean.TRUE);
                from.setLiteral(elementDataFinal);
            }
        } else if (variable == null && partnerLink == null && endpointReference == null && opaque == null) {
            Expression expressionObject = from.getExpression();
            if (expressionObject == null) {
                expressionObject = BPELFactory.eINSTANCE.createExpression();
                from.setExpression(expressionObject);
            }
            this.xml2Expression(expressionObject, fromElement);
        }
        if (fromElement.hasAttribute("xsi:type")) {
            QName qName = BPELUtils.createAttributeValue(fromElement, "xsi:type");
            XSDTypeDefinitionProxy type = new XSDTypeDefinitionProxy(this.getResource().getURI(), qName);
            from.setType((XSDTypeDefinition)type);
        } else {
            from.setType(null);
        }
        return from;
    }

    protected ServiceRef xml2ServiceRef(ServiceRef serviceRef, Element serviceRefElement) {
        String data;
        if (serviceRef == null) {
            serviceRef = BPELFactory.eINSTANCE.createServiceRef();
            serviceRef.setElement(serviceRefElement);
        }
        if (serviceRefElement.hasAttribute("reference-scheme")) {
            String scheme = serviceRefElement.getAttribute("reference-scheme");
            serviceRef.setReferenceScheme(scheme);
        }
        Node candidateChild = null;
        NodeList nodeList = serviceRefElement.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 1) {
                candidateChild = child;
                break;
            }
            ++i;
        }
        if (candidateChild == null) {
            candidateChild = serviceRefElement.getFirstChild();
        }
        if ((data = this.getText(candidateChild)) == null) {
            if (candidateChild != null && candidateChild.getNodeType() == 1) {
                Element childElement = (Element)candidateChild;
                QName qname = new QName(childElement.getNamespaceURI(), childElement.getLocalName());
                BPELExtensionDeserializer deserializer = null;
                try {
                    deserializer = (BPELExtensionDeserializer)this.extensionRegistry.queryDeserializer(BPELExtensibleElement.class, qname);
                }
                catch (WSDLException wSDLException) {
                    // empty catch block
                }
                if (deserializer != null && !(deserializer instanceof BPELUnknownExtensionDeserializer)) {
                    try {
                        Map<String, String> nsMap = this.getAllNamespacesForElement(serviceRefElement);
                        ExtensibilityElement extensibilityElement = deserializer.unmarshall(BPELExtensibleElement.class, qname, childElement, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
                        serviceRef.setValue(extensibilityElement);
                    }
                    catch (WSDLException e) {
                        throw new WrappedException((Exception)((Object)e));
                    }
                } else {
                    ServiceReferenceDeserializer referenceDeserializer = this.extensionRegistry.getServiceReferenceDeserializer(serviceRef.getReferenceScheme());
                    if (referenceDeserializer != null) {
                        Object serviceReference = referenceDeserializer.unmarshall(childElement, this.process);
                        serviceRef.setValue(serviceReference);
                    }
                }
            }
        } else {
            serviceRef.setValue(data);
        }
        return serviceRef;
    }

    protected Query xml2Query(Query queryObject, Element queryElement) {
        if (queryObject == null) {
            queryObject = BPELFactory.eINSTANCE.createQuery();
        }
        queryObject.setElement(queryElement);
        if (queryElement.hasAttribute("queryLanguage")) {
            String queryLanguage = queryElement.getAttribute("queryLanguage");
            queryObject.setQueryLanguage(queryLanguage);
        } else {
            queryObject.setQueryLanguage(null);
        }
        String data = this.getText(queryElement);
        if (data != null) {
            queryObject.setValue(data);
        } else {
            queryObject.setValue(null);
        }
        return queryObject;
    }

    protected Import xml2Import(Import imp, Element importElement) {
        if (!importElement.getLocalName().equals("import")) {
            return null;
        }
        if (imp == null) {
            imp = BPELFactory.eINSTANCE.createImport();
            imp.setElement(importElement);
        }
        this.saveNamespacePrefix((EObject)imp, importElement);
        if (importElement.hasAttribute("namespace")) {
            imp.setNamespace(importElement.getAttribute("namespace"));
        } else {
            imp.setNamespace(null);
        }
        if (importElement.hasAttribute("location")) {
            imp.setLocation(importElement.getAttribute("location"));
        } else {
            imp.setLocation(null);
        }
        if (importElement.hasAttribute("importType")) {
            imp.setImportType(importElement.getAttribute("importType"));
        } else {
            imp.setImportType(null);
        }
        return imp;
    }

    protected Activity xml2Invoke(Activity invokeActivity, Element invokeElement) {
        Element toPartsElement;
        Invoke invoke;
        if (invokeActivity instanceof Invoke) {
            invoke = (Invoke)invokeActivity;
        } else {
            invoke = BPELFactory.eINSTANCE.createInvoke();
            invoke.setElement(invokeElement);
        }
        this.setStandardAttributes(invokeElement, invoke);
        this.setOperationParms(invokeElement, invoke, null, BPELPackage.eINSTANCE.getInvoke_InputVariable(), BPELPackage.eINSTANCE.getInvoke_OutputVariable(), BPELPackage.eINSTANCE.getPartnerActivity_PartnerLink());
        this.setCompensationHandler(invokeElement, (EObject)invoke);
        FaultHandler faultHandler = this.xml2FaultHandler(invoke.getFaultHandler(), invokeElement);
        if (!(faultHandler == null || faultHandler.getCatch().isEmpty() && faultHandler.getCatchAll() == null)) {
            invoke.setFaultHandler(faultHandler);
        }
        if ((toPartsElement = ReconciliationHelper.getBPELChildElementByLocalName(invokeElement, "toParts")) != null && invoke.getToParts() == null) {
            invoke.setToParts(this.xml2ToParts(invoke.getToParts(), toPartsElement));
        } else if (toPartsElement == null) {
            invoke.setToParts(null);
        }
        Element fromPartsElement = ReconciliationHelper.getBPELChildElementByLocalName(invokeElement, "fromParts");
        if (fromPartsElement != null && invoke.getFromParts() == null) {
            invoke.setFromParts(this.xml2FromParts(invoke.getFromParts(), fromPartsElement));
        } else if (fromPartsElement == null) {
            invoke.setFromParts(null);
        }
        return invoke;
    }

    protected Activity xml2Reply(Activity replyActivity, Element replyElement) {
        Reply reply;
        if (replyActivity instanceof Reply) {
            reply = (Reply)replyActivity;
        } else {
            reply = BPELFactory.eINSTANCE.createReply();
            reply.setElement(replyElement);
        }
        this.setStandardAttributes(replyElement, reply);
        this.setOperationParms(replyElement, reply, BPELPackage.eINSTANCE.getReply_Variable(), null, null, BPELPackage.eINSTANCE.getPartnerActivity_PartnerLink());
        if (replyElement.hasAttribute("faultName")) {
            QName qName = BPELUtils.createAttributeValue(replyElement, "faultName");
            reply.setFaultName(qName);
        } else {
            reply.setFaultName(null);
        }
        Element toPartsElement = ReconciliationHelper.getBPELChildElementByLocalName(replyElement, "toParts");
        if (toPartsElement != null && reply.getToParts() == null) {
            reply.setToParts(this.xml2ToParts(reply.getToParts(), toPartsElement));
        } else if (toPartsElement == null) {
            reply.setToParts(null);
        }
        this.setMessageExchange(replyElement, (EObject)reply, BPELPackage.eINSTANCE.getReply_MessageExchange());
        return reply;
    }

    protected Activity xml2Receive(Activity receiveActivity, Element receiveElement) {
        Receive receive;
        if (receiveActivity instanceof Receive) {
            receive = (Receive)receiveActivity;
        } else {
            receive = BPELFactory.eINSTANCE.createReceive();
            receive.setElement(receiveElement);
        }
        this.setStandardAttributes(receiveElement, receive);
        this.setOperationParms(receiveElement, receive, BPELPackage.eINSTANCE.getReceive_Variable(), null, null, BPELPackage.eINSTANCE.getPartnerActivity_PartnerLink());
        if (receiveElement.hasAttribute("createInstance")) {
            receive.setCreateInstance(BPELUtils.xml2boolean(receiveElement.getAttribute("createInstance")));
        } else {
            receive.unsetCreateInstance();
        }
        Element fromPartsElement = ReconciliationHelper.getBPELChildElementByLocalName(receiveElement, "fromParts");
        if (fromPartsElement != null && receive.getFromParts() == null) {
            receive.setFromParts(this.xml2FromParts(receive.getFromParts(), fromPartsElement));
        } else if (fromPartsElement == null) {
            receive.setFromParts(null);
        }
        this.setMessageExchange(receiveElement, (EObject)receive, BPELPackage.eINSTANCE.getReceive_MessageExchange());
        return receive;
    }

    protected Activity xml2ForEach(Activity forEachActivity, Element forEachElement) {
        Element startCounterValueElement;
        ForEach forEach;
        if (forEachActivity instanceof ForEach) {
            forEach = (ForEach)forEachActivity;
        } else {
            forEach = BPELFactory.eINSTANCE.createForEach();
            forEach.setElement(forEachElement);
        }
        this.setStandardAttributes(forEachElement, forEach);
        if (forEachElement.hasAttribute("parallel")) {
            forEach.setParallel(BPELUtils.xml2boolean(forEachElement.getAttribute("parallel")));
        } else {
            forEach.setParallel(false);
        }
        if (forEachElement.hasAttribute("counterName")) {
            String counterName = forEachElement.getAttribute("counterName");
            if (forEach.getCounterName() == null || !forEach.getCounterName().getName().equals(counterName)) {
                Variable variable = BPELFactory.eINSTANCE.createVariable();
                variable.setName(counterName);
                QName qName = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
                XSDTypeDefinitionProxy type = new XSDTypeDefinitionProxy(this.getResource().getURI(), qName);
                variable.setType((XSDTypeDefinition)type);
                forEach.setCounterName(variable);
            }
        } else {
            forEach.setCounterName(null);
        }
        if ((startCounterValueElement = ReconciliationHelper.getBPELChildElementByLocalName(forEachElement, "startCounterValue")) != null && forEach.getStartCounterValue() == null) {
            forEach.setStartCounterValue(this.xml2Expression(forEach.getStartCounterValue(), startCounterValueElement));
        } else if (startCounterValueElement == null) {
            forEach.setStartCounterValue(null);
        }
        Element finalCounterValueElement = ReconciliationHelper.getBPELChildElementByLocalName(forEachElement, "finalCounterValue");
        if (finalCounterValueElement != null && forEach.getFinalCounterValue() == null) {
            forEach.setFinalCounterValue(this.xml2Expression(forEach.getFinalCounterValue(), finalCounterValueElement));
        } else if (finalCounterValueElement == null) {
            forEach.setFinalCounterValue(null);
        }
        Element completionConditionElement = ReconciliationHelper.getBPELChildElementByLocalName(forEachElement, "completionCondition");
        if (completionConditionElement != null && forEach.getCompletionCondition() == null) {
            forEach.setCompletionCondition(this.xml2CompletionCondition(forEach.getCompletionCondition(), completionConditionElement));
        } else if (completionConditionElement == null) {
            forEach.setCompletionCondition(null);
        }
        Activity activity = this.getChildActivity(forEach, forEachElement);
        if (activity instanceof Scope) {
            forEach.setActivity(activity);
        } else {
            forEach.setActivity(null);
        }
        return forEach;
    }

    protected CompletionCondition xml2CompletionCondition(CompletionCondition completionCondition, Element completionConditionElement) {
        Element branchesElement;
        if (completionCondition == null) {
            completionCondition = BPELFactory.eINSTANCE.createCompletionCondition();
            completionCondition.setElement(completionConditionElement);
        }
        if ((branchesElement = ReconciliationHelper.getBPELChildElementByLocalName(completionConditionElement, "branches")) != null && completionCondition.getBranches() == null) {
            completionCondition.setBranches(this.xml2Branches(completionCondition.getBranches(), branchesElement));
        } else if (branchesElement == null) {
            completionCondition.setBranches(null);
        }
        return completionCondition;
    }

    protected Branches xml2Branches(Branches branches, Element branchesElement) {
        if (branches == null) {
            branches = BPELFactory.eINSTANCE.createBranches();
            branches.setElement(branchesElement);
        }
        this.xml2Expression(branches, branchesElement);
        if (branchesElement.hasAttribute("successfulBranchesOnly")) {
            branches.setCountCompletedBranchesOnly(BPELUtils.xml2boolean(branchesElement.getAttribute("successfulBranchesOnly")));
        } else {
            branches.unsetCountCompletedBranchesOnly();
        }
        return branches;
    }

    protected Documentation xml2Documentation(Documentation documentation, Element documentationElement) {
        if (documentation == null) {
            documentation = BPELFactory.eINSTANCE.createDocumentation();
        }
        ((DocumentationImpl)documentation).setElement(documentationElement);
        if (documentationElement.hasAttribute("xml:lang")) {
            documentation.setLang(documentationElement.getAttribute("xml:lang"));
        } else {
            documentation.setLang(null);
        }
        if (documentationElement.hasAttribute("source")) {
            documentation.setSource(documentationElement.getAttribute("source"));
        } else {
            documentation.setSource(null);
        }
        String text = this.getText(documentationElement);
        if (text != null) {
            documentation.setValue(text);
        } else {
            documentation.setValue(null);
        }
        return documentation;
    }

    protected Activity xml2RepeatUntil(Activity repeatUntilActivity, Element repeatUntilElement) {
        RepeatUntil repeatUntil;
        if (repeatUntilActivity instanceof RepeatUntil) {
            repeatUntil = (RepeatUntil)repeatUntilActivity;
        } else {
            repeatUntil = BPELFactory.eINSTANCE.createRepeatUntil();
            repeatUntil.setElement(repeatUntilElement);
        }
        this.setStandardAttributes(repeatUntilElement, repeatUntil);
        Element conditionElement = ReconciliationHelper.getBPELChildElementByLocalName(repeatUntilElement, "condition");
        if (conditionElement != null && repeatUntil.getCondition() == null) {
            repeatUntil.setCondition(this.xml2Condition(repeatUntil.getCondition(), conditionElement));
        } else if (conditionElement == null) {
            repeatUntil.setCondition(null);
        }
        repeatUntil.setActivity(this.getChildActivity(repeatUntil, repeatUntilElement));
        return repeatUntil;
    }

    protected Correlations xml2Correlations(Correlations correlations, Element correlationsElement) {
        if (!correlationsElement.getLocalName().equals("correlations")) {
            return null;
        }
        if (correlations == null) {
            correlations = BPELFactory.eINSTANCE.createCorrelations();
            correlations.setElement(correlationsElement);
        }
        this.saveNamespacePrefix((EObject)correlations, correlationsElement);
        this.syncLists(correlationsElement, ReconciliationHelper.getBPELChildElementsByLocalName(correlationsElement, "correlation"), correlations.getChildren(), new Creator(){

            @Override
            public WSDLElement create(Element element) {
                return ReconciliationBPELReader.this.xml2Correlation(null, element);
            }
        });
        this.xml2ExtensibleElement(correlations, correlationsElement);
        return correlations;
    }

    protected Correlation xml2Correlation(Correlation correlation, Element correlationElement) {
        if (correlation == null) {
            correlation = BPELFactory.eINSTANCE.createCorrelation();
            correlation.setElement(correlationElement);
        }
        this.saveNamespacePrefix((EObject)correlation, correlationElement);
        if (correlationElement == null) {
            return correlation;
        }
        if (correlationElement.hasAttribute("set")) {
            String correlationSetName = correlationElement.getAttribute("set");
            CorrelationSet cSet = BPELUtils.getCorrelationSetForActivity(correlation, correlationSetName);
            if (cSet == null) {
                cSet = new CorrelationSetProxy(this.getResource().getURI(), correlationSetName);
            }
            correlation.setSet(cSet);
        } else {
            correlation.setSet(null);
        }
        Attr initiation = correlationElement.getAttributeNode("initiate");
        if (initiation != null && initiation.getSpecified()) {
            if (initiation.getValue().equals("yes")) {
                correlation.setInitiate("yes");
            } else if (initiation.getValue().equals("no")) {
                correlation.setInitiate("no");
            } else if (initiation.getValue().equals("join")) {
                correlation.setInitiate("join");
            } else {
                correlation.unsetInitiate();
            }
        } else {
            correlation.unsetInitiate();
        }
        Attr pattern = correlationElement.getAttributeNode("pattern");
        if (pattern != null && pattern.getSpecified()) {
            if (pattern.getValue().equals("request")) {
                correlation.setPattern(CorrelationPattern.REQUEST_LITERAL);
            } else if (pattern.getValue().equals("response")) {
                correlation.setPattern(CorrelationPattern.RESPONSE_LITERAL);
            } else if (pattern.getValue().equals("request-response")) {
                correlation.setPattern(CorrelationPattern.REQUESTRESPONSE_LITERAL);
            } else {
                correlation.unsetPattern();
            }
        } else {
            correlation.unsetPattern();
        }
        this.xml2ExtensibleElement(correlation, correlationElement);
        return correlation;
    }

    protected Compensate xml2Compensate(Activity compensateActivity, Element compensateElement) {
        Compensate compensate;
        if (compensateActivity instanceof Compensate) {
            compensate = (Compensate)compensateActivity;
        } else {
            compensate = BPELFactory.eINSTANCE.createCompensate();
            compensate.setElement(compensateElement);
        }
        this.setStandardAttributes(compensateElement, compensate);
        return compensate;
    }

    protected CompensateScope xml2CompensateScope(Activity compensateScopeActivity, Element compensateScopeElement) {
        CompensateScope compensateScope;
        if (compensateScopeActivity instanceof CompensateScope) {
            compensateScope = (CompensateScope)compensateScopeActivity;
        } else {
            compensateScope = BPELFactory.eINSTANCE.createCompensateScope();
            compensateScope.setElement(compensateScopeElement);
        }
        String target = compensateScopeElement.getAttribute("target");
        if (target != null && target.length() > 0) {
            compensateScope.setTarget(target);
        } else {
            compensateScope.setTarget((Activity)null);
        }
        this.setStandardAttributes(compensateScopeElement, compensateScope);
        return compensateScope;
    }

    @Override
    protected void xml2ExtensibleElement(BPELExtensibleElement extensibleElement, Element element) {
        if (this.extensionRegistry == null) {
            return;
        }
        Element documentationElement = ReconciliationHelper.getBPELChildElementByLocalName(element, "documentation");
        if (documentationElement != null && extensibleElement.getDocumentation() == null) {
            extensibleElement.setDocumentation(this.xml2Documentation(extensibleElement.getDocumentation(), documentationElement));
        } else if (documentationElement == null) {
            extensibleElement.setDocumentation(null);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        int n = nodeList.getLength();
        while (i < n) {
            String namespaceURI;
            if (nodeList.item(i) instanceof Element && !BPELConstants.isBPELNamespace(namespaceURI = ((Element)nodeList.item(i)).getNamespaceURI())) {
                nodes.add(nodeList.item(i));
            }
            ++i;
        }
        NamedNodeMap nodeMap = element.getAttributes();
        int i2 = 0;
        int n2 = nodeMap.getLength();
        while (i2 < n2) {
            Attr attr = (Attr)nodeMap.item(i2);
            if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                nodes.add(attr);
            }
            ++i2;
        }
        extensibleElement.getExtensibilityElements().clear();
        for (Node node : nodes) {
            if (MessagepropertiesConstants.isMessagePropertiesNamespace(node.getNamespaceURI())) continue;
            if (node.getNodeType() == 1) {
                this.deserialize(extensibleElement, (Element)node);
                continue;
            }
            if (node.getNodeType() != 2) continue;
            this.deserialize(extensibleElement, (Attr)node);
        }
    }

    @Override
    protected void deserialize(BPELExtensibleElement ee, Element elm) {
        QName qname = new QName(elm.getNamespaceURI(), elm.getLocalName());
        BPELExtensionDeserializer deserializer = null;
        try {
            deserializer = (BPELExtensionDeserializer)this.extensionRegistry.queryDeserializer(BPELExtensibleElement.class, qname);
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        if (deserializer == null) {
            return;
        }
        Map<String, String> nsMap = this.getAllNamespacesForElement(elm);
        try {
            ExtensibilityElement extensibilityElement = deserializer.unmarshall(ee.getClass(), qname, elm, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
            ee.addExtensibilityElement(extensibilityElement);
        }
        catch (WSDLException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    @Override
    protected void deserialize(BPELExtensibleElement ee, Attr attr) {
        if (!attr.getSpecified()) {
            return;
        }
        QName qname = new QName(attr.getNamespaceURI(), "extensibilityAttributes");
        BPELExtensionDeserializer deserializer = null;
        try {
            deserializer = (BPELExtensionDeserializer)this.extensionRegistry.queryDeserializer(BPELExtensibleElement.class, qname);
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        if (deserializer == null) {
            return;
        }
        Element tempElement = attr.getOwnerDocument().createElementNS(attr.getNamespaceURI(), String.valueOf(attr.getPrefix()) + ":extensibilityAttributes");
        tempElement.setAttribute("xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
        tempElement.setAttribute(attr.getLocalName(), attr.getNodeValue());
        Map<String, String> nsMap = this.getAllNamespacesForElement((Element)attr.getParentNode());
        try {
            ExtensibilityElement extensibilityElement = deserializer.unmarshall(BPELExtensibleElement.class, qname, tempElement, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
            if (extensibilityElement != null) {
                ee.addExtensibilityElement(extensibilityElement);
            }
        }
        catch (WSDLException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    public static boolean isEmptyOrWhitespace(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        int i = 0;
        int j = value.length();
        while (i < j) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    String getText(Node node) {
        StringBuilder sb = new StringBuilder(128);
        if (node instanceof Element) {
            node = ((Element)node).getFirstChild();
        }
        boolean bCData = false;
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: {
                    if (bCData) break;
                    Text text = (Text)node;
                    sb.append(text.getData());
                    break;
                }
                case 4: {
                    if (!bCData) {
                        sb.setLength(0);
                        bCData = true;
                    }
                    CDATASection cdata = (CDATASection)node;
                    sb.append(cdata.getData());
                }
            }
            node = node.getNextSibling();
        }
        String data = sb.toString();
        if (ReconciliationBPELReader.isEmptyOrWhitespace(data)) {
            return null;
        }
        return data;
    }

    public static Variable getVariable(EObject eObject, String variableName) {
        return VARIABLE_RESOLVER.getVariable(eObject, variableName);
    }

    public static Link getLink(Activity activity, String linkName) {
        return LINK_RESOLVER.getLink(activity, linkName);
    }

    private void syncLists(Element ifElement, List<Element> childElements, EList childrenList, Creator creator) {
        WSDLElement[] children = (WSDLElement[])childrenList.toArray((Object[])new WSDLElement[childrenList.size()]);
        int insertionIndex = 0;
        int i = 0;
        int j = 0;
        while (i < children.length && j < childElements.size()) {
            WSDLElement elseIf = children[i];
            if (elseIf.getElement() == null || elseIf.getElement().getParentNode() != ifElement) {
                childrenList.remove(insertionIndex);
            } else {
                Element element = childElements.get(j);
                while (elseIf.getElement() != element && j < childElements.size()) {
                    childrenList.add(insertionIndex, (Object)creator.create(element));
                    ++insertionIndex;
                    element = childElements.get(++j);
                }
                if (elseIf.getElement() == element) {
                    ++j;
                    ++insertionIndex;
                }
            }
            ++i;
        }
        int k = i;
        while (k < children.length) {
            WSDLElement elseIf = children[k];
            if (elseIf.getElement() == null || elseIf.getElement().getParentNode() != ifElement) {
                childrenList.remove((Object)elseIf);
            }
            ++k;
        }
        k = j;
        while (k < childElements.size()) {
            childrenList.add((Object)creator.create(childElements.get(k)));
            ++k;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void syncSequences(Element sequenceElement, EList<Activity> activitiesList) {
        block12: {
            block11: {
                sequenceElements = sequenceElement.getChildNodes();
                activityElement = null;
                activities = new Activity[activitiesList.size()];
                activitiesList.toArray(activities);
                if (sequenceElements == null) break block11;
                i = 0;
                j = 0;
                insertionIndex = 0;
                ** GOTO lbl31
                {
                    ++i;
                    do {
                        if (sequenceElements.item(i) != null && (sequenceElements.item(i).getNodeType() != 1 || ((Element)sequenceElements.item(i)).getLocalName().equals("links"))) continue block0;
                        activityElement = (Element)sequenceElements.item(i);
                        activity = activities[j];
                        if (activity.getElement() == null || activity.getElement().getParentNode() != sequenceElement) {
                            activitiesList.remove(insertionIndex);
                        } else {
                            node /* !! */  = activityElement;
                            while (node /* !! */  != activity.getElement() && i < sequenceElements.getLength()) {
                                if (node /* !! */ .getNodeType() == 1 && !node /* !! */ .getLocalName().equals("links") && (newActivity = this.xml2Activity(null, activityElement = (Element)sequenceElements.item(i))) != null) {
                                    activitiesList.add(insertionIndex, (Object)newActivity);
                                    ++insertionIndex;
                                }
                                node /* !! */  = sequenceElements.item(++i);
                            }
                            if (node /* !! */  == activity.getElement()) {
                                ++insertionIndex;
                                ++i;
                            }
                        }
                        ++j;
lbl31:
                        // 2 sources

                    } while (i < sequenceElements.getLength() && j < activities.length);
                }
                k = j;
                while (k < activities.length) {
                    activity = activities[k];
                    if (activity.getElement() == null || activity.getElement().getParentNode() != sequenceElement) {
                        activitiesList.remove(activity);
                    }
                    ++k;
                }
                k = i;
                while (k < sequenceElements.getLength()) {
                    if ((sequenceElements.item(k) == null || sequenceElements.item(k).getNodeType() == 1 && !((Element)sequenceElements.item(k)).getLocalName().equals("links")) && (newActivity = this.xml2Activity(null, activityElement = (Element)sequenceElements.item(k))) != null) {
                        activitiesList.add((Object)newActivity);
                    }
                    ++k;
                }
                break block12;
            }
            activitiesList.clear();
        }
    }

    private void createLink(Target target, String linkName) {
        Link link = ReconciliationBPELReader.getLink(target.getActivity(), linkName);
        if (link != null) {
            target.setLink(link);
        } else {
            target.setLink(new LinkProxy(this.getResource().getURI(), linkName));
        }
    }

    private void createLink(Source source, String linkName) {
        Link link = ReconciliationBPELReader.getLink(source.getActivity(), linkName);
        if (link != null) {
            source.setLink(link);
        } else {
            source.setLink(new LinkProxy(this.getResource().getURI(), linkName));
        }
    }

    @Override
    public void error(SAXParseException exception) {
        String message = MessageFormat.format("Error in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        BPELPlugin.logMessage(message, exception, 4);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        String message = MessageFormat.format("Fatal Error in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        BPELPlugin.logMessage(message, exception, 4);
    }

    @Override
    public void warning(SAXParseException exception) {
        String message = MessageFormat.format("Warning in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        BPELPlugin.logMessage(message, exception, 2);
    }

    private static interface Creator {
        public WSDLElement create(Element var1);
    }
}

