/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.docker.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.ICommandLauncherFactory;
import org.eclipse.cdt.core.ICommandLauncherFactory2;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.docker.launcher.ContainerCommandLauncher;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.osgi.framework.Bundle;

public class ContainerCommandLauncherFactory
implements ICommandLauncherFactory,
ICommandLauncherFactory2 {
    private IProject project;

    public ICommandLauncher getCommandLauncher(IProject project) {
        boolean enableContainer;
        String enablementProperty;
        this.project = project;
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project, false).getActiveConfiguration();
        IConfiguration cfg = null;
        try {
            CConfigurationData data;
            if (cfgd instanceof CConfigurationDescriptionCache && (data = ((CConfigurationDescriptionCache)cfgd).getConfigurationData()) instanceof BuildConfigurationData) {
                cfg = ((BuildConfigurationData)data).getConfiguration();
            }
            if (cfg == null) {
                cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
            }
        }
        catch (Exception data) {
            // empty catch block
        }
        if (cfg == null) {
            return null;
        }
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            return new ContainerCommandLauncher();
        }
        return null;
    }

    public ICommandLauncher getCommandLauncher(ICConfigurationDescription cfgd) {
        boolean enableContainer;
        String enablementProperty;
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        if (cfg == null) {
            return null;
        }
        this.project = (IProject)cfg.getManagedProject().getOwner();
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            return new ContainerCommandLauncher();
        }
        return null;
    }

    public ICommandLauncher getCommandLauncher(ICBuildConfiguration cfgd) {
        try {
            this.project = cfgd.getBuildConfiguration().getProject();
        }
        catch (CoreException e1) {
            return null;
        }
        try {
            IToolChain toolchain = cfgd.getToolChain();
            if (toolchain != null && "linux-container".equals(toolchain.getProperty("os"))) {
                return new ContainerCommandLauncher();
            }
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void registerLanguageSettingEntries(IProject project, List<? extends ICLanguageSettingEntry> langEntries) {
        entries = langEntries;
        cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
        cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            connectionName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
            imageName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
            if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
                DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
                return;
            }
            launcher = new ContainerLauncher();
            paths = new ArrayList<String>();
            for (ICLanguageSettingEntry entry : entries) {
                if (!(entry instanceof ICIncludePathEntry)) continue;
                paths.add(entry.getValue());
            }
            if (paths.size() > 0) {
                pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher")).append("HEADERS");
                pluginPath.toFile().mkdir();
                pluginPath = pluginPath.append(this.getCleanName(connectionName));
                pluginPath.toFile().mkdir();
                connectionNamePath = pluginPath.append(".name");
                f = connectionNamePath.toFile();
                try {
                    f.createNewFile();
                    try {
                        var16_16 = null;
                        var17_20 = null;
                        try {
                            writer = new FileWriter(f);
                            try {
                                bufferedWriter = new BufferedWriter(writer);
                                try {
                                    bufferedWriter.write(connectionName);
                                    bufferedWriter.newLine();
                                }
                                finally {
                                    if (bufferedWriter != null) {
                                        bufferedWriter.close();
                                    }
                                }
                                ** if (writer == null) goto lbl-1000
                            }
                            catch (Throwable var17_21) {
                                if (var16_16 == null) {
                                    var16_16 = var17_21;
                                } else if (var16_16 != var17_21) {
                                    var16_16.addSuppressed(var17_21);
                                }
                                if (writer != null) {
                                    writer.close();
                                }
                                throw var16_16;
                            }
lbl-1000:
                            // 1 sources

                            {
                                writer.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var17_22) {
                            if (var16_16 == null) {
                                var16_16 = var17_22;
                            } else if (var16_16 != var17_22) {
                                var16_16.addSuppressed(var17_22);
                            }
                            throw var16_16;
                        }
                    }
                    catch (IOException e) {
                        DockerLaunchUIPlugin.log(e);
                        return;
                    }
                    pluginPath = pluginPath.append(this.getCleanName(imageName));
                    pluginPath.toFile().mkdir();
                    imageNamePath = pluginPath.append(".name");
                    f = imageNamePath.toFile();
                    f.createNewFile();
                    try {
                        var17_20 = null;
                        var18_25 = null;
                        try {
                            writer = new FileWriter(f);
                            try {
                                bufferedWriter = new BufferedWriter(writer);
                                try {
                                    bufferedWriter.write(imageName);
                                    bufferedWriter.newLine();
                                }
                                finally {
                                    if (bufferedWriter != null) {
                                        bufferedWriter.close();
                                    }
                                }
                                ** if (writer == null) goto lbl-1000
                            }
                            catch (Throwable var18_26) {
                                if (var17_20 == null) {
                                    var17_20 = var18_26;
                                } else if (var17_20 != var18_26) {
                                    var17_20.addSuppressed(var18_26);
                                }
                                if (writer != null) {
                                    writer.close();
                                }
                                throw var17_20;
                            }
lbl-1000:
                            // 1 sources

                            {
                                writer.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable var18_27) {
                            if (var17_20 == null) {
                                var17_20 = var18_27;
                            } else if (var17_20 != var18_27) {
                                var17_20.addSuppressed(var18_27);
                            }
                            throw var17_20;
                        }
                    }
                    catch (IOException e) {
                        DockerLaunchUIPlugin.log(e);
                        return;
                    }
                }
                catch (IOException e) {
                    DockerLaunchUIPlugin.log(e);
                    return;
                }
                hostDir = pluginPath;
                excludeList = new ArrayList<String>();
                excludeList.add(project.getLocation().toString());
                var18_28 = launcher.fetchContainerDirs(connectionName, imageName, paths, excludeList, hostDir);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> verifyIncludePaths(ICBuildConfiguration cfgd, List<String> includePaths) {
        IToolChain toolchain = null;
        boolean isContainerEnabled = false;
        try {
            toolchain = cfgd.getToolChain();
            if (toolchain != null && "linux-container".equals(toolchain.getProperty("os"))) {
                isContainerEnabled = true;
            }
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
        if (!isContainerEnabled) return includePaths;
        String connectionName = toolchain.getProperty("connection_uri");
        String imageName = toolchain.getProperty("image_id");
        if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
            DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
            return includePaths;
        }
        if (includePaths.size() > 0) {
            IPath pluginPath;
            ContainerLauncher launcher;
            block41: {
                launcher = new ContainerLauncher();
                pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher")).append("HEADERS");
                pluginPath.toFile().mkdir();
                pluginPath = pluginPath.append(this.getCleanName(connectionName));
                pluginPath.toFile().mkdir();
                IPath connectionNamePath = pluginPath.append(".name");
                File f = connectionNamePath.toFile();
                try {
                    FileWriter writer3;
                    Throwable throwable;
                    block39: {
                        f.createNewFile();
                        try {
                            Throwable throwable2 = null;
                            throwable = null;
                            try {
                                writer3 = new FileWriter(f);
                                try {
                                    try (BufferedWriter bufferedWriter = new BufferedWriter(writer3);){
                                        bufferedWriter.write(connectionName);
                                        bufferedWriter.newLine();
                                    }
                                    if (writer3 == null) break block39;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    if (writer3 == null) throw throwable2;
                                    writer3.close();
                                    throw throwable2;
                                }
                                writer3.close();
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                                throw throwable2;
                            }
                        }
                        catch (IOException e) {
                            DockerLaunchUIPlugin.log(e);
                            return includePaths;
                        }
                    }
                    pluginPath = pluginPath.append(this.getCleanName(imageName));
                    pluginPath.toFile().mkdir();
                    IPath imageNamePath = pluginPath.append(".name");
                    f = imageNamePath.toFile();
                    f.createNewFile();
                    try {
                        throwable = null;
                        writer3 = null;
                        try {
                            FileWriter writer2 = new FileWriter(f);
                            try {
                                try (BufferedWriter bufferedWriter = new BufferedWriter(writer2);){
                                    bufferedWriter.write(imageName);
                                    bufferedWriter.newLine();
                                }
                                if (writer2 == null) break block41;
                            }
                            catch (Throwable writer3) {
                                if (throwable == null) {
                                    throwable = writer3;
                                } else if (throwable != writer3) {
                                    throwable.addSuppressed(writer3);
                                }
                                if (writer2 == null) throw throwable;
                                writer2.close();
                                throw throwable;
                            }
                            writer2.close();
                        }
                        catch (Throwable writer3) {
                            if (throwable == null) {
                                throwable = writer3;
                                throw throwable;
                            }
                            if (throwable == writer3) throw throwable;
                            throwable.addSuppressed(writer3);
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        DockerLaunchUIPlugin.log(e);
                        return includePaths;
                    }
                }
                catch (IOException e) {
                    DockerLaunchUIPlugin.log(e);
                    return includePaths;
                }
            }
            IPath hostDir = pluginPath;
            ArrayList<String> excludeList = new ArrayList<String>();
            excludeList.add(this.project.getLocation().toString());
            int status = launcher.fetchContainerDirsSync(connectionName, imageName, includePaths, excludeList, hostDir);
            if (status != 0) return includePaths;
            Set copiedVolumes = launcher.getCopiedVolumes(connectionName, imageName);
            ArrayList<String> newEntries = new ArrayList<String>();
            Iterator<String> iterator = includePaths.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return newEntries;
                }
                String path = iterator.next();
                if (copiedVolumes.contains(path)) {
                    IPath newPath = hostDir.append(path);
                    String newEntry = newPath.toOSString();
                    newEntries.add(newEntry);
                    continue;
                }
                newEntries.add(path);
            }
        }
        IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher")).append("HEADERS").append(this.getCleanName(connectionName)).append(this.getCleanName(imageName));
        toolchain.setProperty("cdt.needScannerRefresh", pluginPath.toFile().exists() ? "false" : "true");
        return includePaths;
    }

    public List<ICLanguageSettingEntry> verifyLanguageSettingEntries(IProject project, List<ICLanguageSettingEntry> entries) {
        boolean enableContainer;
        String enablementProperty;
        if (entries == null) {
            return null;
        }
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            String connectionName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
            String imageName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
            if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
                DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
                return entries;
            }
            ContainerLauncher launcher = new ContainerLauncher();
            Set copiedVolumes = launcher.getCopiedVolumes(connectionName, imageName);
            ArrayList<ICLanguageSettingEntry> newEntries = new ArrayList<ICLanguageSettingEntry>();
            IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher"));
            IPath hostDir = pluginPath.append("HEADERS").append(this.getCleanName(connectionName)).append(this.getCleanName(imageName));
            for (ICLanguageSettingEntry entry : entries) {
                if (entry instanceof ICIncludePathEntry) {
                    if (copiedVolumes.contains(((ICIncludePathEntry)entry).getName().toString())) {
                        IPath newPath = hostDir.append(entry.getName());
                        CIncludePathEntry newEntry = new CIncludePathEntry(newPath.toString(), entry.getFlags());
                        newEntries.add((ICLanguageSettingEntry)newEntry);
                        continue;
                    }
                    newEntries.add(entry);
                    continue;
                }
                newEntries.add(entry);
            }
            return newEntries;
        }
        return entries;
    }

    private String getCleanName(String name) {
        String cleanName = name.replace("unix:///", "unix_");
        cleanName = cleanName.replace("tcp://", "tcp_");
        return cleanName.replaceAll("[:/.]", "_");
    }
}

