/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service.command;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.gdb.internal.GdbDebugOptions;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.command.CustomTimeoutsMap;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class GdbCommandTimeoutManager
implements ICommandListener,
IEclipsePreferences.IPreferenceChangeListener {
    @Deprecated
    public static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.gdb/debug/timeouts"));
    private static final String TIMEOUT_TRACE_IDENTIFIER = "[TMO]";
    private ICommandControl fCommandControl;
    private boolean fTimeoutEnabled = false;
    private int fTimeout = 0;
    private TimerThread fTimerThread;
    private BlockingQueue<QueueEntry> fCommandQueue = new LinkedBlockingQueue<QueueEntry>();
    private CustomTimeoutsMap fCustomTimeouts = new CustomTimeoutsMap();
    private ListenerList<ICommandTimeoutListener> fListeners;

    public GdbCommandTimeoutManager(ICommandControl commandControl) {
        this.fCommandControl = commandControl;
        this.fListeners = new ListenerList();
    }

    public void initialize() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.dsf.gdb");
        this.fTimeoutEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb.commandTimeout", false, null);
        this.fTimeout = Platform.getPreferencesService().getInt("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb.commandTimeoutValue", 10000, null);
        this.fCustomTimeouts.initializeFromMemento(Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb.commandCustomTimeouts", "", null));
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.fCommandControl.addCommandListener((ICommandListener)this);
        this.fTimerThread = new TimerThread(this.fCommandQueue, this.calculateWaitTimeout());
        this.fTimerThread.start();
    }

    public void dispose() {
        this.fTimerThread.shutdown();
        this.fListeners.clear();
        InstanceScope.INSTANCE.getNode("org.eclipse.cdt.dsf.gdb").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.fCommandControl.removeCommandListener((ICommandListener)this);
        this.fCommandQueue.clear();
        this.fCustomTimeouts.clear();
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
        if (!this.isTimeoutEnabled()) {
            return;
        }
        int commandTimeout = this.getTimeoutForCommand((ICommand<? extends ICommandResult>)token.getCommand());
        if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
            String commandText = token.getCommand().toString();
            if (commandText.endsWith("\n")) {
                commandText = commandText.substring(0, commandText.length() - 1);
            }
            this.printDebugMessage(String.format("Command '%s' sent, timeout = %d", commandText, commandTimeout));
        }
        if (commandTimeout == 0) {
            return;
        }
        try {
            this.fCommandQueue.put(new QueueEntry(System.currentTimeMillis(), token));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        QueueEntry nextEntry;
        if (!this.isTimeoutEnabled()) {
            return;
        }
        this.fCommandQueue.remove(new QueueEntry(0L, token));
        if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
            String commandText = token.getCommand().toString();
            if (commandText.endsWith("\n")) {
                commandText = commandText.substring(0, commandText.length() - 1);
            }
            this.printDebugMessage(String.format("Command '%s' is done", commandText));
        }
        if ((nextEntry = (QueueEntry)this.fCommandQueue.peek()) != null) {
            this.setTimeStamp(System.currentTimeMillis(), nextEntry);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String property = event.getKey();
        if ("org.eclipse.cdt.dsf.gdb.commandTimeout".equals(property)) {
            if (event.getNewValue() == null || !event.getNewValue().equals(event.getOldValue())) {
                this.fTimeoutEnabled = event.getNewValue() != null ? Boolean.parseBoolean(event.getNewValue().toString()) : Boolean.FALSE;
                this.updateWaitTimeout();
                this.fTimerThread.setTimerThreadState(this.fTimerThread.getWaitTimeout() > 0 ? TimerThreadState.RUNNING : TimerThreadState.HALTED);
            }
        } else if ("org.eclipse.cdt.dsf.gdb.commandTimeoutValue".equals(property)) {
            if (event.getNewValue() == null || !event.getNewValue().equals(event.getOldValue())) {
                try {
                    this.fTimeout = event.getNewValue() != null ? Integer.parseInt(event.getNewValue().toString()) : 10000;
                    this.updateWaitTimeout();
                    this.fTimerThread.setTimerThreadState(this.fTimerThread.getWaitTimeout() > 0 ? TimerThreadState.RUNNING : TimerThreadState.HALTED);
                }
                catch (NumberFormatException e) {
                    GdbPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Invalid timeout value"));
                }
            }
        } else if ("org.eclipse.cdt.dsf.gdb.commandCustomTimeouts".equals(property)) {
            if (event.getNewValue() instanceof String) {
                this.fCustomTimeouts.initializeFromMemento((String)event.getNewValue());
            } else if (event.getNewValue() == null) {
                this.fCustomTimeouts.clear();
            }
            this.updateWaitTimeout();
            this.fTimerThread.setTimerThreadState(this.fTimerThread.getWaitTimeout() > 0 ? TimerThreadState.RUNNING : TimerThreadState.HALTED);
        }
    }

    protected int getTimeoutForCommand(ICommand<? extends ICommandResult> command) {
        if (!(command instanceof MICommand)) {
            return 0;
        }
        Integer timeout = (Integer)this.fCustomTimeouts.get(((MICommand)command).getOperation());
        return timeout != null ? timeout : this.fTimeout;
    }

    protected void processTimedOutCommand(ICommandToken token) {
        if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
            String commandText = token.getCommand().toString();
            if (commandText.endsWith("\n")) {
                commandText = commandText.substring(0, commandText.length() - 1);
            }
            this.printDebugMessage(String.format("Command '%s' is timed out", commandText));
        }
        for (ICommandTimeoutListener l : this.fListeners) {
            l.commandTimedOut(token);
        }
    }

    public void addCommandTimeoutListener(ICommandTimeoutListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeCommandTimeoutListener(ICommandTimeoutListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void updateWaitTimeout() {
        this.fTimerThread.setWaitTimout(this.calculateWaitTimeout());
    }

    private boolean isTimeoutEnabled() {
        return this.fTimeoutEnabled;
    }

    private void printDebugMessage(String message) {
        if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
            GdbDebugOptions.trace(String.format("%s %s  %s\n", GdbPlugin.getDebugTime(), TIMEOUT_TRACE_IDENTIFIER, message));
        }
    }

    private int calculateWaitTimeout() {
        int waitTimeout = 0;
        if (this.isTimeoutEnabled()) {
            waitTimeout = this.fTimeout;
            int minCustomTimeout = Integer.MAX_VALUE;
            for (Integer t : this.fCustomTimeouts.values()) {
                if (t <= 0) continue;
                minCustomTimeout = Math.min(minCustomTimeout, t);
            }
            if (minCustomTimeout > 0) {
                waitTimeout = waitTimeout == 0 ? minCustomTimeout : Math.min(waitTimeout, minCustomTimeout);
            }
        }
        return waitTimeout;
    }

    private void setTimeStamp(long currentTime, QueueEntry nextEntry) {
        if (nextEntry != null) {
            nextEntry.fTimestamp = currentTime;
            if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
                String commandText = nextEntry.fCommandToken.getCommand().toString();
                if (commandText.endsWith("\n")) {
                    commandText = commandText.substring(0, commandText.length() - 1);
                }
                this.printDebugMessage(String.format("Setting the timestamp for command '%s' to %d", commandText, currentTime));
            }
        }
    }

    public static interface ICommandTimeoutListener {
        public void commandTimedOut(ICommandToken var1);
    }

    private class QueueEntry {
        private long fTimestamp;
        private ICommandToken fCommandToken;

        private QueueEntry(long timestamp, ICommandToken commandToken) {
            this.fTimestamp = timestamp;
            this.fCommandToken = commandToken;
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueueEntry) {
                return this.fCommandToken.equals(((QueueEntry)obj).fCommandToken);
            }
            return false;
        }
    }

    private class TimerThread
    extends Thread {
        private BlockingQueue<QueueEntry> fQueue;
        private int fWaitTimeout = 10000;
        private TimerThreadState fState = TimerThreadState.INITIALIZING;

        TimerThread(BlockingQueue<QueueEntry> queue, int timeout) {
            this.setName("GDB Command Timer Thread");
            this.fQueue = queue;
            this.setWaitTimout(timeout);
        }

        @Override
        public void run() {
            this.setTimerThreadState(this.getWaitTimeout() > 0 ? TimerThreadState.RUNNING : TimerThreadState.HALTED);
            this.doRun();
        }

        private void doRun() {
            while (this.getTimerThreadState() != TimerThreadState.SHUTDOWN) {
                if (this.getTimerThreadState() == TimerThreadState.HALTED) {
                    this.halted();
                    continue;
                }
                this.running();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void halted() {
            this.fQueue.clear();
            try {
                TimerThread timerThread = this;
                synchronized (timerThread) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void running() {
            try {
                while (this.getTimerThreadState() == TimerThreadState.RUNNING) {
                    long timeout = this.getWaitTimeout();
                    QueueEntry entry = (QueueEntry)this.fQueue.peek();
                    if (entry != null) {
                        long currentTime;
                        long elapsedTime;
                        long commandTimeout = GdbCommandTimeoutManager.this.getTimeoutForCommand((ICommand<? extends ICommandResult>)entry.fCommandToken.getCommand());
                        if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
                            String commandText = entry.fCommandToken.getCommand().toString();
                            if (commandText.endsWith("\n")) {
                                commandText = commandText.substring(0, commandText.length() - 1);
                            }
                            GdbCommandTimeoutManager.this.printDebugMessage(String.format("Processing command '%s', command timeout is %d", commandText, commandTimeout));
                        }
                        if (commandTimeout <= (elapsedTime = (currentTime = System.currentTimeMillis()) - entry.fTimestamp)) {
                            GdbCommandTimeoutManager.this.processTimedOutCommand(entry.fCommandToken);
                            this.fQueue.remove(entry);
                            QueueEntry nextEntry = (QueueEntry)this.fQueue.peek();
                            if (nextEntry != null) {
                                GdbCommandTimeoutManager.this.setTimeStamp(currentTime, nextEntry);
                            }
                        } else {
                            timeout = Math.min(timeout, commandTimeout - elapsedTime);
                            if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
                                String commandText = entry.fCommandToken.getCommand().toString();
                                if (commandText.endsWith("\n")) {
                                    commandText = commandText.substring(0, commandText.length() - 1);
                                }
                                GdbCommandTimeoutManager.this.printDebugMessage(String.format("Setting timeout %d for command '%s'", timeout, commandText));
                            }
                        }
                    }
                    TimerThread timerThread = this;
                    synchronized (timerThread) {
                        this.wait(timeout);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void shutdown() {
            this.setTimerThreadState(TimerThreadState.SHUTDOWN);
        }

        private synchronized void setWaitTimout(int waitTimeout) {
            this.fWaitTimeout = waitTimeout;
            if (GdbDebugOptions.DEBUG_COMMAND_TIMEOUTS) {
                GdbCommandTimeoutManager.this.printDebugMessage(String.format("Wait timeout is set to %d", this.fWaitTimeout));
            }
        }

        private synchronized int getWaitTimeout() {
            return this.fWaitTimeout;
        }

        private synchronized void setTimerThreadState(TimerThreadState state) {
            this.fState = state;
            this.interrupt();
        }

        private synchronized TimerThreadState getTimerThreadState() {
            return this.fState;
        }
    }

    private static enum TimerThreadState {
        INITIALIZING,
        RUNNING,
        HALTED,
        SHUTDOWN;

    }
}

