/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.pref.OMPreferencesChangeEvent;
import org.eclipse.swt.graphics.Image;

public class CDOLabelDecorator
implements ILabelDecorator {
    public static final String[] DECORATION_PROPOSALS = new String[]{"${element}", "${id}", "${state}", "${created}", "${revised}"};
    public static final String DEFAULT_DECORATION = String.valueOf(DECORATION_PROPOSALS[0]) + "  " + DECORATION_PROPOSALS[2];
    public static final String NO_DECORATION = DECORATION_PROPOSALS[0];
    private static final String[] DECORATION_ARGS = new String[]{"{0}", "{1}", "{2}", "{3,date} {3,time,HH:mm:ss:SSS}", "{4,date} {4,time,HH:mm:ss:SSS}"};
    public static final String DECORATOR_ID = "org.eclipse.emf.cdo.ui.CDOLabelDecorator";
    private static final Image LOCK_OVERLAY = SharedIcons.getImage((String)"ovr16/lock.gif");
    private static final Image LOCK_SELF_OVERLAY = SharedIcons.getImage((String)"ovr16/lock_self.gif");
    private String pattern;
    private IListener preferenceListener = new IListener(){

        public void notifyEvent(IEvent event) {
            OMPreferencesChangeEvent preferenceChangeEvent = (OMPreferencesChangeEvent)event;
            if (OM.PREF_LABEL_DECORATION.getName().equals(preferenceChangeEvent.getPreference().getName())) {
                CDOLabelDecorator.this.pattern = CDOLabelDecorator.this.parsePattern((String)preferenceChangeEvent.getNewValue());
            }
        }
    };

    public CDOLabelDecorator() {
        this.pattern = this.parsePattern((String)OM.PREF_LABEL_DECORATION.getValue());
        OM.PREFS.addListener(this.preferenceListener);
    }

    public CDOLabelDecorator(String pattern) {
        this.pattern = pattern;
    }

    public void dispose() {
        OM.PREFS.removeListener(this.preferenceListener);
    }

    public String parsePattern(String unparsedPattern) {
        if (ObjectUtil.equals((Object)unparsedPattern, (Object)NO_DECORATION)) {
            return null;
        }
        return StringUtil.replace((String)unparsedPattern, (String[])DECORATION_PROPOSALS, (String[])DECORATION_ARGS);
    }

    public Image decorateImage(Image image, Object element) {
        try {
            image = CDOLabelDecorator.decorate(image, element);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        try {
            if (this.pattern != null) {
                EObject eObject;
                InternalCDOObject cdoObject;
                CDOElement cdoElement = (CDOElement)AdapterUtil.adapt((Object)element, CDOElement.class);
                if (cdoElement != null) {
                    element = cdoElement.getDelegate();
                }
                if (element instanceof EObject && (cdoObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)(eObject = (EObject)element), (boolean)false)) != null) {
                    CDOID id = cdoObject.cdoID();
                    String state = this.getObjectState(cdoObject);
                    InternalCDORevision rev = cdoObject.cdoRevision();
                    long created = rev == null ? 0L : rev.getTimeStamp();
                    long revised = rev == null ? 0L : rev.getRevised();
                    text = MessageFormat.format(this.pattern, text, id, state, created, revised).trim();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected String getObjectState(InternalCDOObject object) {
        CDOState state = null;
        CDOElement.StateProvider stateProvider = (CDOElement.StateProvider)AdapterUtil.adapt((Object)object, CDOElement.StateProvider.class);
        state = stateProvider != null ? stateProvider.getState((Object)object) : object.cdoState();
        if (state == null) {
            return "";
        }
        return state.toString().toLowerCase();
    }

    public static Image decorate(Image image, Object element) {
        CDOLockOwner owner;
        CDOLockState lockState;
        EObject eObject;
        CDOObject cdoObject;
        if (element instanceof EObject && (cdoObject = CDOUtil.getCDOObject((EObject)(eObject = (EObject)element), (boolean)false)) != null && (lockState = cdoObject.cdoLockState()) != null && (owner = lockState.getWriteLockOwner()) != null) {
            image = owner.equals(cdoObject.cdoView()) ? OM.getOverlayImage(image, LOCK_SELF_OVERLAY, 10, 0) : OM.getOverlayImage(image, LOCK_OVERLAY, 10, 0);
        }
        return image;
    }
}

