/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.util;

import com.google.common.base.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.NoStackTrace;
import org.eclipse.jdt.annotation.Nullable;

public class LogListener
implements ILogListener {
    public static final String TOPIC_NEW_STATUS_LOGGED = "org/eclipse/epp/internal/logging/aeri/ui/status/new";
    public static final String CTX_STATUS_FILTER = "org.eclipse.epp.logging.aeri.core.statusFilters";
    private Predicate<IStatus> statusFilters;
    private IEventBroker broker;

    @Inject
    public LogListener(@Named(value="org.eclipse.epp.logging.aeri.core.statusFilters") Predicate<IStatus> statusFilters, IEventBroker broker) {
        this.statusFilters = statusFilters;
        this.broker = broker;
    }

    public void logging(@Nullable IStatus status, @Nullable String plugin) {
        if (status == null) {
            return;
        }
        if (!SystemControl.isActive()) {
            return;
        }
        if (!this.statusFilters.apply((Object)status)) {
            return;
        }
        if (status.getException() == null) {
            Throwable missing = new NoStackTrace().fillInStackTrace();
            status = this.copy(status, missing);
        }
        this.notifyNewStatus(status);
    }

    private IStatus copy(IStatus status, Throwable missing) {
        status = status.isMultiStatus() ? new MultiStatus(status.getPlugin(), status.getCode(), status.getChildren(), status.getMessage(), missing) : new Status(status.getSeverity(), status.getPlugin(), status.getMessage(), missing);
        return status;
    }

    protected void notifyNewStatus(IStatus status) {
        this.broker.post(TOPIC_NEW_STATUS_LOGGED, (Object)status);
    }
}

