/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.eclipse.help.internal.extension.ContentExtension;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class ExtensionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map<String, String> responseByLocale;
    private DocumentWriter writer;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/xml; charset=UTF-8");
        resp.getWriter().write(this.processRequest(req, resp));
    }

    protected String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String response;
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        if (this.responseByLocale == null) {
            this.responseByLocale = new WeakHashMap<String, String>();
        }
        if ((response = this.responseByLocale.get(locale)) == null) {
            ContentExtension[] extensions = HelpPlugin.getContentExtensionManager().getExtensions(locale);
            try {
                response = this.serialize(extensions);
            }
            catch (TransformerException e) {
                throw new ServletException((Throwable)e);
            }
            this.responseByLocale.put(locale, response);
        }
        return response;
    }

    private String serialize(ContentExtension[] extensions) throws TransformerException {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<contentExtensions>\n");
        ContentExtension[] contentExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ContentExtension extension = contentExtensionArray[n2];
            if (this.writer == null) {
                this.writer = new DocumentWriter();
            }
            buf.append(this.writer.writeString((UAElement)extension, false));
            ++n2;
        }
        buf.append("</contentExtensions>\n");
        return buf.toString();
    }
}

