/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.ui.handlers;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.api.ui.utils.OMExport;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.utils.ObjectMappingUtil;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyIdentifierToClipboardHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(CopyIdentifierToClipboardHandler.class);

    public Object executeImpl(ExecutionEvent event) {
        Object selectedElement;
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IObjectMappingAssoziationPO) {
            IObjectMappingAssoziationPO assoziation = (IObjectMappingAssoziationPO)selectedElement;
            IComponentIdentifier compIdentifier = ObjectMappingUtil.createCompIdentifierFromAssoziation((IObjectMappingAssoziationPO)assoziation);
            try {
                TextTransfer textTransfer = TextTransfer.getInstance();
                String serialization = OMExport.getSerialization((ComponentIdentifier)compIdentifier);
                Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                Display display = activeShell.getDisplay();
                if (display != null) {
                    new Clipboard(display).setContents((Object[])new String[]{serialization}, new Transfer[]{textTransfer});
                }
            }
            catch (IOException e) {
                log.error("Error while copying component identifier to clipboard", (Throwable)e);
            }
        }
        return null;
    }
}

