/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

public class ImportExportUtil {
    public static final int UUID_LENGTH = 32;
    public static final int PAGE_SIZE = 1000;
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");

    private ImportExportUtil() {
    }

    public static void switchCompNamesGuids(IProjectPO proj, Map<String, String> oldToNewGUID) {
        class SwitchCompNamesGuidsOp
        extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
            private final /* synthetic */ Map val$oldToNewGUID;

            SwitchCompNamesGuidsOp(Map map) {
                this.val$oldToNewGUID = map;
            }

            public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                if (node instanceof ICapPO) {
                    this.switchCapCompNameGuids((ICapPO)node);
                } else if (node instanceof IExecTestCasePO) {
                    this.switchExecTcCompNameGuids((IExecTestCasePO)node);
                }
                return true;
            }

            private void switchExecTcCompNameGuids(IExecTestCasePO execTc) {
                for (ICompNamesPairPO pair : new ArrayList(execTc.getCompNamesPairs())) {
                    String oldSecGuid;
                    String newSecGuid;
                    String oldGuid = pair.getFirstName();
                    String newGuid = (String)this.val$oldToNewGUID.get(oldGuid);
                    if (newGuid != null) {
                        pair.setFirstName(newGuid);
                        execTc.removeCompNamesPair(oldGuid);
                        execTc.addCompNamesPair(pair);
                    }
                    if ((newSecGuid = (String)this.val$oldToNewGUID.get(oldSecGuid = pair.getSecondName())) == null) continue;
                    pair.setSecondName(newSecGuid);
                }
            }

            private void switchCapCompNameGuids(ICapPO cap) {
                String oldGuid = cap.getComponentName();
                String newGuid = (String)this.val$oldToNewGUID.get(oldGuid);
                if (newGuid != null) {
                    cap.setComponentName(newGuid);
                }
            }
        }
        SwitchCompNamesGuidsOp switchGuidOp = new SwitchCompNamesGuidsOp(oldToNewGUID);
        TreeTraverser ttv = new TreeTraverser((INodePO)proj, (ITreeNodeOperation)switchGuidOp, true);
        ttv.traverse(true);
        ttv = new TreeTraverser((INodePO)proj, (ITreeNodeOperation)switchGuidOp, false);
        ttv.traverse(true);
        for (IAUTMainPO autMain : proj.getAutMainList()) {
            IObjectMappingPO objMap = autMain.getObjMap();
            for (IObjectMappingAssoziationPO oma : objMap.getMappings()) {
                ArrayList<String> namesToUpdate = new ArrayList<String>();
                for (String oldLogicName : oma.getLogicalNames()) {
                    if (!oldToNewGUID.containsKey(oldLogicName)) continue;
                    namesToUpdate.add(oldLogicName);
                }
                for (String oldLogicName : namesToUpdate) {
                    oma.removeLogicalName(oldLogicName);
                    oma.addLogicalName(oldToNewGUID.get(oldLogicName));
                }
            }
        }
    }

    public static ISpecTestCasePO findReferencedTCByGuid(String usedTestcaseGuid, String projectGuid, IProjectPO parentProject, boolean assignNewGuid, Map<String, String> oldToNewGuids, Map<String, ISpecTestCasePO> tcRef) {
        String actualProjectGuid;
        String string = actualProjectGuid = assignNewGuid ? oldToNewGuids.get(projectGuid) : projectGuid;
        if (projectGuid == null || parentProject.getGuid().equals(actualProjectGuid)) {
            if (assignNewGuid) {
                return tcRef.get(oldToNewGuids.get(usedTestcaseGuid));
            }
            return tcRef.get(usedTestcaseGuid);
        }
        return NodePM.getSpecTestCase((Set)parentProject.getUsedProjects(), (String)projectGuid, (String)usedTestcaseGuid);
    }

    public static String i2str(Long l) {
        if (l != null) {
            return l.toString();
        }
        return "";
    }

    public static void checkCancel(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

