/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.inspector.ui.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.inspector.ui.commands.ActivateInspectorResponseCommand;
import org.eclipse.jubula.client.inspector.ui.i18n.Messages;
import org.eclipse.jubula.client.inspector.ui.provider.sourceprovider.InspectableAutSourceProvider;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.ActivateInspectorMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;

public class ActivateInspectorHandler
extends AbstractHandler {
    public static final String AUT_ID = "org.eclipse.jubula.client.inspector.ui.commands.parameter.activateInspector.autId";
    private static AutIdentifier lastAut = null;

    public Object execute(final ExecutionEvent event) {
        final String jobName = Messages.UIJobActivateInspector;
        Job activateInspectorJob = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                AutIdentifier autId;
                block8: {
                    monitor.beginTask(jobName, -1);
                    autId = null;
                    try {
                        autId = (AutIdentifier)event.getObjectParameterForExecution(ActivateInspectorHandler.AUT_ID);
                        lastAut = autId;
                    }
                    catch (ExecutionException executionException) {
                        InspectableAutSourceProvider iasp = new InspectableAutSourceProvider();
                        Object inspectableAUTs = iasp.getCurrentState().get("org.eclipse.jubula.client.inspector.ui.variable.inspectableAuts");
                        if (inspectableAUTs == null || !(inspectableAUTs instanceof List)) break block8;
                        List auts = (List)inspectableAUTs;
                        if (auts.size() == 1) {
                            Object object = auts.get(0);
                            autId = object instanceof AutIdentifier ? (AutIdentifier)object : null;
                            lastAut = autId;
                        }
                        if (lastAut == null || !auts.contains(lastAut)) break block8;
                        autId = lastAut;
                    }
                }
                if (autId == null) {
                    return Status.CANCEL_STATUS;
                }
                ActivateInspectorMessage message = new ActivateInspectorMessage();
                try {
                    AUTConnection.getInstance().connectToAut(autId, (IProgressMonitor)new NullProgressMonitor());
                    AUTConnection.getInstance().request((Message)message, (ICommand)new ActivateInspectorResponseCommand(), 5000);
                }
                catch (BaseConnection.NotConnectedException notConnectedException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NO_AUT_CONNECTION_ERROR);
                }
                catch (ConnectionException ce) {
                    ErrorHandlingUtil.createMessageDialog((JBException)ce, null, null);
                }
                catch (CommunicationException ce) {
                    ErrorHandlingUtil.createMessageDialog((JBException)ce, null, null);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        activateInspectorJob.setSystem(true);
        JobUtils.executeJob((Job)activateInspectorJob, null);
        return null;
    }
}

