/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.edit;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.AssocOMtoSpecTCDialog;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class TCBEditOmAssocHandler
extends AbstractSelectionBasedHandler {
    protected Object executeImpl(ExecutionEvent event) throws ExecutionException {
        ISpecTestCasePO firstElement = (ISpecTestCasePO)this.getFirstElement(ISpecTestCasePO.class);
        if (firstElement != null) {
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            try {
                Persistor.instance().lockPO(masterSession, (IPersistentObject)firstElement);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
                return null;
            }
            AssocOMtoSpecTCDialog dialog = new AssocOMtoSpecTCDialog(this.getActiveShell(), firstElement);
            dialog.create();
            int result = dialog.open();
            if (result != 0) {
                LockManager.instance().unlockPO((IPersistentObject)firstElement);
                return null;
            }
            this.persistChanges(firstElement, dialog.getSelectedItems());
        }
        LockManager.instance().unlockPO((IPersistentObject)firstElement);
        return null;
    }

    private void persistChanges(ISpecTestCasePO firstElement, Collection<IObjectMappingCategoryPO> selectedItems) {
        try {
            LockManager.instance().unlockPO((IPersistentObject)firstElement);
            NodePM.setOMAssoc((ISpecTestCasePO)firstElement, selectedItems);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)firstElement, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForEditor(e, null);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
    }
}

