/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.we.editors.properties.tabbedPage.helpers;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.aspects.AspectManager;
import org.eclipse.jwt.we.editors.properties.CustomAdapterFactoryContentProvider;
import org.eclipse.jwt.we.editors.properties.ModelPropertySourceProvider;
import org.eclipse.jwt.we.editors.properties.singlePage.ModelPropertySheetPage;
import org.eclipse.jwt.we.editors.properties.tabbedPage.TabbedModelPropertySheetPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractSingleStaticAspectPropertySection
extends AbstractPropertySection {
    protected PropertySheetPage page;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        TabbedModelPropertySheetPage tabbedModelPropertySheetPage = (TabbedModelPropertySheetPage)tabbedPropertySheetPage;
        AdapterFactory tabbedModelPropertySheetPageAf = tabbedModelPropertySheetPage.getAdapterFactory();
        this.page = new ModelPropertySheetPage(tabbedModelPropertySheetPageAf);
        this.page.createControl(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.page.getControl().setLayoutData((Object)data);
        this.page.setPropertySourceProvider((IPropertySourceProvider)new ModelPropertySourceProvider((IPropertySourceProvider)new CustomAdapterFactoryContentProvider(tabbedModelPropertySheetPageAf)));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject modelElement;
        AspectInstance aspectInstance;
        Object selectedObject;
        StructuredSelection subselection = null;
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject && (aspectInstance = this.getAspectInstance(modelElement = (EObject)selectedObject)) != null) {
            subselection = new StructuredSelection((Object)aspectInstance);
        }
        if (subselection == null) {
            subselection = new StructuredSelection();
        }
        super.setInput(part, (ISelection)subselection);
        this.page.selectionChanged(part, (ISelection)subselection);
    }

    protected abstract Class getAspectInstanceClass();

    protected AspectInstance getAspectInstance(EObject modelElement) {
        List aspectInstances = AspectManager.INSTANCE.getAspectInstances(modelElement);
        Class aspectInstanceClass = this.getAspectInstanceClass();
        for (AspectInstance aspectInstance : aspectInstances) {
            if (!aspectInstanceClass.isInstance(aspectInstance)) continue;
            return aspectInstance;
        }
        return null;
    }

    public void refresh() {
        this.page.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }
}

