(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "dockerfile-utils", "./dockerAssist", "./dockerRegistryClient", "./dockerCommands", "./dockerFolding", "./dockerDefinition", "./dockerHighlight", "./dockerSymbols", "./dockerSignatures", "./dockerLinks", "./dockerPlainText", "./dockerRename", "./dockerHover", "./dockerMarkdown", "./dockerFormatter", "./dockerCompletion"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var DockerfileUtils = require("dockerfile-utils");
    var dockerAssist_1 = require("./dockerAssist");
    var dockerRegistryClient_1 = require("./dockerRegistryClient");
    var dockerCommands_1 = require("./dockerCommands");
    var dockerFolding_1 = require("./dockerFolding");
    var dockerDefinition_1 = require("./dockerDefinition");
    var dockerHighlight_1 = require("./dockerHighlight");
    var dockerSymbols_1 = require("./dockerSymbols");
    var dockerSignatures_1 = require("./dockerSignatures");
    var dockerLinks_1 = require("./dockerLinks");
    var dockerPlainText_1 = require("./dockerPlainText");
    var dockerRename_1 = require("./dockerRename");
    var dockerHover_1 = require("./dockerHover");
    var dockerMarkdown_1 = require("./dockerMarkdown");
    var dockerFormatter_1 = require("./dockerFormatter");
    var dockerCompletion_1 = require("./dockerCompletion");
    var LanguageService = /** @class */ (function () {
        function LanguageService() {
            this.markdownDocumentation = new dockerMarkdown_1.MarkdownDocumentation();
            this.plainTextDocumentation = new dockerPlainText_1.PlainTextDocumentation();
            this.snippetSupport = false;
            this.deprecatedSupport = false;
            this.foldingRangeLineFoldingOnly = false;
            this.foldingRangeLimit = Number.MAX_VALUE;
        }
        LanguageService.prototype.setLogger = function (logger) {
            this.logger = logger;
        };
        LanguageService.prototype.setCapabilities = function (capabilities) {
            this.completionDocumentationFormat = capabilities && capabilities.completion && capabilities.completion.completionItem && capabilities.completion.completionItem.documentationFormat;
            this.hoverContentFormat = capabilities && capabilities.hover && capabilities.hover.contentFormat;
            this.snippetSupport = capabilities && capabilities.completion && capabilities.completion.completionItem && capabilities.completion.completionItem.snippetSupport;
            this.deprecatedSupport = capabilities && capabilities.completion && capabilities.completion.completionItem && capabilities.completion.completionItem.deprecatedSupport;
            this.foldingRangeLineFoldingOnly = capabilities && capabilities.foldingRange && capabilities.foldingRange.lineFoldingOnly;
            this.foldingRangeLimit = capabilities && capabilities.foldingRange && capabilities.foldingRange.rangeLimit;
        };
        LanguageService.prototype.computeCodeActions = function (textDocument, range, context) {
            var dockerCommands = new dockerCommands_1.DockerCommands();
            return dockerCommands.analyzeDiagnostics(context.diagnostics, textDocument.uri);
        };
        LanguageService.prototype.computeLinks = function (content) {
            var dockerLinks = new dockerLinks_1.DockerLinks();
            return dockerLinks.getLinks(content);
        };
        LanguageService.prototype.resolveLink = function (link) {
            var dockerLinks = new dockerLinks_1.DockerLinks();
            return dockerLinks.resolveLink(link);
        };
        LanguageService.prototype.computeCommandEdits = function (content, command, args) {
            var dockerCommands = new dockerCommands_1.DockerCommands();
            return dockerCommands.computeCommandEdits(content, command, args);
        };
        LanguageService.prototype.computeCompletionItems = function (content, position) {
            var document = vscode_languageserver_types_1.TextDocument.create("", "", 0, content);
            var dockerAssist = new dockerAssist_1.DockerAssist(document, new dockerRegistryClient_1.DockerRegistryClient(this.logger), this.snippetSupport, this.deprecatedSupport);
            return dockerAssist.computeProposals(position);
        };
        LanguageService.prototype.resolveCompletionItem = function (item) {
            if (!item.documentation) {
                var dockerCompletion = new dockerCompletion_1.DockerCompletion();
                return dockerCompletion.resolveCompletionItem(item, this.completionDocumentationFormat);
            }
            return item;
        };
        LanguageService.prototype.computeDefinition = function (textDocument, content, position) {
            var dockerDefinition = new dockerDefinition_1.DockerDefinition();
            return dockerDefinition.computeDefinition(textDocument, content, position);
        };
        LanguageService.prototype.computeFoldingRanges = function (content) {
            var dockerFolding = new dockerFolding_1.DockerFolding();
            return dockerFolding.computeFoldingRanges(content, this.foldingRangeLineFoldingOnly, this.foldingRangeLimit);
        };
        LanguageService.prototype.computeHighlightRanges = function (content, position) {
            var dockerHighlight = new dockerHighlight_1.DockerHighlight();
            return dockerHighlight.computeHighlightRanges(content, position);
        };
        LanguageService.prototype.computeHover = function (content, position) {
            var dockerHover = new dockerHover_1.DockerHover(this.markdownDocumentation, this.plainTextDocumentation);
            return dockerHover.onHover(content, position, this.hoverContentFormat);
        };
        LanguageService.prototype.computeSymbols = function (textDocument, content) {
            var dockerSymbols = new dockerSymbols_1.DockerSymbols();
            return dockerSymbols.parseSymbolInformation(textDocument, content);
        };
        LanguageService.prototype.computeSignatureHelp = function (content, position) {
            var dockerSignature = new dockerSignatures_1.DockerSignatures();
            return dockerSignature.computeSignatures(content, position);
        };
        LanguageService.prototype.computeRename = function (textDocument, content, position, newName) {
            var dockerRename = new dockerRename_1.DockerRename();
            return dockerRename.rename(textDocument, content, position, newName);
        };
        LanguageService.prototype.prepareRename = function (content, position) {
            var dockerRename = new dockerRename_1.DockerRename();
            return dockerRename.prepareRename(content, position);
        };
        LanguageService.prototype.validate = function (content, settings) {
            return DockerfileUtils.validate(content, settings);
        };
        LanguageService.prototype.format = function (content, options) {
            return DockerfileUtils.format(content, options);
        };
        LanguageService.prototype.formatRange = function (content, range, options) {
            var dockerFormat = new dockerFormatter_1.DockerFormatter();
            return dockerFormat.formatRange(content, range, options);
        };
        LanguageService.prototype.formatOnType = function (content, position, ch, options) {
            var dockerFormat = new dockerFormatter_1.DockerFormatter();
            return dockerFormat.formatOnType(content, position, ch, options);
        };
        return LanguageService;
    }());
    exports.LanguageService = LanguageService;
});
