/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.jdt.docker.launcher;

import java.io.File;

public class UnixFile
extends File {
    public static final char separatorChar = '/';
    public static final String separator = "/";
    public static final char pathSeparatorChar = ':';
    public static final String pathSeparator = ":";
    private String path;

    public UnixFile(String pathname) {
        super(pathname);
        this.path = pathname;
    }

    public UnixFile(File parent, String child) {
        super(parent, child);
        String parentAbsPath = parent.getAbsolutePath();
        this.path = parentAbsPath.endsWith(separator) ? String.valueOf(parentAbsPath) + child : String.valueOf(parentAbsPath) + separator + child;
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }

    @Override
    public String getName() {
        int index = this.path.lastIndexOf(47);
        return this.path.substring(index + 1);
    }

    public static String convertDOSPathToUnixPath(String wPath) {
        String result = separator + wPath.replace(pathSeparator, "").replace('\\', '/');
        return result;
    }
}

