/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.ICollector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectorregistry.CategoryDescriptor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectorregistry.CollectorDescriptor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectorregistry.CollectorRegistry;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class QvtCompletionProcessor
implements IContentAssistProcessor {
    private static final char[] ACTIVATION = new char[]{'.', '>', '@'};
    private final int INITIAL_CATEGORY_INDEX = -1;
    private final int NO_CATEGORY_INDEX = -1;
    private final ContentAssistant myContentAssistant;
    private List<CategoryDescriptor> myCategories = Collections.emptyList();
    private int myCategoryIndex = -1;
    private final ITextEditor myEditor;
    private int myOffset = -1;

    public QvtCompletionProcessor(ITextEditor editor, ISourceViewer sourceViewer, ContentAssistant contentAssistant) {
        this.myEditor = editor;
        this.myContentAssistant = contentAssistant;
        this.myContentAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent event) {
                if (event.processor != QvtCompletionProcessor.this) {
                    return;
                }
                QvtCompletionProcessor.this.myCategoryIndex = -1;
                if (event.assistant instanceof ContentAssistant) {
                    ContentAssistant contentAssistant = (ContentAssistant)event.assistant;
                    contentAssistant.setRepeatedInvocationMode(true);
                    contentAssistant.setStatusLineVisible(true);
                    KeySequence binding = this.getIterationBinding();
                    contentAssistant.setRepeatedInvocationTrigger(binding);
                    contentAssistant.setShowEmptyList(true);
                }
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                QvtCompletionProcessor.this.myOffset = -1;
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            private KeySequence getIterationBinding() {
                IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
                TriggerSequence binding = bindingSvc.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
                if (binding instanceof KeySequence) {
                    return (KeySequence)binding;
                }
                return null;
            }
        });
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            UnitProxy unitProxy = (UnitProxy)this.myEditor.getAdapter(UnitProxy.class);
            if (unitProxy == null) {
                return null;
            }
            QvtCompletionData data = new QvtCompletionData(this.myEditor, viewer, unitProxy, offset);
            if (!data.isValid()) {
                ICompletionProposal[] iCompletionProposalArray = this.disableNextCodeCompletionPage();
                return iCompletionProposalArray;
            }
            if (this.myCategoryIndex == -1 || this.myOffset == offset) {
                int categoryIndex = this.updateCategoryIndex(data);
                if (categoryIndex == -1) {
                    ICompletionProposal[] iCompletionProposalArray = this.disableNextCodeCompletionPage();
                    return iCompletionProposalArray;
                }
                CategoryDescriptor nextCategory = this.getNextCategory();
                if (nextCategory == null) {
                    this.disableNextCodeCompletionPage();
                } else {
                    this.myContentAssistant.setStatusLineVisible(true);
                    this.myContentAssistant.setStatusMessage(NLS.bind((String)Messages.QvtCompletionProcessor_PressCtrlSpace, (Object)nextCategory.getLabel()));
                }
            }
            LinkedHashSet<ICompletionProposal> proposals = new LinkedHashSet<ICompletionProposal>();
            for (CollectorDescriptor collectorDescriptor : CollectorRegistry.getCollectors(this.getCurrentCategory().getId())) {
                ICollector collector = collectorDescriptor.getCollector();
                if (!collector.isApplicable(data)) continue;
                collector.addPropoposals(proposals, data);
            }
            ICompletionProposal[] iCompletionProposalArray = proposals.toArray(new ICompletionProposal[proposals.size()]);
            return iCompletionProposalArray;
        }
        finally {
            this.myOffset = offset;
        }
    }

    private ICompletionProposal[] disableNextCodeCompletionPage() {
        this.myContentAssistant.setStatusLineVisible(false);
        return null;
    }

    private int updateCategoryIndex(QvtCompletionData data) {
        if (this.myCategoryIndex == -1) {
            CategoryDescriptor[] allCategories;
            this.myCategories = new ArrayList<CategoryDescriptor>();
            CategoryDescriptor[] categoryDescriptorArray = allCategories = CollectorRegistry.getCategories();
            int n = allCategories.length;
            int n2 = 0;
            while (n2 < n) {
                CategoryDescriptor categoryDescriptor = categoryDescriptorArray[n2];
                List<CollectorDescriptor> collectorDescriptors = CollectorRegistry.getCollectors(categoryDescriptor.getId());
                boolean isApplicable = false;
                if (collectorDescriptors != null) {
                    for (CollectorDescriptor collectorDescriptor : collectorDescriptors) {
                        ICollector collector = collectorDescriptor.getCollector();
                        if (!collector.isApplicable(data)) continue;
                        isApplicable = true;
                        break;
                    }
                }
                if (isApplicable) {
                    this.myCategories.add(categoryDescriptor);
                }
                ++n2;
            }
        }
        if (this.myCategories.isEmpty()) {
            return -1;
        }
        ++this.myCategoryIndex;
        if (this.myCategoryIndex == this.myCategories.size()) {
            this.myCategoryIndex = 0;
        }
        return this.myCategoryIndex;
    }

    public CategoryDescriptor getCurrentCategory() {
        if (this.myCategories.isEmpty()) {
            return null;
        }
        return this.myCategories.get(this.myCategoryIndex);
    }

    public CategoryDescriptor getNextCategory() {
        if (this.myCategories.size() == 1) {
            return null;
        }
        int index = this.myCategoryIndex + 1;
        if (index == this.myCategories.size()) {
            index = 0;
        }
        return this.myCategories.get(index);
    }

    public CategoryDescriptor getLastCategory() {
        if (this.myCategories.isEmpty()) {
            return null;
        }
        return this.myCategories.get(this.myCategories.size() - 1);
    }

    public static final CSTNode findLeftmostCSTNode(CSTNode root, int offset) {
        CSTNode result = null;
        TreeIterator iterator = root.eAllContents();
        while (iterator.hasNext()) {
            CSTNode child;
            EObject next = (EObject)iterator.next();
            if (!(next instanceof CSTNode) || (child = (CSTNode)next).getEndOffset() >= offset || result != null && child.getEndOffset() <= result.getEndOffset() && (child.getEndOffset() != result.getEndOffset() || child.getStartOffset() >= result.getStartOffset())) continue;
            result = child;
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ACTIVATION;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

