/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    public static String[] tokenize(String line) {
        ArrayList<String> resultBuffer = new ArrayList<String>();
        if (line != null) {
            int len = line.length();
            boolean insideQuotes = false;
            StringBuilder buf = new StringBuilder();
            int ii = 0;
            while (ii < len) {
                char c = line.charAt(ii);
                if (c == '\"') {
                    if (insideQuotes && buf.length() == 0) {
                        resultBuffer.add(null);
                    } else {
                        CommandLine.appendToBuffer(resultBuffer, buf);
                    }
                    insideQuotes = !insideQuotes;
                } else if (c == '\\') {
                    if (len > ii + 1 && (line.charAt(ii + 1) == '\"' || line.charAt(ii + 1) == '\\')) {
                        buf.append(line.charAt(ii + 1));
                        ++ii;
                    } else {
                        buf.append("\\");
                    }
                } else if (insideQuotes) {
                    buf.append(c);
                } else if (Character.isWhitespace(c)) {
                    CommandLine.appendToBuffer(resultBuffer, buf);
                } else {
                    buf.append(c);
                }
                ++ii;
            }
            CommandLine.appendToBuffer(resultBuffer, buf);
        }
        return resultBuffer.toArray(new String[0]);
    }

    public static IResult execute(IQueryContext context, String commandLine, IProgressListener listener) throws SnapshotException {
        ArgumentSet set = CommandLine.parse(context, commandLine);
        QueryResult result = set.execute(listener);
        return result != null ? result.getSubject() : null;
    }

    public static ArgumentSet parse(IQueryContext context, String line) throws SnapshotException {
        String[] args = CommandLine.tokenize(line);
        if (args.length == 0) {
            throw new SnapshotException(MessageUtil.format(Messages.CommandLine_Error_InvalidCommand, line));
        }
        QueryDescriptor descriptor = QueryRegistry.instance().getQuery(args[0].toLowerCase(Locale.ENGLISH));
        if (descriptor == null) {
            throw new SnapshotException(MessageUtil.format(Messages.CommandLine_Error_NotFound, args[0]));
        }
        ArgumentSet arguments = descriptor.createNewArgumentSet(context);
        for (ArgumentDescriptor argDescriptor : descriptor.getArguments()) {
            if (argDescriptor.getType() != Boolean.class && argDescriptor.getType() != Boolean.TYPE || Boolean.FALSE.equals(argDescriptor.getDefaultValue())) continue;
            arguments.setArgumentValue(argDescriptor, (Object)Boolean.FALSE);
        }
        ParsePosition pos = new ParsePosition(1);
        CommandLine.parseArguments(arguments, args, pos);
        return arguments;
    }

    public static void fillIn(ArgumentSet arguments, String line) throws SnapshotException {
        String[] args = CommandLine.tokenize(line);
        if (args.length == 0) {
            throw new SnapshotException(MessageUtil.format(Messages.CommandLine_Error_InvalidCommand, line));
        }
        ParsePosition pos = new ParsePosition(0);
        CommandLine.parseArguments(arguments, args, pos);
    }

    private static void parseArguments(ArgumentSet arguments, String[] args, ParsePosition pos) throws SnapshotException {
        QueryDescriptor descriptor = arguments.getQueryDescriptor();
        boolean mandatoryUnflaggedArgumentIsSet = false;
        while (pos.getIndex() < args.length) {
            String arg = args[pos.getIndex()];
            if (arg != null && arg.charAt(0) == '-' && arg.length() > 1) {
                pos.setIndex(pos.getIndex() + 1);
                String flag = arg.substring(1).toLowerCase(Locale.ENGLISH);
                ArgumentDescriptor argDescriptor = descriptor.byFlag(flag);
                if (argDescriptor == null) {
                    argDescriptor = descriptor.byFlag(arg.substring(1));
                }
                if (argDescriptor == null) {
                    throw new SnapshotException(MessageUtil.format(Messages.CommandLine_Error_MissingArgument, descriptor.getName(), flag));
                }
                Object value = argDescriptor.getType() == Boolean.class || argDescriptor.getType() == Boolean.TYPE ? Boolean.TRUE : (arguments.getQueryContext().parses(argDescriptor.getType(), argDescriptor.getAdvice()) ? arguments.getQueryContext().parse(argDescriptor.getType(), argDescriptor.getAdvice(), args, pos) : (argDescriptor.isMultiple() ? CommandLine.consumeMultipleArguments(arguments.getQueryContext(), argDescriptor, args, pos) : CommandLine.consumeSingleArgument(arguments.getQueryContext(), argDescriptor, args, pos)));
                arguments.setArgumentValue(argDescriptor, value);
                continue;
            }
            ArgumentDescriptor argDescriptor = null;
            for (ArgumentDescriptor a : arguments.getUnsetArguments()) {
                if (a.getFlag() != null) continue;
                argDescriptor = a;
                break;
            }
            if (argDescriptor == null) {
                throw new SnapshotException(MessageUtil.format(Messages.CommandLine_Error_NoUnflaggedArguments, arg));
            }
            if (mandatoryUnflaggedArgumentIsSet) {
                throw new SnapshotException(MessageUtil.format(Messages.CommandLine_Error_AssignmentFailed, args[pos.getIndex()], argDescriptor.getName()));
            }
            Object value = arguments.getQueryContext().parses(argDescriptor.getType(), argDescriptor.getAdvice()) ? arguments.getQueryContext().parse(argDescriptor.getType(), argDescriptor.getAdvice(), args, pos) : (argDescriptor.isMultiple() ? CommandLine.consumeMultipleArguments(arguments.getQueryContext(), argDescriptor, args, pos) : CommandLine.consumeSingleArgument(arguments.getQueryContext(), argDescriptor, args, pos));
            arguments.setArgumentValue(argDescriptor, value);
            mandatoryUnflaggedArgumentIsSet = true;
        }
    }

    private static Object consumeSingleArgument(IQueryContext context, ArgumentDescriptor descriptor, String[] args, ParsePosition pos) throws SnapshotException {
        if (pos.getIndex() >= args.length) {
            throw CommandLine.error(descriptor);
        }
        String value = args[pos.getIndex()];
        pos.setIndex(pos.getIndex() + 1);
        return value == null ? null : context.convertToValue(descriptor.getType(), descriptor.getAdvice(), value);
    }

    private static Object consumeMultipleArguments(IQueryContext context, ArgumentDescriptor descriptor, String[] args, ParsePosition pos) throws SnapshotException {
        List<String> arguments = CommandLine.consumeMultipleTokens(args, pos);
        if (descriptor.isMandatory() && arguments.isEmpty()) {
            throw CommandLine.error(descriptor);
        }
        if (arguments == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>(arguments.size());
        for (String arg : arguments) {
            values.add(context.convertToValue(descriptor.getType(), descriptor.getAdvice(), arg));
        }
        return values;
    }

    private static List<String> consumeMultipleTokens(String[] args, ParsePosition pos) {
        ArrayList<String> arguments = new ArrayList<String>();
        while (pos.getIndex() < args.length) {
            String arg = args[pos.getIndex()];
            if (arg != null && arg.length() == 1 && arg.charAt(0) == ';') {
                pos.setIndex(pos.getIndex() + 1);
                break;
            }
            if (arg != null && arg.length() > 1 && arg.charAt(0) == '-') break;
            if (arg != null && arg.length() > 1 && arg.charAt(arg.length() - 1) == ';') {
                pos.setIndex(pos.getIndex() + 1);
                arguments.add(arg.substring(0, arg.length() - 1));
                break;
            }
            pos.setIndex(pos.getIndex() + 1);
            if (arg == null) continue;
            arguments.add(arg);
        }
        return arguments;
    }

    private static SnapshotException error(ArgumentDescriptor descriptor) {
        String flag = descriptor.getFlag() != null ? "( -" + descriptor.getFlag() + " )" : "";
        return new SnapshotException(MessageUtil.format(Messages.CommandLine_Error_MissingValue, descriptor.getName(), flag));
    }

    private static void appendToBuffer(List<String> resultBuffer, StringBuilder buf) {
        if (buf.length() > 0) {
            resultBuffer.add(buf.toString());
            buf.setLength(0);
        }
    }
}

