/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.osgi.framework.Version;

public class GerritVersion {
    public static final Version VERSION_2_11_2 = new Version(2, 11, 2);
    private static final Pattern MAJOR_MINOR_MICRO_VERSION_PATTERN = Pattern.compile("V?\\d+\\.\\d+(\\.\\d+)?");
    private static final Pattern MAJOR_MINOR_QUALIFIER_VERSION_PATTERN = Pattern.compile("V?(\\d+)\\.(\\d+)-([-\\w]+).*");
    private static final Pattern MAJOR_MINOR_MICRO_QUALIFIER_VERSION_PATTERN = Pattern.compile("V?(\\d+)\\.(\\d+)\\.(\\d+)[-\\.]([-\\w]+).*");

    private GerritVersion() {
    }

    public static Version parseGerritVersion(String version) {
        Assert.isLegal((version != null ? 1 : 0) != 0);
        Assert.isLegal((!version.isEmpty() ? 1 : 0) != 0);
        Matcher matcher = MAJOR_MINOR_MICRO_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return Version.parseVersion((String)version);
        }
        matcher = MAJOR_MINOR_QUALIFIER_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), 0, matcher.group(3));
        }
        matcher = MAJOR_MINOR_MICRO_QUALIFIER_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4));
        }
        throw new IllegalArgumentException("Unrecognized version pattern : " + version);
    }

    public static boolean isVersion2112OrLater(Version version) {
        return version.compareTo(VERSION_2_11_2) >= 0;
    }
}

