/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.launching;

import java.io.IOException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.core.EvaluationContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMContext;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMExecutor;
import org.eclipse.ocl.examples.debug.vm.messages.VMMessages;
import org.eclipse.ocl.examples.debug.vm.request.VMStartRequest;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.EmfUtil;
import org.eclipse.ocl.examples.debug.vm.utils.ExecutionDiagnostic;
import org.eclipse.ocl.examples.debug.vm.utils.ExecutionDiagnosticImpl;
import org.eclipse.ocl.examples.debug.vm.utils.Log;
import org.eclipse.ocl.examples.debug.vm.utils.Messages;
import org.eclipse.ocl.examples.debug.vm.utils.VMException;
import org.eclipse.ocl.examples.debug.vm.utils.VMInterruptedExecutionException;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackOverFlowError;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.osgi.util.NLS;

public abstract class InternalDebuggableExecutor {
    protected final @NonNull IVMContext vmContext;
    protected final @NonNull URI debuggableURI;
    private @Nullable CompiledUnit fCompiledUnit;
    private ResourceSet fCompilationRs;
    private ExecutionDiagnosticImpl fLoadDiagnostic;
    private @Nullable VMExecutor vmExecutor;

    private static boolean isSuccess(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        return severity == 0 || severity == 2 || severity == 1;
    }

    protected InternalDebuggableExecutor(@NonNull IVMContext vmContext, @NonNull URI debuggableURI) {
        this.vmContext = vmContext;
        this.debuggableURI = debuggableURI;
    }

    public void cleanup() {
        if (this.fCompilationRs != null) {
            EmfUtil.cleanupResourceSet(this.fCompilationRs);
        }
    }

    private static ExecutionDiagnostic createExecutionFailure(@NonNull InvalidValueException vmRuntimeException) {
        int code = 0;
        int severity = 4;
        String message = vmRuntimeException.getLocalizedMessage();
        Object[] data = null;
        if (vmRuntimeException instanceof VMException) {
            code = 120;
        } else if (vmRuntimeException instanceof VMInterruptedExecutionException) {
            code = 110;
            severity = 8;
        } else {
            code = 120;
            if (!(vmRuntimeException instanceof VMStackOverFlowError)) {
                Throwable cause = vmRuntimeException.getCause();
                data = new Object[]{cause != null ? cause : vmRuntimeException};
            } else {
                message = Messages.StackTraceOverFlowError;
            }
        }
        if (message == null) {
            message = NLS.bind((String)Messages.VMRuntimeExceptionCaught, (Object)vmRuntimeException.getClass().getName());
        }
        ExecutionDiagnosticImpl diagnostic = new ExecutionDiagnosticImpl(severity, code, message, data);
        if (vmRuntimeException instanceof VMRuntimeException) {
            diagnostic.setStackTrace(((VMRuntimeException)vmRuntimeException).getVMStackTrace());
        }
        return diagnostic;
    }

    private @NonNull EvaluationContext createInternalContext(@NonNull EvaluationContext evaluationContext) {
        EvaluationContext ctx = evaluationContext;
        return ctx;
    }

    protected abstract @NonNull VMExecutor createVMExecutor() throws IOException, ParserException;

    private ExecutionDiagnostic doExecute(@NonNull VMStartRequest startRequest, @NonNull EvaluationContext evaluationContext) throws IOException {
        VMExecutor vmEvaluator2 = this.vmExecutor;
        if (vmEvaluator2 != null) {
            vmEvaluator2.setSuspendOnStartUp(startRequest.suspendOnStartup);
            vmEvaluator2.execute();
        }
        return ExecutionDiagnostic.OK_INSTANCE;
    }

    private void doLoad() {
        this.fLoadDiagnostic = ExecutionDiagnosticImpl.OK_INSTANCE;
        try {
            VMExecutor vmExecutor2;
            this.vmExecutor = vmExecutor2 = this.createVMExecutor();
            this.fCompiledUnit = new CompiledUnit((Element)vmExecutor2.getDebuggable());
        }
        catch (Exception e) {
            this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind((String)Messages.FailedToCompileUnitError, (Object)this.debuggableURI));
            this.fLoadDiagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
    }

    public ExecutionDiagnostic execute(@NonNull VMStartRequest startRequest, @NonNull EvaluationContext evaluationContext) {
        this.loadDebuggable();
        if (!InternalDebuggableExecutor.isSuccess(this.fLoadDiagnostic)) {
            return this.fLoadDiagnostic;
        }
        try {
            return this.doExecute(startRequest, this.createInternalContext(evaluationContext));
        }
        catch (InvalidValueException e) {
            Log logger = evaluationContext.getLog();
            if (logger != null) {
                logger.log(VMMessages.TerminatingExecution);
            }
            return InternalDebuggableExecutor.createExecutionFailure(e);
        }
        catch (Exception e) {
            Log logger = evaluationContext.getLog();
            if (logger != null) {
                logger.log(VMMessages.TerminatingExecution);
            }
            return InternalDebuggableExecutor.createExecutionFailure((InvalidValueException)((Object)new VMRuntimeException("Execution failed", e)));
        }
    }

    public @Nullable NamedElement getDebuggable() {
        VMExecutor xtextEvaluator2 = this.vmExecutor;
        return xtextEvaluator2 != null ? xtextEvaluator2.getDebuggable() : null;
    }

    public ResourceSet getResourceSet() {
        return this.fCompilationRs;
    }

    public @NonNull URI getURI() {
        return this.debuggableURI;
    }

    public @Nullable CompiledUnit getUnit() {
        this.loadDebuggable();
        return this.fCompiledUnit;
    }

    public @NonNull IVMContext getVMContext() {
        return this.vmContext;
    }

    public VMExecutor getVMExecutor() {
        return this.vmExecutor;
    }

    public Diagnostic loadDebuggable() {
        if (this.fLoadDiagnostic == null) {
            this.doLoad();
        }
        return this.fLoadDiagnostic;
    }

    public String toString() {
        return "OCL-Executor: " + this.debuggableURI;
    }
}

