/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingResult;

public class BaseLicensingResult
implements LicensingResult {
    public static final int CODE_NOMINAL = 0;
    private int severity;
    private final String message;
    private final int code;
    private final String source;
    private final Throwable exception;
    private final Map<String, Object> attachments = new LinkedHashMap<String, Object>();
    private final List<LicensingResult> children = new ArrayList<LicensingResult>();

    public BaseLicensingResult(int severity, String message, String source) {
        this(severity, message, 0, source, null, null, null);
    }

    public BaseLicensingResult(int severity, String message, int code, String source, Throwable exception) {
        this(severity, message, code, source, exception, null, null);
    }

    public BaseLicensingResult(int severity, String message, int code, String source, Throwable exception, Iterable<LicensingResult> details, Map<String, Object> data) {
        this.severity = severity;
        this.message = message;
        this.source = source;
        this.code = code;
        this.exception = exception;
        if (details != null) {
            for (LicensingResult result : details) {
                this.addChild(result);
            }
        }
        if (data != null) {
            this.attachments.putAll(data);
        }
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSource() {
        return this.source;
    }

    public int getCode() {
        return this.code;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Iterable<String> getAttachmentKeys() {
        return this.attachments.keySet();
    }

    public Object getAttachment(String key) {
        return this.attachments.get(key);
    }

    public Iterable<LicensingResult> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected void addChild(LicensingResult result) {
        int newSev = result.getSeverity();
        if (newSev > this.getSeverity()) {
            this.severity = newSev;
        }
        this.children.add(result);
    }
}

