/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;

public final class ReferenceResolver {
    private ReferenceResolver() {
    }

    public static void resolveReferences(List<IReference> references, IProgressMonitor monitor) throws CoreException {
        int refcount = references.size();
        LinkedHashMap<String, List<IReference>> sigtoref = new LinkedHashMap<String, List<IReference>>(refcount);
        ArrayList<IReference> refs = null;
        String key = null;
        ArrayList<Reference> methodDecls = new ArrayList<Reference>(refcount);
        long start = System.currentTimeMillis();
        for (IReference ref : references) {
            if (ref.getReferenceKind() == 0x10000000) {
                methodDecls.add((Reference)ref);
                continue;
            }
            key = ReferenceResolver.createSignatureKey(ref);
            refs = (ArrayList<IReference>)sigtoref.get(key);
            if (refs == null) {
                refs = new ArrayList<IReference>(20);
                sigtoref.put(key, refs);
            }
            refs.add(ref);
        }
        long end = System.currentTimeMillis();
        if (ApiPlugin.DEBUG_REFERENCE_RESOLVER) {
            System.out.println("Reference resolver: split into " + methodDecls.size() + " method overrides and " + sigtoref.size() + " unique references (" + (end - start) + "ms)");
        }
        start = System.currentTimeMillis();
        ReferenceResolver.resolveReferenceSets(sigtoref, monitor);
        end = System.currentTimeMillis();
        if (ApiPlugin.DEBUG_REFERENCE_RESOLVER) {
            System.out.println("Reference resolver: resolved unique references in " + (end - start) + "ms");
        }
        start = System.currentTimeMillis();
        for (Reference reference : methodDecls) {
            reference.resolve();
        }
        end = System.currentTimeMillis();
        if (ApiPlugin.DEBUG_REFERENCE_RESOLVER) {
            System.out.println("Reference resolver: resolved method overrides in " + (end - start) + "ms");
        }
    }

    private static void resolveReferenceSets(Map<String, List<IReference>> map, IProgressMonitor monitor) throws CoreException {
        IReference ref = null;
        for (List<IReference> refs : map.values()) {
            ref = refs.get(0);
            ((Reference)ref).resolve();
            IApiMember resolved = ref.getResolvedReference();
            if (resolved == null) continue;
            for (IReference ref2 : refs) {
                ((Reference)ref2).setResolution(resolved);
            }
        }
    }

    private static String createSignatureKey(IReference reference) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(reference.getMember().getApiComponent().getSymbolicName());
        buffer.append("#");
        buffer.append(reference.getReferencedTypeName());
        switch (reference.getReferenceType()) {
            case 2: {
                buffer.append("#");
                buffer.append(reference.getReferencedMemberName());
                break;
            }
            case 3: {
                buffer.append("#");
                buffer.append(reference.getReferencedMemberName());
                buffer.append("#");
                buffer.append(reference.getReferencedSignature());
                break;
            }
        }
        return buffer.toString();
    }
}

