/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.core.libfolders.RenameLibraryFolderChange;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.util.collections.BucketMap;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.changes.ProgramFileChange;
import org.eclipse.php.refactoring.core.changes.ProjectReferenceChange;
import org.eclipse.php.refactoring.core.changes.RenameBreackpointChange;
import org.eclipse.php.refactoring.core.changes.RenameBuildAndIcludePathChange;
import org.eclipse.php.refactoring.core.changes.RenameConfigurationChange;
import org.eclipse.php.refactoring.core.move.MoveUtils;
import org.eclipse.php.refactoring.core.rename.AbstraceRenameResourceProcessor;
import org.eclipse.php.refactoring.core.rename.IReferenceUpdating;
import org.eclipse.php.refactoring.core.rename.RenameClassProcessor;
import org.eclipse.php.refactoring.core.rename.logic.RenameIncludeFolder;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameFolderProcessor
extends AbstraceRenameResourceProcessor
implements IReferenceUpdating {
    public static final String RENAME_FOLDER_PROCESSOR_NAME = PHPRefactoringCoreMessages.getString("RenameResourceProcessor.0");
    private static final String REFACTORING_ACTION_INTERNAL_ERROR = PHPRefactoringCoreMessages.getString("RenameProcessorBase.internalerror");
    private static final String ID_RENAME_FOLDER = "php.refactoring.ui.rename.folder";
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean isUpdateTextualMatches;
    private ArrayList<IBuildpathEntry> newBuildEntries;
    private ArrayList<IBuildpathEntry> newIncludePathEntries;
    private List<IBuildpathEntry> oldBuildEntries;
    private List<IBuildpathEntry> oldIncludePath;

    public RenameFolderProcessor(IContainer container) {
        super((IResource)container);
        this.attributes.put("org.eclipse.php.refactoring.core.rename.resource.needclassname", Boolean.FALSE.toString());
    }

    @Override
    public RefactoringStatus getRefactoringStatus(IFile key, Program program) {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        NoReverseCompositeChange rootChange = new NoReverseCompositeChange(RENAME_FOLDER_PROCESSOR_NAME);
        rootChange.markAsSynthetic();
        try {
            pm.beginTask(PHPRefactoringCoreMessages.getString("RenameFolderProcessor.RenamingFile"), 100);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.getUpdateReferences()) {
                this.createRenameTextChanges(pm, rootChange);
                this.createRenameReferenceChange(pm, rootChange);
                this.createRenameLibraryFolderChange(rootChange);
            } else {
                this.createFileRenameChange(rootChange);
            }
        }
        finally {
            pm.done();
        }
        return rootChange;
    }

    private void createRenameLibraryFolderChange(CompositeChange rootChange) {
        LibraryFolderManager lfm = LibraryFolderManager.getInstance();
        if (lfm.isInLibraryFolder(this.resource)) {
            IFolder folder = (IFolder)this.resource;
            IFolder newFolder = this.resource.getParent().getFolder(Path.fromPortableString((String)this.fNewElementName));
            RenameLibraryFolderChange change = new RenameLibraryFolderChange(folder, newFolder);
            rootChange.add((Change)change);
        }
    }

    private void createRenameReferenceChange(IProgressMonitor pm, CompositeChange rootChange) throws CoreException {
        IProject[] referencing;
        pm.beginTask(PHPRefactoringCoreMessages.getString("RenameFolderProcessor.0"), 0);
        pm.setTaskName(PHPRefactoringCoreMessages.getString("RenameFolderProcessor.1"));
        IPath source = this.resource.getFullPath().removeLastSegments(1);
        String oldName = this.resource.getName();
        IPath dest = this.getNewFilePath();
        RenameConfigurationChange confChange = new RenameConfigurationChange(source.removeLastSegments(0), dest.removeLastSegments(0), oldName, this.fNewElementName);
        rootChange.add((Change)confChange);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.createFileRenameChange(rootChange);
        if (this.resource instanceof IProject && (referencing = ((IProject)this.resource).getReferencingProjects()) != null && referencing.length > 0) {
            ProjectReferenceChange change = new ProjectReferenceChange(this.resource.getName(), this.getNewElementName(), referencing);
            rootChange.add((Change)change);
        }
        this.collectBuildPath();
        RenameBuildAndIcludePathChange biChange = new RenameBuildAndIcludePathChange(source, dest, oldName, this.fNewElementName, this.oldBuildEntries, this.newBuildEntries, this.oldIncludePath, this.newIncludePathEntries);
        if (this.newBuildEntries.size() > 0 || this.newIncludePathEntries.size() > 0) {
            rootChange.add((Change)biChange);
        }
        this.collectBrakePoint();
        if (this.fBreakpoints.getKeys().size() > 0) {
            RenameBreackpointChange breakePointchange = new RenameBreackpointChange(source, dest, oldName, this.fNewElementName, (BucketMap<IResource, IBreakpoint>)this.fBreakpoints, this.fBreakpointAttributes);
            rootChange.add((Change)breakePointchange);
        }
    }

    private void collectBuildPath() throws ModelException {
        IProject project = this.resource.getProject();
        IScriptProject projrct = DLTKCore.create((IProject)project);
        IPath filePath = this.resource.getFullPath();
        this.oldBuildEntries = Arrays.asList(projrct.readRawBuildpath());
        this.newBuildEntries = new ArrayList();
        this.newBuildEntries.addAll(this.oldBuildEntries);
        int i = 0;
        while (i < this.oldBuildEntries.size()) {
            IBuildpathEntry newEntry;
            IBuildpathEntry fEntryToChange = this.oldBuildEntries.get(i);
            IPath entryPath = fEntryToChange.getPath();
            int mattchedPath = entryPath.matchingFirstSegments(filePath);
            IPath truncatedPath = entryPath.uptoSegment(mattchedPath);
            IPath remaingPath = entryPath.removeFirstSegments(mattchedPath);
            if (mattchedPath == filePath.segmentCount()) {
                IPath newPath = truncatedPath.removeLastSegments(1).append(this.fNewElementName).append(remaingPath);
                newEntry = RefactoringUtility.createNewBuildpathEntry(fEntryToChange, newPath, filePath, this.fNewElementName);
                this.newBuildEntries.remove(fEntryToChange);
                this.newBuildEntries.add(newEntry);
            } else {
                newEntry = RefactoringUtility.createNewBuildpathEntry(fEntryToChange, fEntryToChange.getPath(), filePath, this.fNewElementName);
                this.newBuildEntries.remove(fEntryToChange);
                this.newBuildEntries.add(newEntry);
            }
            ++i;
        }
        this.oldIncludePath = new ArrayList<IBuildpathEntry>();
        this.newIncludePathEntries = new ArrayList();
        List<IncludePath> includePathEntries = Arrays.asList(IncludePathManager.getInstance().getIncludePaths(project));
        for (IncludePath entry : includePathEntries) {
            Object includePathEntry = entry.getEntry();
            IResource resource = null;
            if (!(includePathEntry instanceof IBuildpathEntry)) {
                resource = (IResource)includePathEntry;
                IPath entryPath = resource.getFullPath();
                IBuildpathEntry oldEntry = RefactoringUtility.createNewBuildpathEntry(3, entryPath);
                this.oldIncludePath.add(oldEntry);
                if (filePath.isPrefixOf(entryPath) || entryPath.equals((Object)filePath)) {
                    int mattchedPath = entryPath.matchingFirstSegments(filePath);
                    IPath truncatedPath = entryPath.uptoSegment(mattchedPath);
                    IPath remaingPath = entryPath.removeFirstSegments(mattchedPath);
                    IPath newPath = mattchedPath == filePath.segmentCount() ? truncatedPath.removeLastSegments(1).append(this.fNewElementName).append(remaingPath) : truncatedPath.append(this.fNewElementName).append(remaingPath);
                    IBuildpathEntry newEntry = RefactoringUtility.createNewBuildpathEntry(3, newPath);
                    this.newIncludePathEntries.add(newEntry);
                    continue;
                }
                IBuildpathEntry newEntry = RefactoringUtility.createNewBuildpathEntry(3, entryPath);
                this.newIncludePathEntries.add(newEntry);
                continue;
            }
            this.newIncludePathEntries.add((IBuildpathEntry)includePathEntry);
            this.oldIncludePath.add((IBuildpathEntry)includePathEntry);
        }
    }

    private void createRenameTextChanges(IProgressMonitor pm, CompositeChange rootChange) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(RenameClassProcessor.RENAME_IS_PROCESSING, 1);
            pm.setTaskName(RenameClassProcessor.CREATING_MODIFICATIONS_LABEL);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            String newElementName = this.getNewElementName();
            if (this.getUpdateReferences()) {
                for (Map.Entry entry : this.participantFiles.entrySet()) {
                    IFile file = (IFile)entry.getKey();
                    Program program = (Program)entry.getValue();
                    RenameIncludeFolder rename = new RenameIncludeFolder(file, this.getCurrentElementName(), newElementName, this.resource.getFullPath(), false, this.getUpdateReferences());
                    program.accept((Visitor)rename);
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    pm.worked(1);
                    if (!rename.hasChanges()) continue;
                    ProgramFileChange change = new ProgramFileChange(file.getName(), file, program);
                    change.setEdit((TextEdit)new MultiTextEdit());
                    change.setTextType("php");
                    rootChange.add((Change)change);
                    rename.updateChange(change);
                }
            }
        }
        finally {
            pm.done();
        }
    }

    private void createFileRenameChange(CompositeChange rootChange) {
        RenameResourceChange rmChange = new RenameResourceChange(this.resource.getFullPath(), this.fNewElementName);
        rootChange.add((Change)rmChange);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.checkReadOnlyAndNull(this.resource)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)PHPRefactoringCoreMessages.getString("RenameFileProcessor.7"), (Object)this.resource)));
        }
        try {
            boolean hasExternalDependencies = false;
            this.participantFiles = new HashMap();
            if (this.resource instanceof IContainer) {
                IContainer container = (IContainer)this.resource;
                HashSet<IFile> phpFilesSet = new HashSet<IFile>();
                MoveUtils.getAllPHPFiles(new IResource[]{container}, phpFilesSet);
                for (IFile file : phpFilesSet) {
                    ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
                    IProject project = file.getProject();
                    ASTParser newParser = ASTParser.newParser((IProject)project, (ISourceModule)sourceModule);
                    Program program = newParser.createAST(null);
                    this.participantFiles.put(file, program);
                    this.collectReferences(program, pm);
                }
            }
            if (hasExternalDependencies) {
                String message = PHPRefactoringCoreMessages.getString("AbstractRenameProcessor.1");
                return RefactoringStatus.createWarningStatus((String)message);
            }
            return new RefactoringStatus();
        }
        catch (Exception e) {
            String exceptionMessage = e.getMessage();
            String formattedString = REFACTORING_ACTION_INTERNAL_ERROR.concat(exceptionMessage == null ? "" : exceptionMessage);
            return RefactoringStatus.createFatalErrorStatus((String)formattedString);
        }
    }

    private boolean checkReadOnlyAndNull(IResource currentResource) {
        if (currentResource == null) {
            return false;
        }
        ResourceAttributes attributes = currentResource.getResourceAttributes();
        if (attributes == null) {
            return false;
        }
        return !attributes.isReadOnly();
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IPath sourcePath = this.resource.getFullPath().removeLastSegments(1);
        String newFilePath = String.valueOf(sourcePath.toOSString()) + File.separatorChar + this.getNewElementName();
        Object dest = sourcePath.segmentCount() < 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.getNewElementName()) : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(newFilePath));
        if (dest.exists()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)PHPRefactoringCoreMessages.getString("RenameFileProcessor.8"), (Object)this.getNewElementName(), (Object)sourcePath.toOSString())));
        }
        return status;
    }

    private IPath getNewFilePath() {
        return this.resource.getFullPath().removeLastSegments(1);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.resource};
    }

    public String getIdentifier() {
        return ID_RENAME_FOLDER;
    }

    public String getProcessorName() {
        return RENAME_FOLDER_PROCESSOR_NAME;
    }

    @Override
    public String getCurrentElementName() {
        return this.resource.getName();
    }

    @Override
    public void setUpdateRefernces(boolean update) {
        this.isUpdateReferences = update;
    }

    @Override
    public boolean canEnableTextUpdating() {
        return false;
    }

    @Override
    public String getCurrentElementQualifier() {
        return this.resource.getName();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.isUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.isUpdateTextualMatches = update;
    }

    @Override
    public Object getNewElement() throws CoreException {
        return null;
    }

    @Override
    public String getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void setAttribute(String attribute, String value) {
        this.attributes.put(attribute, value);
    }

    private class NoReverseCompositeChange
    extends CompositeChange {
        public NoReverseCompositeChange(String name) {
            super(name);
        }

        public NoReverseCompositeChange(String name, Change[] array) {
            super(name, array);
        }

        protected Change createUndoChange(Change[] childUndos) {
            List<Change> undos = Arrays.asList(childUndos);
            Collections.reverse(undos);
            return new NoReverseCompositeChange(this.getName(), undos.toArray(new Change[undos.size()]));
        }
    }
}

