/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.eclipse.ui.browser.BrowserEditor;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.hamcrest.Matcher;

public class BrowserHasURL
extends AbstractWaitCondition {
    private WebBrowserView browser;
    private BrowserEditor browserEditor;
    private String expectedURL;
    private Matcher<String> expectedURLMatcher;
    private String resultURL;

    public BrowserHasURL(WebBrowserView browser, String expectedURL) {
        this.browser = browser;
        this.expectedURL = expectedURL;
    }

    public BrowserHasURL(WebBrowserView browser, Matcher<String> expectedURLMatcher) {
        this.browser = browser;
        this.expectedURLMatcher = expectedURLMatcher;
    }

    public BrowserHasURL(BrowserEditor browser, String expectedURL) {
        this.browserEditor = browser;
        this.expectedURL = expectedURL;
    }

    public BrowserHasURL(BrowserEditor browser, Matcher<String> expectedURLMatcher) {
        this.browserEditor = browser;
        this.expectedURLMatcher = expectedURLMatcher;
    }

    public boolean test() {
        boolean matches = false;
        if (this.expectedURLMatcher != null) {
            if (this.browser != null) {
                matches = this.expectedURLMatcher.matches((Object)this.browser.getPageURL());
                if (matches) {
                    this.resultURL = this.browser.getPageURL();
                }
                return matches;
            }
            matches = this.expectedURLMatcher.matches((Object)this.browserEditor.getPageURL());
            if (matches) {
                this.resultURL = this.browserEditor.getPageURL();
            }
            return matches;
        }
        if (this.browser != null) {
            matches = this.browser.getPageURL().equals(this.expectedURL);
            if (matches) {
                this.resultURL = this.expectedURL;
            }
            return matches;
        }
        matches = this.browserEditor.getPageURL().equals(this.expectedURL);
        if (matches) {
            this.resultURL = this.expectedURL;
        }
        return matches;
    }

    public String description() {
        if (this.expectedURLMatcher != null) {
            return "browser is pointed to URL: " + this.expectedURLMatcher.toString();
        }
        return "browser is pointed to URL: " + this.expectedURL;
    }

    public String getResult() {
        return this.resultURL;
    }
}

