/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ShellHasChildrenOrIsNotAvailable
extends AbstractWaitCondition {
    private org.eclipse.reddeer.swt.api.Shell shell;
    private static final Logger log = Logger.getLogger(ShellHasChildrenOrIsNotAvailable.class);
    private List<Shell> resultChildren;

    public ShellHasChildrenOrIsNotAvailable(org.eclipse.reddeer.swt.api.Shell shell) {
        this.shell = shell;
        this.resultChildren = new ArrayList<Shell>();
    }

    public boolean test() {
        Shell swtShell = (Shell)this.shell.getSWTWidget();
        try {
            this.resultChildren = Arrays.asList(ShellLookup.getInstance().getShells(swtShell));
        }
        catch (RedDeerException redDeerException) {
            if (swtShell != null) {
                return WidgetHandler.getInstance().isDisposed((Widget)swtShell);
            }
            return true;
        }
        log.debug("number of child shells: " + this.resultChildren.size());
        return this.resultChildren.size() > 0;
    }

    public String description() {
        return "Shell has children or is not available.";
    }

    public List<Shell> getResult() {
        return this.resultChildren.isEmpty() ? null : this.resultChildren;
    }
}

