/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.button;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.ButtonHandler;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.impl.button.AbstractButton;
import org.eclipse.swt.widgets.Button;
import org.hamcrest.Matcher;

public class CheckBox
extends AbstractButton {
    private static final Logger log = Logger.getLogger(CheckBox.class);

    public CheckBox() {
        this((ReferencedComposite)null);
    }

    public CheckBox(Button widget) {
        super(widget);
    }

    public CheckBox(ReferencedComposite referencedComposite) {
        this(referencedComposite, 0, new Matcher[0]);
    }

    public CheckBox(String text) {
        this(null, text);
    }

    public CheckBox(Matcher<?> ... matchers) {
        this((ReferencedComposite)null, matchers);
    }

    public CheckBox(ReferencedComposite referencedComposite, Matcher<?> ... matchers) {
        this(referencedComposite, 0, matchers);
    }

    public CheckBox(ReferencedComposite referencedComposite, String text) {
        this(referencedComposite, 0, new Matcher[]{new WithMnemonicTextMatcher(text)});
    }

    public CheckBox(int index, Matcher<?> ... matchers) {
        this(null, index, matchers);
    }

    public CheckBox(ReferencedComposite referencedComposite, int index, Matcher<?> ... matchers) {
        super(referencedComposite, index, 32, matchers);
    }

    public boolean isChecked() {
        return ButtonHandler.getInstance().isSelected((Button)this.swtWidget);
    }

    public void toggle(boolean checked) {
        log.info("Select checkbox " + this.getDescriptiveText());
        if (checked) {
            if (this.isChecked()) {
                log.debug("Checkbox " + this.getDescriptiveText() + " already selected, no action performed");
                return;
            }
            log.info("Check checkbox " + this.getDescriptiveText());
            this.click();
        } else if (this.isChecked()) {
            log.info("Uncheck checkbox " + this.getDescriptiveText());
            this.click();
        } else {
            log.debug("Checkbox " + this.getDescriptiveText() + " not checked, no action performed");
            return;
        }
    }
}

