/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.rse.internal.importexport.SystemImportExportResources;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemPlugin;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemMergeContext;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.rse.internal.synchronize.filesystem.ui.FileSystemOperation;
import org.eclipse.rse.internal.synchronize.filesystem.ui.ModelGetAction;
import org.eclipse.rse.internal.synchronize.filesystem.ui.ModelMergeAction;
import org.eclipse.rse.internal.synchronize.filesystem.ui.ModelPutAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;

public class FileSystemSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String ID = "org.eclipse.rse.internal.synchronize.filesystem.participant";
    public static final String VIEWER_ID = "org.eclipse.rse.internal.synchronize.filesystem.syncViewer";
    public static final String CONTEXT_MENU_MERGE_GROUP_1 = "merge";
    public static final String CONTEXT_MENU_PUT_GROUP_1 = "put";
    public static final String CONTEXT_MENU_GET_GROUP_1 = "get";
    public static final String CONTEXT_MENU_OVERWRITE_GROUP_1 = "overwrite";

    public FileSystemSynchronizeParticipant() {
    }

    public FileSystemSynchronizeParticipant(SynchronizationContext context) {
        super(context);
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            TeamUIPlugin.log((CoreException)e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        configuration.addLabelDecorator((ILabelDecorator)new FileSystemParticipantLabelDecorator());
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new FileSystemParticipantActionGroup();
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) {
        return new FileSystemMergeContext(manager);
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return FileSystemOperation.createScopeManager(this.getName(), mappings);
    }

    public class FileSystemParticipantActionGroup
    extends ModelSynchronizeParticipantActionGroup {
        private ModelPutAction putAction;
        private ModelGetAction getAction;
        private ModelMergeAction mergeAction;

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.putAction = new ModelPutAction("", configuration);
            this.getAction = new ModelGetAction("", configuration);
            this.mergeAction = new ModelMergeAction("", configuration);
        }

        public void fillContextMenu(IMenuManager menu) {
            try {
                TreeSelection selection = (TreeSelection)this.getConfiguration().getSite().getSelectionProvider().getSelection();
                boolean hasOutgoingChange = false;
                boolean hasIncomingChange = false;
                boolean hasConflictingChange = false;
                boolean hasSingleResource = selection.size() == 1;
                ArrayList<IResource> resources = new ArrayList<IResource>();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    resources.add(Utils.getResource(iterator.next()));
                }
                for (IResource resource : resources) {
                    SyncInfo info = FileSystemSubscriber.getInstance().getSyncInfo(resource);
                    int kind = info.getKind();
                    if (SyncInfo.getDirection((int)kind) == 4) {
                        hasOutgoingChange = true;
                        continue;
                    }
                    if (SyncInfo.getDirection((int)kind) == 8) {
                        hasIncomingChange = true;
                        continue;
                    }
                    if (SyncInfo.getDirection((int)kind) != 12) continue;
                    hasConflictingChange = true;
                }
                if (hasConflictingChange) {
                    if (hasSingleResource) {
                        this.mergeAction.setText(SystemImportExportResources.RESID_SYNCHRONIZE_ACTIONS_MERGE_LABEL);
                    } else {
                        this.mergeAction.setText(SystemImportExportResources.RESID_SYNCHRONIZE_ACTIONS_MERGE_ALL_LABEL);
                    }
                    this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", FileSystemSynchronizeParticipant.CONTEXT_MENU_MERGE_GROUP_1, (IAction)this.putAction);
                    menu.appendToGroup(FileSystemSynchronizeParticipant.CONTEXT_MENU_MERGE_GROUP_1, (IAction)this.mergeAction);
                }
                if (hasOutgoingChange) {
                    if (hasSingleResource) {
                        this.putAction.setText(SystemImportExportResources.RESID_SYNCHRONIZE_ACTIONS_PUT_LABEL);
                    } else {
                        this.putAction.setText(SystemImportExportResources.RESID_SYNCHRONIZE_ACTIONS_PUT_ALL_LABEL);
                    }
                    this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", FileSystemSynchronizeParticipant.CONTEXT_MENU_PUT_GROUP_1, (IAction)this.putAction);
                    menu.appendToGroup(FileSystemSynchronizeParticipant.CONTEXT_MENU_PUT_GROUP_1, (IAction)this.putAction);
                }
                if (hasIncomingChange) {
                    if (hasSingleResource) {
                        this.getAction.setText(SystemImportExportResources.RESID_SYNCHRONIZE_ACTIONS_GET_LABEL);
                    } else {
                        this.getAction.setText(SystemImportExportResources.RESID_SYNCHRONIZE_ACTIONS_GET_ALL_LABEL);
                    }
                    this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", FileSystemSynchronizeParticipant.CONTEXT_MENU_GET_GROUP_1, (IAction)this.getAction);
                    menu.appendToGroup(FileSystemSynchronizeParticipant.CONTEXT_MENU_GET_GROUP_1, (IAction)this.getAction);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class FileSystemParticipantLabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            try {
                SyncInfo info;
                IResourceVariant variant;
                IResource resource;
                if (element instanceof ISynchronizeModelElement && (resource = ((ISynchronizeModelElement)element).getResource()) != null && resource.getType() == 1 && (variant = (info = FileSystemSubscriber.getInstance().getSyncInfo(resource)).getRemote()) != null) {
                    return String.valueOf(text) + " (" + variant.getContentIdentifier() + ")";
                }
            }
            catch (TeamException e) {
                FileSystemPlugin.log((CoreException)((Object)e));
            }
            return null;
        }
    }
}

