/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure.locator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.DBorderedNodeFigure;

public class DBorderItemLocator
extends BorderItemLocator {
    private static final int NB_SIDES = 4;
    private Dimension leftTopOffset;
    private Dimension rightBottomOffset;
    private boolean located;
    private boolean borderItemHasMoved;
    private List<IFigure> figuresToIgnoreDuringNextRelocate = new ArrayList<IFigure>();

    public DBorderItemLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public DBorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public DBorderItemLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public void setRightBottomOffset(Dimension rightBottomOffset) {
        this.rightBottomOffset = rightBottomOffset;
    }

    public Dimension getRightBottomOffset() {
        if (this.rightBottomOffset != null) {
            return this.rightBottomOffset;
        }
        return this.getBorderItemOffset();
    }

    public void setLeftTopOffset(Dimension leftTopOffset) {
        this.leftTopOffset = leftTopOffset;
    }

    public Dimension getLeftTopOffset() {
        if (this.leftTopOffset != null) {
            return this.leftTopOffset;
        }
        return this.getBorderItemOffset();
    }

    protected Point getPreferredLocation(IFigure borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        return ptAbsoluteLocation;
    }

    public void relocate(IFigure borderItem) {
        Rectangle parentBounds = this.getParentFigure().getBounds().getCopy();
        if (parentBounds.x != 0 || parentBounds.y != 0 || parentBounds.width > 0 || parentBounds.height > 0) {
            Dimension size = this.getSize(borderItem);
            Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
            BitSet authorizedSides = this.getAuthorizedSides(borderItem);
            if (this.borderItemHasMoved) {
                int closestSide = DBorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder(), authorizedSides);
                this.setPreferredSideOfParent(closestSide);
                this.borderItemHasMoved = false;
            } else {
                this.figuresToIgnoreDuringNextRelocate.clear();
            }
            Point ptNewLocation = this.locateOnBorder(rectSuggested, this.getCurrentSideOfParent(), 4 - this.getNumberOfAuthorizedSides(authorizedSides), borderItem, this.figuresToIgnoreDuringNextRelocate, new ArrayList<IFigure>());
            borderItem.setLocation(ptNewLocation);
            this.figuresToIgnoreDuringNextRelocate.clear();
            borderItem.setSize(size);
            this.located = true;
        }
    }

    private BitSet getAuthorizedSides(IFigure borderItem) {
        BitSet authorizedSides;
        if (borderItem instanceof DBorderedNodeFigure) {
            authorizedSides = ((DBorderedNodeFigure)borderItem).getAuthorizedSides();
            if (authorizedSides.isEmpty()) {
                authorizedSides = this.initDefaultAuthorizedSides();
            }
        } else {
            authorizedSides = this.initDefaultAuthorizedSides();
        }
        return authorizedSides;
    }

    private BitSet initDefaultAuthorizedSides() {
        BitSet authorizedSides = new BitSet(29);
        authorizedSides.set(8);
        authorizedSides.set(4);
        authorizedSides.set(16);
        authorizedSides.set(1);
        return authorizedSides;
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        ArrayList<IFigure> figuresToIgnore = new ArrayList<IFigure>();
        figuresToIgnore.add(borderItem);
        return this.locateOnBorder(new Rectangle(suggestedLocation, this.getSize(borderItem)), suggestedSide, circuitCount, borderItem, figuresToIgnore, new ArrayList<IFigure>());
    }

    protected Point locateOnBorder(Rectangle suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        Rectangle newRecommendedLocationBounds = new Rectangle(recommendedLocation, suggestedLocation.getSize());
        if (circuitCount < 4 && this.conflicts(newRecommendedLocationBounds, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection).some()) {
            recommendedLocation = suggestedSide == 8 ? this.locateOnWestBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : (suggestedSide == 4 ? this.locateOnSouthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : (suggestedSide == 16 ? this.locateOnEastBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : this.locateOnNorthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection)));
        }
        return recommendedLocation;
    }

    protected Point locateOnSouthBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightHorizontalGap = 0;
        int leftHorizontalGap = 0;
        int next = this.getNextAuthorizedSide(4, borderItem);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightHorizontalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(rightTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == rightTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (rightTestPoint.x + (rightHorizontalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x) + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft && resultLocation == null) {
                leftTestPoint.x -= leftHorizontalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(leftTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == leftTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (leftTestPoint.x - (leftHorizontalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1)) < this.getParentBorder().getTopLeft().x) {
                        isStillFreeSpaceToTheLeft = false;
                    }
                } else {
                    resultLocation = leftTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft || isStillFreeSpaceToTheRight) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 16) continue;
            recommendedLocationForNextSide = new Point(rightTestPoint.x + rightHorizontalGap, ((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnNorthBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightHorizontalGap = 0;
        int leftHorizontalGap = 0;
        int next = this.getNextAuthorizedSide(1, borderItem);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightHorizontalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(rightTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == rightTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (rightTestPoint.x + (rightHorizontalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x) + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft && resultLocation == null) {
                leftTestPoint.x -= leftHorizontalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(leftTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == leftTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (leftTestPoint.x - (leftHorizontalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1)) < this.getParentBorder().getTopLeft().x) {
                        isStillFreeSpaceToTheLeft = false;
                    }
                } else {
                    resultLocation = leftTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft || isStillFreeSpaceToTheRight) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 8) continue;
            recommendedLocationForNextSide = new Point(leftTestPoint.x - leftHorizontalGap, ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height + 1);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnWestBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        int next = this.getNextAuthorizedSide(8, borderItem);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(belowTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == belowTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (belowTestPoint.y + (belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1) + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (isStillFreeSpaceAbove && resultLocation == null) {
                aboveTestPoint.y -= aboveVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(aboveTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == aboveTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (aboveTestPoint.y - (aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1)) < this.getParentBorder().getTopRight().y) {
                        isStillFreeSpaceAbove = false;
                    }
                } else {
                    resultLocation = aboveTestPoint;
                }
            }
            if (isStillFreeSpaceBelow || isStillFreeSpaceAbove) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 4) continue;
            recommendedLocationForNextSide = new Point(belowTestPoint.x + ((Rectangle)optionalConflictingRectangle.get()).width + 1, belowTestPoint.y + belowVerticalGap);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnEastBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        int next = this.getNextAuthorizedSide(16, borderItem);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(belowTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == aboveTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (belowTestPoint.y + (belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1) + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (isStillFreeSpaceAbove && resultLocation == null) {
                aboveTestPoint.y -= aboveVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(aboveTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == aboveTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (aboveTestPoint.y - (aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1)) < this.getParentBorder().getTopRight().y) {
                        isStillFreeSpaceAbove = false;
                    }
                } else {
                    resultLocation = aboveTestPoint;
                }
            }
            if (isStillFreeSpaceBelow || isStillFreeSpaceAbove) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 1) continue;
            recommendedLocationForNextSide = new Point(((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1, aboveTestPoint.y - aboveVerticalGap);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnParent(Rectangle suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = suggestedLocation.getSize();
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (this.getBorderItemOffset().equals((Object)IBorderItemOffsets.NO_OFFSET)) {
                if (suggestedLocation.y + borderItemSize.height < parentFigureY) {
                    newY = parentFigureY - borderItemSize.height;
                } else if (suggestedLocation.y > bounds.getBottomRight().y) {
                    newY = bounds.getBottomRight().y;
                }
            } else if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (this.getBorderItemOffset().equals((Object)IBorderItemOffsets.NO_OFFSET)) {
                if (suggestedLocation.y + borderItemSize.height < parentFigureY) {
                    newY = parentFigureY - borderItemSize.height;
                } else if (suggestedLocation.y > bounds.getBottomRight().y) {
                    newY = bounds.getBottomRight().y;
                }
            } else if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (this.getBorderItemOffset().equals((Object)IBorderItemOffsets.NO_OFFSET)) {
                if (suggestedLocation.x + borderItemSize.width < parentFigureX) {
                    newX = parentFigureX - borderItemSize.width;
                } else if (suggestedLocation.x > bounds.getBottomRight().x) {
                    newX = bounds.getBottomRight().x;
                }
            } else if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (this.getBorderItemOffset().equals((Object)IBorderItemOffsets.NO_OFFSET)) {
                if (suggestedLocation.x + borderItemSize.width < parentFigureX) {
                    newX = parentFigureX - borderItemSize.width;
                } else if (suggestedLocation.x > bounds.getBottomRight().x) {
                    newX = bounds.getBottomRight().x;
                }
            } else if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        }
        return new Point(newX, newY);
    }

    protected Option<Rectangle> conflicts(Rectangle recommendedRect, final IFigure targetBorderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Option<Rectangle> conflictedRectangle = this.conflicts(recommendedRect, this.getBrotherFigures(targetBorderItem), portsFiguresToIgnore);
        if (!conflictedRectangle.some() && additionalFiguresForConflictDetection != null && additionalFiguresForConflictDetection.size() > 0) {
            Iterable feedbackFigures = Iterables.transform(additionalFiguresForConflictDetection, (Function)new Function<IFigure, IFigure>(){

                public IFigure apply(IFigure input) {
                    Rectangle newBounds = new Rectangle(input.getBounds());
                    input.translateToAbsolute((Translatable)newBounds);
                    targetBorderItem.translateToRelative((Translatable)newBounds);
                    input.setBounds(newBounds);
                    return input;
                }
            });
            conflictedRectangle = this.conflicts(recommendedRect, Lists.newArrayList((Iterable)feedbackFigures), portsFiguresToIgnore);
            for (IFigure figure : additionalFiguresForConflictDetection) {
                Rectangle newBounds = new Rectangle(figure.getBounds());
                targetBorderItem.translateToAbsolute((Translatable)newBounds);
                figure.translateToRelative((Translatable)newBounds);
                figure.setBounds(newBounds);
            }
        }
        return conflictedRectangle;
    }

    protected List<IFigure> getBrotherFigures(IFigure targetBorderItem) {
        Iterable brotherFigures = Iterables.filter((Iterable)targetBorderItem.getParent().getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IFigure.class), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)targetBorderItem))));
        return Lists.newArrayList((Iterable)brotherFigures);
    }

    protected Option<Rectangle> conflicts(Rectangle recommendedRect, List<IFigure> figuresToCheck, Collection<IFigure> portsFiguresToIgnore) {
        ListIterator<IFigure> iterator = figuresToCheck.listIterator();
        while (iterator.hasNext()) {
            IFigure borderItem = iterator.next();
            if (portsFiguresToIgnore.contains(borderItem)) continue;
            boolean takeIntoAccount = true;
            if (borderItem.getParent().getLayoutManager() == null) {
                if (!(borderItem.getParent() instanceof Layer)) {
                    takeIntoAccount = false;
                }
            } else if (borderItem.getParent().getLayoutManager().getConstraint(borderItem) instanceof DBorderItemLocator) {
                DBorderItemLocator airBorderItemLocator = (DBorderItemLocator)((Object)borderItem.getParent().getLayoutManager().getConstraint(borderItem));
                boolean bl = takeIntoAccount = airBorderItemLocator.located && !airBorderItemLocator.borderItemHasMoved;
            }
            if (!borderItem.isVisible() || !takeIntoAccount) continue;
            Rectangle rect = new Rectangle(borderItem.getBounds());
            if (portsFiguresToIgnore.contains(borderItem) || !rect.intersects(recommendedRect)) continue;
            return Options.newSome((Object)rect);
        }
        return Options.newNone();
    }

    public void setConstraint(Rectangle theConstraint) {
        if (!theConstraint.equals((Object)this.getConstraint())) {
            this.borderItemHasMoved = true;
        }
        super.setConstraint(theConstraint);
    }

    public Rectangle getCurrentConstraint() {
        return super.getConstraint().getCopy();
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        return DBorderItemLocator.findClosestSideOfParent(proposedLocation, parentBorder, null);
    }

    private static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder, BitSet authorizedSides) {
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        boolean northAuthorized = true;
        boolean southAuthorized = true;
        boolean eastAuthorized = true;
        boolean westAuthorized = true;
        if (authorizedSides != null && !authorizedSides.isEmpty()) {
            northAuthorized = DBorderItemLocator.isAuthorized(authorizedSides, 1);
            southAuthorized = DBorderItemLocator.isAuthorized(authorizedSides, 4);
            eastAuthorized = DBorderItemLocator.isAuthorized(authorizedSides, 16);
            westAuthorized = DBorderItemLocator.isAuthorized(authorizedSides, 8);
        }
        int position = !eastAuthorized || DBorderItemLocator.canHandleWestSide(parentCenter, childCenter, northAuthorized, southAuthorized, westAuthorized) ? DBorderItemLocator.handleWestSide(parentBorder, parentCenter, childCenter, northAuthorized, southAuthorized, westAuthorized) : DBorderItemLocator.handleEastSide(parentBorder, parentCenter, childCenter, northAuthorized, southAuthorized, eastAuthorized);
        return position;
    }

    private static boolean canHandleWestSide(Point parentCenter, Point childCenter, boolean northAuthorized, boolean southAuthorized, boolean westAuthorized) {
        return (westAuthorized || southAuthorized || northAuthorized) && childCenter.x < parentCenter.x;
    }

    private static int handleWestSide(Rectangle parentBorder, Point parentCenter, Point childCenter, boolean northAuthorized, boolean southAuthorized, boolean westAuthorized) {
        int position = !southAuthorized || (westAuthorized || northAuthorized) && childCenter.y < parentCenter.y ? DBorderItemLocator.handleNorthWest(parentBorder, childCenter, northAuthorized, westAuthorized) : DBorderItemLocator.handleSouthWest(parentBorder, childCenter, southAuthorized, westAuthorized);
        return position;
    }

    private static int handleNorthWest(Rectangle parentBorder, Point childCenter, boolean northAuthorized, boolean westAuthorized) {
        int position;
        if (!northAuthorized || !westAuthorized) {
            position = northAuthorized ? 1 : 8;
        } else {
            Point parentTopLeft = parentBorder.getTopLeft();
            position = childCenter.y < parentTopLeft.y ? 1 : (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y ? 8 : 1);
        }
        return position;
    }

    private static int handleSouthWest(Rectangle parentBorder, Point childCenter, boolean southAuthorized, boolean westAuthorized) {
        int position;
        if (!southAuthorized || !westAuthorized) {
            position = southAuthorized ? 4 : 8;
        } else {
            Point parentBottomLeft = parentBorder.getBottomLeft();
            position = childCenter.y > parentBottomLeft.y ? 4 : (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y ? 8 : 4);
        }
        return position;
    }

    private static int handleEastSide(Rectangle parentBorder, Point parentCenter, Point childCenter, boolean northAuthorized, boolean southAuthorized, boolean eastAuthorized) {
        int position = !southAuthorized || (eastAuthorized || northAuthorized) && childCenter.y < parentCenter.y ? DBorderItemLocator.handleNorthEast(parentBorder, childCenter, northAuthorized, eastAuthorized) : DBorderItemLocator.handleSouthEast(parentBorder, childCenter, southAuthorized, eastAuthorized);
        return position;
    }

    private static int handleNorthEast(Rectangle parentBorder, Point childCenter, boolean northAuthorized, boolean eastAuthorized) {
        int position;
        if (!eastAuthorized || !northAuthorized) {
            position = eastAuthorized ? 16 : 1;
        } else {
            Point parentTopRight = parentBorder.getTopRight();
            position = childCenter.y < parentTopRight.y ? 1 : (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y ? 16 : 1);
        }
        return position;
    }

    private static int handleSouthEast(Rectangle parentBorder, Point childCenter, boolean southAuthorized, boolean eastAuthorized) {
        int position;
        if (!eastAuthorized || !southAuthorized) {
            position = eastAuthorized ? 16 : 4;
        } else {
            Point parentBottomRight = parentBorder.getBottomRight();
            position = childCenter.y > parentBottomRight.y ? 4 : (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y ? 16 : 4);
        }
        return position;
    }

    private static boolean isAuthorized(BitSet authorizedSides, int side) {
        return authorizedSides.get(side);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        BitSet authorizedSides = this.getAuthorizedSides(borderItem);
        int side = DBorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder(), authorizedSides);
        ArrayList<IFigure> figuresToIgnore = new ArrayList<IFigure>();
        figuresToIgnore.add(borderItem);
        Point newTopLeft = this.locateOnBorder(proposedLocation, side, 4 - this.getNumberOfAuthorizedSides(authorizedSides), borderItem, figuresToIgnore, new ArrayList<IFigure>());
        Rectangle realLocation = proposedLocation.getCopy();
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public void unfix() {
        this.located = false;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem, Collection<IFigure> figuresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        BitSet authorizedSides = this.getAuthorizedSides(borderItem);
        int side = DBorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder(), authorizedSides);
        Point newTopLeft = this.locateOnBorder(proposedLocation, side, 4 - this.getNumberOfAuthorizedSides(authorizedSides), borderItem, figuresToIgnore, additionalFiguresForConflictDetection);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public void setFiguresToIgnoresDuringNextRelocate(List<IFigure> figuresToIgnore) {
        this.figuresToIgnoreDuringNextRelocate = figuresToIgnore;
    }

    public void resetBorderItemMovedState() {
        this.borderItemHasMoved = false;
    }

    private int getNextAuthorizedSide(int currentSide, IFigure borderNode) {
        return this.getNextAuthorizedSide(currentSide, currentSide, this.getAuthorizedSides(borderNode));
    }

    private int getNextAuthorizedSide(int currentSide, int initialSide, BitSet authorizedSides) {
        int nextAuthorized = 0;
        int nextSide = this.getNextSide(currentSide);
        if (initialSide != nextSide) {
            nextAuthorized = authorizedSides.get(nextSide) ? nextSide : this.getNextAuthorizedSide(nextSide, initialSide, authorizedSides);
        }
        return nextAuthorized;
    }

    private int getNextSide(int current) {
        int next = 0;
        switch (current) {
            case 8: {
                next = 4;
                break;
            }
            case 4: {
                next = 16;
                break;
            }
            case 16: {
                next = 1;
                break;
            }
            case 1: {
                next = 8;
                break;
            }
        }
        return next;
    }

    private int getNumberOfAuthorizedSides(BitSet authorizedSides) {
        if (authorizedSides != null) {
            return authorizedSides.cardinality();
        }
        return 4;
    }
}

