/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.AutoSizeAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.ui.IWorkbenchPage;

public class SiriusAutoSizeAction
extends AutoSizeAction {
    public SiriusAutoSizeAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected Command getCommand(Request request) {
        boolean foundNonAutosizedPart = false;
        List operationSet = this.getOperationSet();
        Iterator editParts = operationSet.iterator();
        CompoundCommand command = new CompoundCommand(this.getCommandLabel());
        while (editParts.hasNext()) {
            EditPart editPart = (EditPart)editParts.next();
            if (this.concernRegion(editPart)) {
                foundNonAutosizedPart = true;
            } else if (editPart instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                Integer containerWidth = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer containerHeight = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                if (containerWidth != -1 || containerHeight != -1) {
                    foundNonAutosizedPart = true;
                }
            }
            Command curCommand = editPart.getCommand(request);
            if (curCommand == null) continue;
            command.add(curCommand);
        }
        return command.isEmpty() || command.size() != operationSet.size() || !foundNonAutosizedPart ? UnexecutableCommand.INSTANCE : command;
    }

    private boolean concernRegion(EditPart hostPart) {
        if (hostPart instanceof AbstractDiagramContainerEditPart && ((AbstractDiagramContainerEditPart)hostPart).isRegionContainer()) {
            return ((AbstractDiagramContainerEditPart)hostPart).getResizableCompartments().stream().flatMap(el -> ((ResizableCompartmentEditPart)el).getChildren().stream()).filter(AbstractDiagramElementContainerEditPart.class::isInstance).filter(el -> {
                Integer containerWidth = (Integer)((AbstractDiagramElementContainerEditPart)el).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer containerHeight = (Integer)((AbstractDiagramElementContainerEditPart)el).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                return containerWidth != -1 || containerHeight != -1;
            }).findFirst().isPresent();
        }
        return false;
    }
}

