/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.context;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.context.IndexingService;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.StatisticsHelper;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;

public interface IQueryRuntimeContext {
    public IQueryMetaContext getMetaContext();

    public <V> V coalesceTraversals(Callable<V> var1) throws InvocationTargetException;

    public boolean isCoalescing();

    public boolean isIndexed(IInputKey var1, IndexingService var2);

    public void ensureIndexed(IInputKey var1, IndexingService var2);

    public int countTuples(IInputKey var1, TupleMask var2, ITuple var3);

    public Optional<Long> estimateCardinality(IInputKey var1, TupleMask var2, Accuracy var3);

    default public Optional<Double> estimateAverageBucketSize(IInputKey key, TupleMask groupMask, Accuracy requiredAccuracy) {
        if (key.isEnumerable()) {
            return StatisticsHelper.estimateAverageBucketSize(groupMask, requiredAccuracy, (mask, accuracy) -> this.estimateCardinality(key, (TupleMask)mask, (Accuracy)((Object)accuracy)));
        }
        return groupMask.isIdentity() ? Optional.of(1.0) : Optional.empty();
    }

    public Iterable<Tuple> enumerateTuples(IInputKey var1, TupleMask var2, ITuple var3);

    public Iterable<? extends Object> enumerateValues(IInputKey var1, TupleMask var2, ITuple var3);

    public boolean containsTuple(IInputKey var1, ITuple var2);

    public void addUpdateListener(IInputKey var1, Tuple var2, IQueryRuntimeContextListener var3);

    public void removeUpdateListener(IInputKey var1, Tuple var2, IQueryRuntimeContextListener var3);

    public Object wrapElement(Object var1);

    public Object unwrapElement(Object var1);

    public Tuple wrapTuple(Tuple var1);

    public Tuple unwrapTuple(Tuple var1);

    public void ensureWildcardIndexing(IndexingService var1);

    public void executeAfterTraversal(Runnable var1) throws InvocationTargetException;
}

