/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories.timely;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.AbstractTimelyTrivialMaskedMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public final class TimelyNullaryMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends AbstractTimelyTrivialMaskedMemory<Timestamp> {
    protected static final Set<Tuple> UNIT_RELATION = Collections.singleton(Tuples.staticArityFlatTupleOf());
    protected static final Set<Tuple> EMPTY_RELATION = Collections.emptySet();

    public TimelyNullaryMaskedTupleMemory(TupleMask mask, Object owner) {
        super(mask, owner);
        if (mask.getSize() != 0) {
            throw new IllegalArgumentException(mask.toString());
        }
    }

    @Override
    public int getKeysetSize() {
        return this.memory.isEmpty() ? 0 : 1;
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return this.memory.isEmpty() ? EMPTY_RELATION : UNIT_RELATION;
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        if (signature.getSize() == 0) {
            return this.memory.keySet();
        }
        return null;
    }

    @Override
    public Map<Tuple, Timestamp> getWithTimestamp(ITuple signature) {
        if (signature.getSize() == 0) {
            return this.memory.asMap();
        }
        return null;
    }

    @Override
    public TimestampReplacement<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        try {
            return this.memory.remove(tuple, timestamp);
        }
        catch (IllegalStateException e) {
            throw this.raiseDuplicateDeletion(tuple);
        }
    }

    @Override
    public TimestampReplacement<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        return this.memory.put(tuple, timestamp);
    }
}

