/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication.timeless;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.query.runtime.rete.index.DualInputNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.index.IterableIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.timeless.RecursiveCommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.timeless.SingletonCommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.BehaviorChangingMailbox;

public class TimelessCommunicationTracker
extends CommunicationTracker {
    @Override
    protected CommunicationGroup createGroup(Node representative, int index) {
        boolean isSingleton = this.sccInformationProvider.sccs.getPartition((Object)representative).size() == 1;
        boolean isReceiver = representative instanceof Receiver;
        boolean isPosetIndifferent = isReceiver && ((Receiver)representative).getMailbox() instanceof BehaviorChangingMailbox;
        boolean isSingletonInDRedMode = isSingleton && representative instanceof RederivableNode && ((RederivableNode)representative).isInDRedMode();
        CommunicationGroup group = null;
        group = isSingleton && (isPosetIndifferent || !isReceiver) && !isSingletonInDRedMode ? new SingletonCommunicationGroup(this, representative, index) : new RecursiveCommunicationGroup(this, representative, index);
        return group;
    }

    @Override
    public Mailbox proxifyMailbox(Node requester, Mailbox original) {
        return original;
    }

    @Override
    public IndexerListener proxifyIndexerListener(Node requester, IndexerListener original) {
        return original;
    }

    @Override
    protected void postProcessNode(Node node) {
        Mailbox mailbox;
        if (node instanceof Receiver && (mailbox = ((Receiver)node).getMailbox()) instanceof BehaviorChangingMailbox) {
            CommunicationGroup group = (CommunicationGroup)this.groupMap.get(node);
            Set sccNodes = this.sccInformationProvider.sccs.getPartition((Object)node);
            boolean c1 = group.isRecursive();
            boolean c2 = this.isAtSCCBoundary(node);
            boolean c3 = sccNodes.size() > 1;
            ((BehaviorChangingMailbox)mailbox).setSplitFlag(c1 && c2 && c3);
        }
    }

    private boolean isAtSCCBoundary(Node node) {
        CommunicationGroup ownGroup = (CommunicationGroup)this.groupMap.get(node);
        assert (ownGroup != null);
        for (Node source : this.dependencyGraph.getSourceNodes((Object)node).distinctValues()) {
            HashSet<Node> sourcesToCheck = new HashSet<Node>();
            sourcesToCheck.add(source);
            if (source instanceof DualInputNode) {
                Indexer secondarySlot;
                DualInputNode dualInput = (DualInputNode)source;
                IterableIndexer primarySlot = dualInput.getPrimarySlot();
                if (primarySlot != null) {
                    sourcesToCheck.add(primarySlot.getActiveNode());
                }
                if ((secondarySlot = dualInput.getSecondarySlot()) != null) {
                    sourcesToCheck.add(secondarySlot.getActiveNode());
                }
            }
            for (Node current : sourcesToCheck) {
                CommunicationGroup otherGroup = (CommunicationGroup)this.groupMap.get(current);
                assert (otherGroup != null);
                if (ownGroup.equals(otherGroup)) continue;
                return true;
            }
        }
        return false;
    }
}

