/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.hover;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.ide.server.hover.HoverContext;
import org.eclipse.xtext.ide.server.hover.IHoverService;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class HoverService
implements IHoverService {
    @Inject
    @Extension
    private DocumentExtensions _documentExtensions;
    @Inject
    @Extension
    private EObjectAtOffsetHelper _eObjectAtOffsetHelper;
    @Inject
    @Extension
    private ILocationInFileProvider _iLocationInFileProvider;
    @Inject
    @Extension
    private IEObjectDocumentationProvider _iEObjectDocumentationProvider;

    @Override
    public Hover hover(Document document, XtextResource resource, TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        int offset = document.getOffSet(params.getPosition());
        HoverContext context = this.createContext(document, resource, offset);
        return this.hover(context);
    }

    protected HoverContext createContext(Document document, XtextResource resource, int offset) {
        EObject crossLinkedEObject = this._eObjectAtOffsetHelper.resolveCrossReferencedElementAt(resource, offset);
        if (crossLinkedEObject != null) {
            boolean _eIsProxy = crossLinkedEObject.eIsProxy();
            if (_eIsProxy) {
                return null;
            }
            IParseResult parseResult = resource.getParseResult();
            if (parseResult == null) {
                return null;
            }
            ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset);
            if (leafNode != null && leafNode.isHidden() && leafNode.getOffset() == offset) {
                leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)(offset - 1));
            }
            if (leafNode == null) {
                return null;
            }
            ITextRegion leafRegion = leafNode.getTextRegion();
            return new HoverContext(document, resource, offset, leafRegion, crossLinkedEObject);
        }
        EObject element = this._eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (element == null) {
            return null;
        }
        ITextRegion region = this._iLocationInFileProvider.getSignificantTextRegion(element);
        return new HoverContext(document, resource, offset, region, element);
    }

    protected Hover hover(HoverContext context) {
        if (context == null) {
            return IHoverService.EMPTY_HOVER;
        }
        List<Either<String, MarkedString>> contents = this.getContents(context);
        if (contents == null) {
            return IHoverService.EMPTY_HOVER;
        }
        Range range = this.getRange(context);
        if (range == null) {
            return IHoverService.EMPTY_HOVER;
        }
        return new Hover(contents, range);
    }

    protected Range getRange(HoverContext it) {
        boolean _not;
        boolean _contains = it.getRegion().contains(it.getOffset());
        boolean bl = _not = !_contains;
        if (_not) {
            return null;
        }
        return this._documentExtensions.newRange((Resource)it.getResource(), it.getRegion());
    }

    protected List<Either<String, MarkedString>> getContents(HoverContext it) {
        String language = this.getLanguage(it);
        Functions.Function1 _function = value -> this.toContents(language, (String)value);
        return ListExtensions.map(this.getContents(it.getElement()), (Functions.Function1)_function);
    }

    protected String getLanguage(HoverContext it) {
        return null;
    }

    protected Either<String, MarkedString> toContents(String language, String value) {
        if (language == null) {
            return Either.forLeft((Object)value);
        }
        MarkedString _markedString = new MarkedString(language, value);
        return Either.forRight((Object)_markedString);
    }

    public List<String> getContents(EObject element) {
        if (element == null) {
            return Collections.emptyList();
        }
        String documentation = this._iEObjectDocumentationProvider.getDocumentation(element);
        if (documentation == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{documentation}));
    }
}

