/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

class DAAdvertisement
extends ReplyMessage {
    int errorCode;
    int statelessBootTimestamp;
    String url;
    List scopeList;
    List attrList;
    String spi;
    private String origURL;
    private String origAttrs;
    private String origScopes;
    AuthenticationBlock[] authBlocks;

    DAAdvertisement(DataInputStream input) throws ServiceLocationException, IOException {
        int pos;
        this.errorCode = input.readShort();
        this.statelessBootTimestamp = input.readInt();
        this.origURL = input.readUTF().trim();
        if (!this.origURL.equals("")) {
            this.url = this.origURL.substring(this.origURL.indexOf("//") + 2, this.origURL.length());
        }
        if ((pos = this.url.indexOf(":")) > -1) {
            this.url = this.url.substring(0, pos);
        }
        this.origScopes = input.readUTF();
        this.scopeList = DAAdvertisement.stringToList(this.origScopes, ",");
        if (this.scopeList.isEmpty()) {
            throw new ServiceLocationException(2, "received DAadvert with empty scope list");
        }
        this.origAttrs = input.readUTF();
        this.attrList = this.attributeStringToList(this.origAttrs);
        this.spi = input.readUTF();
        this.authBlocks = AuthenticationBlock.parse(input);
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "could not verify " + this.toString());
        }
    }

    protected void writeTo(DataOutputStream out) throws IOException {
    }

    int getSize() {
        int len = this.getHeaderSize() + 8 + this.origURL.length() + 2 + this.origScopes.length() + 2 + this.origAttrs.length() + 2 + this.spi.length() + 1;
        int i = 0;
        while (i < this.authBlocks.length) {
            len += this.authBlocks[i].getLength();
            ++i;
        }
        return len;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(", errorCode " + this.errorCode);
        buffer.append(", statelessBootTimestamp " + this.statelessBootTimestamp);
        buffer.append(", url " + this.url);
        buffer.append(", scopeList " + this.scopeList);
        buffer.append(", attrList " + this.attrList);
        buffer.append(", spi " + this.spi);
        return buffer.toString();
    }

    boolean verify() throws ServiceLocationException {
        int i = 0;
        while (i < this.authBlocks.length) {
            if (this.authBlocks[i].verify(this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private byte[] getAuthData(String spiStr, int timestamp) throws ServiceLocationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(spiStr);
            dos.writeInt(this.statelessBootTimestamp);
            dos.writeUTF(this.origURL);
            dos.writeUTF(this.origScopes);
            dos.writeUTF(this.origAttrs);
            dos.writeUTF(this.spi);
            dos.writeInt(timestamp);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ServiceLocationException(20, ioe.getMessage());
        }
    }

    List getResult() {
        return this.scopeList;
    }
}

