/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AttributeReply;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.DAAdvertisement;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.ServiceAcknowledgement;
import ch.ethz.iks.slp.impl.ServiceDeregistration;
import ch.ethz.iks.slp.impl.ServiceRegistration;
import ch.ethz.iks.slp.impl.ServiceReply;
import ch.ethz.iks.slp.impl.ServiceRequest;
import ch.ethz.iks.slp.impl.ServiceTypeReply;
import ch.ethz.iks.slp.impl.ServiceTypeRequest;
import ch.ethz.iks.slp.impl.attr.AttributeListVisitor;
import ch.ethz.iks.slp.impl.attr.gen.Parser;
import ch.ethz.iks.slp.impl.attr.gen.ParserException;
import ch.ethz.iks.slp.impl.attr.gen.Rule;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class SLPMessage {
    Locale locale;
    byte funcID;
    short xid;
    InetAddress address;
    int port;
    boolean tcp;
    boolean multicast;
    public static final byte SRVRQST = 1;
    public static final byte SRVRPLY = 2;
    public static final byte SRVREG = 3;
    public static final byte SRVDEREG = 4;
    public static final byte SRVACK = 5;
    public static final byte ATTRRQST = 6;
    public static final byte ATTRRPLY = 7;
    public static final byte DAADVERT = 8;
    public static final byte SRVTYPERQST = 9;
    public static final byte SRVTYPERPLY = 10;
    public static final byte SAADVERT = 11;
    private static final String[] TYPES = new String[]{"NULL", "SRVRQST", "SRVPLY", "SRVREG", "SRVDEREG", "SRVACK", "ATTRRQST", "ATTRRPLY", "DAADVERT", "SRVTYPERQST", "SRVTYPERPLY", "SAADVERT"};

    protected void writeHeader(DataOutputStream out, int msgSize) throws IOException {
        int flags = 0;
        if (this.funcID == 3) {
            flags = (byte)(flags | 0x40);
        }
        if (this.multicast) {
            flags = (byte)(flags | 0x20);
        }
        if (!this.tcp && msgSize > SLPCore.CONFIG.getMTU()) {
            flags = (byte)(flags | 0x80);
        }
        out.write(2);
        out.write(this.funcID);
        out.write((byte)(msgSize >> 16));
        out.write((byte)(msgSize >> 8 & 0xFF));
        out.write((byte)(msgSize & 0xFF));
        out.write(flags);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.writeShort(this.xid);
        out.writeUTF(this.locale.getLanguage());
    }

    abstract void writeTo(DataOutputStream var1) throws IOException;

    byte[] getBytes() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bytes);
        this.writeTo(out);
        return bytes.toByteArray();
    }

    static SLPMessage parse(InetAddress senderAddr, int senderPort, DataInputStream in, boolean tcp) throws ServiceLocationException, ProtocolException {
        try {
            SLPMessage msg;
            byte version = in.readByte();
            if (version == 1) {
                in.readByte();
                short length = in.readShort();
                byte[] drop = new byte[length - 4];
                in.readFully(drop);
                SLPCore.platform.logWarning("Dropped SLPv1 message from " + senderAddr + ":" + senderPort);
            }
            byte funcID = in.readByte();
            int length = SLPMessage.readInt(in, 3);
            byte flags = (byte)(in.readShort() >> 8);
            if (!tcp && (flags & 0x80) != 0) {
                throw new ProtocolException();
            }
            SLPMessage.readInt(in, 3);
            short xid = in.readShort();
            Locale locale = new Locale(in.readUTF(), "");
            switch (funcID) {
                case 8: {
                    msg = new DAAdvertisement(in);
                    break;
                }
                case 1: {
                    msg = new ServiceRequest(in);
                    break;
                }
                case 2: {
                    msg = new ServiceReply(in);
                    break;
                }
                case 6: {
                    msg = new AttributeRequest(in);
                    break;
                }
                case 7: {
                    msg = new AttributeReply(in);
                    break;
                }
                case 3: {
                    msg = new ServiceRegistration(in);
                    break;
                }
                case 4: {
                    msg = new ServiceDeregistration(in);
                    break;
                }
                case 5: {
                    msg = new ServiceAcknowledgement(in);
                    break;
                }
                case 9: {
                    msg = new ServiceTypeRequest(in);
                    break;
                }
                case 10: {
                    msg = new ServiceTypeReply(in);
                    break;
                }
                default: {
                    throw new ServiceLocationException(2, "Message type " + SLPMessage.getType(funcID) + " not supported");
                }
            }
            msg.address = senderAddr;
            msg.port = senderPort;
            msg.tcp = tcp;
            msg.multicast = (flags & 0x2000) >> 13 == 1;
            msg.xid = xid;
            msg.funcID = funcID;
            msg.locale = locale;
            if (msg.getSize() != length) {
                SLPCore.platform.logError("Length of " + msg + " should be " + length + ", read " + msg.getSize());
            }
            return msg;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (IOException ioe) {
            SLPCore.platform.logError("Network Error", ioe);
            throw new ServiceLocationException(19, ioe.getMessage());
        }
    }

    int getHeaderSize() {
        return 14 + this.locale.getLanguage().length();
    }

    abstract int getSize();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(SLPMessage.getType(this.funcID)) + " - ");
        buffer.append("xid=" + this.xid);
        buffer.append(", locale=" + this.locale);
        return buffer.toString();
    }

    static String getType(int type) {
        if (type > -1 && type < 12) {
            return TYPES[type];
        }
        return String.valueOf(String.valueOf(type) + " - UNSUPPORTED");
    }

    private static int readInt(DataInputStream input, int len) throws ServiceLocationException {
        try {
            int value = 0;
            int i = 0;
            while (i < len) {
                value <<= 8;
                value += input.readByte() & 0xFF;
                ++i;
            }
            return value;
        }
        catch (IOException ioe) {
            throw new ServiceLocationException(2, ioe.getMessage());
        }
    }

    static String listToString(List list, String delim) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0).toString();
        }
        StringBuffer buffer = new StringBuffer();
        Object[] elements = list.toArray();
        int i = 0;
        while (i < elements.length - 1) {
            buffer.append(elements[i]);
            buffer.append(delim);
            ++i;
        }
        buffer.append(elements[elements.length - 1]);
        return buffer.toString();
    }

    static List stringToList(String str, String delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    protected List attributeStringToList(String input) throws ServiceLocationException {
        if ("".equals(input)) {
            return new ArrayList();
        }
        Parser parser = new Parser();
        try {
            Rule parse = parser.parse("attr-list", input);
            AttributeListVisitor visitor = new AttributeListVisitor();
            parse.visit(visitor);
            return visitor.getAttributes();
        }
        catch (IllegalArgumentException e) {
            throw new ServiceLocationException(2, e.getMessage());
        }
        catch (ParserException e) {
            throw new ServiceLocationException(2, e.getMessage());
        }
    }

    protected List attributeStringToListLiberal(String input) {
        if ("".equals(input)) {
            return new ArrayList();
        }
        Parser parser = new Parser();
        Rule rule = null;
        try {
            rule = parser.parse("attr-list", input);
        }
        catch (IllegalArgumentException e) {
            SLPCore.platform.logError(e.getMessage(), e);
            return new ArrayList();
        }
        catch (ParserException e) {
            SLPCore.platform.logTraceDrop(e.getMessage());
            rule = e.getRule();
        }
        AttributeListVisitor visitor = new AttributeListVisitor();
        rule.visit(visitor);
        return visitor.getAttributes();
    }
}

