/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;

public class InternetHeaders {
    protected List headers = new ArrayList();
    private transient String lastHeaderName;

    public InternetHeaders() {
        this.addHeader("Return-path", null);
        this.addHeader("Received", null);
        this.addHeader("Message-ID", null);
        this.addHeader("Resent-Date", null);
        this.addHeader("Date", null);
        this.addHeader("Resent-From", null);
        this.addHeader("From", null);
        this.addHeader("Reply-To", null);
        this.addHeader("Sender", null);
        this.addHeader("To", null);
        this.addHeader("Subject", null);
        this.addHeader("Cc", null);
        this.addHeader("In-Reply-To", null);
        this.addHeader("Resent-Message-Id", null);
        this.addHeader("Errors-To", null);
        this.addHeader("MIME-Version", null);
        this.addHeader("Content-Type", null);
        this.addHeader("Content-Transfer-Encoding", null);
        this.addHeader("Content-MD5", null);
        this.addHeader(":", null);
        this.addHeader("Content-Length", null);
        this.addHeader("Status", null);
    }

    public InternetHeaders(InputStream in) throws MessagingException {
        this.load(in);
    }

    public void load(InputStream in) throws MessagingException {
        try {
            int c;
            StringBuffer name = new StringBuffer(32);
            StringBuffer value = new StringBuffer(128);
            block2: do {
                char ch;
                block10: {
                    c = in.read();
                    ch = (char)c;
                    if (c == -1) break;
                    if (c == 13) {
                        in.read();
                        break;
                    }
                    if (c == 10) break;
                    if (Character.isWhitespace(ch)) {
                        while ((c = in.read()) != -1) {
                            ch = (char)c;
                            if (Character.isWhitespace(ch)) continue;
                            break block10;
                        }
                        break;
                    }
                    if (name.length() > 0) {
                        this.addHeader(name.toString().trim(), value.toString().trim());
                    }
                    name.setLength(0);
                    value.setLength(0);
                    do {
                        name.append((char)c);
                        c = in.read();
                        if (c == -1) break block2;
                    } while (c != 58);
                    c = in.read();
                    if (c == -1) break;
                }
                while (c != 13 && c != 10) {
                    ch = (char)c;
                    value.append(ch);
                    c = in.read();
                    if (c != -1) continue;
                    break block2;
                }
                if (c != 13) continue;
                c = in.read();
            } while (c != -1);
            if (name.length() > 0) {
                this.addHeader(name.toString().trim(), value.toString().trim());
            }
        }
        catch (IOException e) {
            throw new MessagingException("Error loading headers", e);
        }
    }

    public String[] getHeader(String name) {
        ArrayList<String> accumulator = new ArrayList<String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name) || header.getValue() == null) continue;
            accumulator.add(header.getValue());
        }
        if (accumulator.isEmpty()) {
            return null;
        }
        return accumulator.toArray(new String[accumulator.size()]);
    }

    public String getHeader(String name, String delimiter) {
        String[] matches = this.getHeader(name);
        if (matches == null) {
            return null;
        }
        if (matches.length == 1 || delimiter == null) {
            return matches[0];
        }
        StringBuffer result = new StringBuffer(matches[0]);
        for (int i = 1; i < matches.length; ++i) {
            result.append(delimiter);
            result.append(matches[i]);
        }
        return result.toString();
    }

    public void setHeader(String name, String value) {
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!name.equalsIgnoreCase(header.getName())) continue;
            header.setValue(value);
            this.removeHeaders(name, i + 1);
            return;
        }
        this.addHeader(name, value);
    }

    private void removeHeaders(String name, int pos) {
        for (int i = pos; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!name.equalsIgnoreCase(header.getName())) continue;
            this.headers.remove(i);
            --i;
        }
    }

    private int findHeader(String name) {
        return this.findHeader(name, 0);
    }

    private int findHeader(String name, int start) {
        for (int i = start; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (!name.equalsIgnoreCase(header.getName())) continue;
            return i;
        }
        return -1;
    }

    public void addHeader(String name, String value) {
        InternetHeader newHeader = new InternetHeader(name, value);
        if (name.equalsIgnoreCase("Received") || name.equalsIgnoreCase("Return-Path")) {
            int pos = this.findHeader(name);
            if (pos != -1) {
                InternetHeader oldHeader = (InternetHeader)this.headers.get(pos);
                if (oldHeader.getValue() == null) {
                    oldHeader.setValue(value);
                } else {
                    this.headers.add(pos, newHeader);
                }
            } else {
                this.headers.add(0, newHeader);
            }
        } else {
            int pos = this.findHeader(name);
            if (pos != -1) {
                InternetHeader oldHeader = (InternetHeader)this.headers.get(pos);
                if (oldHeader.getValue() == null) {
                    oldHeader.setValue(value);
                } else {
                    int lastPos = this.findHeader(name, pos + 1);
                    while (lastPos != -1) {
                        pos = lastPos;
                        lastPos = this.findHeader(name, pos + 1);
                    }
                    this.headers.add(pos + 1, newHeader);
                }
            } else {
                pos = this.findHeader(":");
                if (pos == -1) {
                    pos = this.headers.size();
                }
                this.headers.add(pos, newHeader);
            }
        }
    }

    public void removeHeader(String name) {
        int pos = this.findHeader(name);
        if (pos != -1) {
            InternetHeader oldHeader = (InternetHeader)this.headers.get(pos);
            oldHeader.setValue(null);
            this.removeHeaders(name, pos + 1);
        }
    }

    public Enumeration getAllHeaders() {
        ArrayList<InternetHeader> result = new ArrayList<InternetHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (header.getValue() == null) continue;
            result.add(header);
        }
        return Collections.enumeration(result);
    }

    private boolean matchHeader(String name, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (!name.equalsIgnoreCase(names[i])) continue;
            return true;
        }
        return false;
    }

    public Enumeration getMatchingHeaders(String[] names) {
        ArrayList<InternetHeader> result = new ArrayList<InternetHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (header.getValue() == null || !this.matchHeader(header.getName(), names)) continue;
            result.add(header);
        }
        return Collections.enumeration(result);
    }

    public Enumeration getNonMatchingHeaders(String[] names) {
        ArrayList<InternetHeader> result = new ArrayList<InternetHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader header = (InternetHeader)this.headers.get(i);
            if (header.getValue() == null || this.matchHeader(header.getName(), names)) continue;
            result.add(header);
        }
        return Collections.enumeration(result);
    }

    public void addHeaderLine(String line) {
        if (line.length() == 0) {
            return;
        }
        char ch = line.charAt(0);
        if (ch == ' ' || ch == '\t') {
            InternetHeader header = (InternetHeader)this.headers.get(this.headers.size() - 1);
            header.appendValue(line);
        } else {
            this.headers.add(new InternetHeader(line));
        }
    }

    public Enumeration getAllHeaderLines() {
        return new HeaderLineEnumeration(this.getAllHeaders());
    }

    public Enumeration getMatchingHeaderLines(String[] names) {
        return new HeaderLineEnumeration(this.getMatchingHeaders(names));
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) {
        return new HeaderLineEnumeration(this.getNonMatchingHeaders(names));
    }

    void setHeader(String name, Address[] addresses) {
        if (addresses.length == 0) {
            this.removeHeader(name);
        }
        this.setHeader(name, addresses[0].toString());
        for (int i = 1; i < addresses.length; ++i) {
            Address address = addresses[i];
            this.addHeader(name, address.toString());
        }
    }

    void writeTo(OutputStream out, String[] ignore) throws IOException {
        if (ignore == null) {
            for (int i = 0; i < this.headers.size(); ++i) {
                InternetHeader header = (InternetHeader)this.headers.get(i);
                if (header.getValue() == null) continue;
                header.writeTo(out);
            }
        } else {
            for (int i = 0; i < this.headers.size(); ++i) {
                InternetHeader header = (InternetHeader)this.headers.get(i);
                if (header.getValue() == null || !this.matchHeader(header.getName(), ignore)) continue;
                header.writeTo(out);
            }
        }
    }

    private static class HeaderLineEnumeration
    implements Enumeration {
        private Enumeration headers;

        public HeaderLineEnumeration(Enumeration headers) {
            this.headers = headers;
        }

        public boolean hasMoreElements() {
            return this.headers.hasMoreElements();
        }

        public Object nextElement() {
            Header h = (Header)this.headers.nextElement();
            return h.getName() + ": " + h.getValue();
        }
    }

    protected static final class InternetHeader
    extends Header {
        public InternetHeader(String h) {
            super("", "");
            int separator = h.indexOf(58);
            if (separator == -1) {
                this.name = h.trim();
            } else {
                char ch;
                this.name = h.substring(0, separator);
                ++separator;
                while (separator < h.length() && ((ch = h.charAt(separator)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n')) {
                    ++separator;
                }
                this.value = h.substring(separator);
            }
        }

        public InternetHeader(String name, String value) {
            super(name, value);
        }

        void setValue(String value) {
            this.value = value;
        }

        void appendValue(String value) {
            this.value = this.value == null ? value : this.value + "\r\n" + value;
        }

        void writeTo(OutputStream out) throws IOException {
            out.write(this.name.getBytes());
            out.write(58);
            out.write(32);
            out.write(this.value.getBytes());
            out.write(13);
            out.write(10);
        }
    }
}

