/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.transport.nmr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.servicemix.cxf.transport.nmr.NMRConduitOutputStream;
import org.apache.servicemix.nmr.api.NMR;

public class NMRConduit
extends AbstractConduit {
    private static final Logger LOG = LogUtils.getL7dLogger(NMRConduit.class);
    private NMR nmr;
    private Bus bus;

    public NMRConduit(EndpointReferenceType target, NMR nmr) {
        this(null, target, nmr);
    }

    public NMRConduit(Bus bus, EndpointReferenceType target, NMR nmr) {
        super(target);
        this.nmr = nmr;
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void prepare(Message message) throws IOException {
        this.getLogger().log(Level.FINE, "JBIConduit send message");
        message.setContent(OutputStream.class, (Object)new NMRConduitOutputStream(message, this.nmr, this.target, this));
    }
}

