/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.transport.nmr;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.servicemix.cxf.transport.nmr.NMRConduit;
import org.apache.servicemix.cxf.transport.nmr.NMRMessageHelper;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.Status;

public class NMRConduitOutputStream
extends CachedOutputStream {
    private static final Logger LOG = LogUtils.getL7dLogger(NMRConduitOutputStream.class);
    private Message message;
    private boolean isOneWay;
    private Channel channel;
    private NMRConduit conduit;
    private EndpointReferenceType target;

    public NMRConduitOutputStream(Message m, NMR nmr, EndpointReferenceType target, NMRConduit conduit) {
        this.message = m;
        this.channel = nmr.createChannel();
        this.conduit = conduit;
        this.target = target;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.isOneWay = this.message.getExchange().isOneWay();
        this.commitOutputMessage();
        if (this.target != null) {
            this.target.getClass();
        }
        this.channel.close();
    }

    private void commitOutputMessage() throws IOException {
        try {
            Member member = (Member)this.message.get((Object)Method.class.getName());
            Class<?> clz = member.getDeclaringClass();
            Exchange exchange = this.message.getExchange();
            BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            LOG.info(new org.apache.cxf.common.i18n.Message("INVOKE.SERVICE", LOG, new Object[0]).toString() + clz);
            WebService ws = clz.getAnnotation(WebService.class);
            assert (ws != null);
            QName interfaceName = new QName(ws.targetNamespace(), ws.name());
            QName serviceName = this.target != null ? EndpointReferenceUtils.getServiceName((EndpointReferenceType)this.target, (Bus)this.conduit.getBus()) : ((Service)this.message.getExchange().get(Service.class)).getName();
            LOG.info(new org.apache.cxf.common.i18n.Message("CREATE.MESSAGE.EXCHANGE", LOG, new Object[0]).toString() + serviceName);
            org.apache.servicemix.nmr.api.Exchange xchng = this.isOneWay ? this.channel.createExchange(Pattern.InOnly) : (bop.getOutput() == null ? this.channel.createExchange(Pattern.RobustInOnly) : this.channel.createExchange(Pattern.InOut));
            org.apache.servicemix.nmr.api.Message inMsg = xchng.getIn();
            LOG.info(new org.apache.cxf.common.i18n.Message("EXCHANGE.ENDPOINT", LOG, new Object[0]).toString() + serviceName);
            LOG.info("setup message contents on " + inMsg);
            inMsg.setBody((Object)this.getMessageContent(this.message));
            LOG.info("service for exchange " + serviceName);
            HashMap<String, QName> refProps = new HashMap<String, QName>();
            refProps.put("INTERFACE_NAME", interfaceName);
            refProps.put("SERVICE_NAME", serviceName);
            Reference ref = this.channel.getNMR().getEndpointRegistry().lookup(refProps);
            xchng.setTarget(ref);
            xchng.setOperation(bop.getName());
            LOG.info("sending message");
            if (!this.isOneWay) {
                this.channel.sendSync(xchng);
                Source content = null;
                content = xchng.getFault(false) != null ? (Source)xchng.getFault().getBody(Source.class) : (Source)xchng.getOut().getBody(Source.class);
                MessageImpl inMessage = new MessageImpl();
                this.message.getExchange().setInMessage((Message)inMessage);
                InputStream ins = NMRMessageHelper.convertMessageToInputStream(content);
                if (ins == null) {
                    throw new IOException(new org.apache.cxf.common.i18n.Message("UNABLE.RETRIEVE.MESSAGE", LOG, new Object[0]).toString());
                }
                inMessage.setContent(InputStream.class, (Object)ins);
                this.conduit.getMessageObserver().onMessage((Message)inMessage);
                xchng.setStatus(Status.Done);
                this.channel.send(xchng);
            } else {
                this.channel.sendSync(xchng);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            new IOException(e.toString());
        }
    }

    private Source getMessageContent(Message message2) throws IOException {
        return new StreamSource(this.getInputStream());
    }

    protected void onWrite() throws IOException {
    }
}

